/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.api.rest;

import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.odpi.openmetadata.integrationservices.api.connector.APIIntegratorConnector;
import org.odpi.openmetadata.integrationservices.api.connector.APIIntegratorOMISConnector;
import org.odpi.openmetadata.integrationservices.api.contextmanager.APIIntegratorContextManager;
import org.slf4j.LoggerFactory;

public class APIIntegratorRESTServices {
    private static final IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(APIIntegratorRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public APIIntegratorRESTServices() {
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.API_INTEGRATOR_OMIS, (String)APIIntegratorContextManager.class.getName(), (String)APIIntegratorOMISConnector.class.getName());
    }

    public ConnectorReportResponse validateConnector(String serverName, String userId, String connectorProviderClassName) {
        String methodName = "validateConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateConnector");
        ConnectorReportResponse response = new ConnectorReportResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateConnector");
            ConnectorReport connectorReport = instanceHandler.validateConnector(connectorProviderClassName, APIIntegratorConnector.class, IntegrationServiceDescription.API_INTEGRATOR_OMIS.getIntegrationServiceFullName());
            if (connectorReport != null) {
                response.setConnectorReport(connectorReport);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "validateConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

