/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.archivemanager.connector;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicRepositoryEventListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public abstract class ArchiveContext {
    protected String userId;
    protected String requestType;
    protected Map<String, String> requestParameters;
    private List<RequestSourceElement> requestSourceElements;
    private List<ActionTargetElement> actionTargetElements;

    public ArchiveContext(String userId, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements) {
        this.userId = userId;
        this.requestType = requestType;
        this.requestParameters = requestParameters;
        this.requestSourceElements = requestSourceElements;
        this.actionTargetElements = actionTargetElements;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public List<RequestSourceElement> getRequestSourceElements() {
        return this.requestSourceElements;
    }

    public List<ActionTargetElement> getActionTargetElements() {
        return this.actionTargetElements;
    }

    public abstract String getMetadataCollectionId() throws RepositoryErrorException;

    public abstract void registerListener(OMRSTopicRepositoryEventListener var1) throws InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException, ConnectionCheckedException, ConnectorCheckedException;

    public abstract void disconnectFromEnterpriseTopic() throws ConnectorCheckedException;

    public abstract TypeDefGallery getAllTypes() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract TypeDefGallery findTypesByName(String var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> findTypeDefsByCategory(TypeDefCategory var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<AttributeTypeDef> findAttributeTypeDefsByCategory(AttributeTypeDefCategory var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> findTypeDefsByProperty(TypeDefProperties var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> findTypesByExternalID(String var1, String var2, String var3) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> searchForTypeDefs(String var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract TypeDef getTypeDefByGUID(String var1) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract AttributeTypeDef getAttributeTypeDefByGUID(String var1) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract TypeDef getTypeDefByName(String var1) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract AttributeTypeDef getAttributeTypeDefByName(String var1) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract EntityDetail isEntityKnown(String var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract EntitySummary getEntitySummary(String var1) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException;

    public abstract EntityDetail getEntityDetail(String var1) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException;

    public abstract EntityDetail getEntityDetail(String var1, Date var2) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> getEntityDetailHistory(String var1, Date var2, Date var3, int var4, int var5, HistorySequencingOrder var6) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> getRelationshipsForEntity(String var1, String var2, int var3, List<InstanceStatus> var4, Date var5, String var6, SequencingOrder var7, int var8) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntities(String var1, List<String> var2, SearchProperties var3, int var4, List<InstanceStatus> var5, SearchClassifications var6, Date var7, String var8, SequencingOrder var9, int var10) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntitiesByProperty(String var1, InstanceProperties var2, MatchCriteria var3, int var4, List<InstanceStatus> var5, List<String> var6, Date var7, String var8, SequencingOrder var9, int var10) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntitiesByClassification(String var1, String var2, InstanceProperties var3, MatchCriteria var4, int var5, List<InstanceStatus> var6, Date var7, String var8, SequencingOrder var9, int var10) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntitiesByPropertyValue(String var1, String var2, int var3, List<InstanceStatus> var4, List<String> var5, Date var6, String var7, SequencingOrder var8, int var9) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract Relationship isRelationshipKnown(String var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract Relationship getRelationship(String var1) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException;

    public abstract Relationship getRelationship(String var1, Date var2) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> getRelationshipHistory(String var1, Date var2, Date var3, int var4, int var5, HistorySequencingOrder var6) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> findRelationships(String var1, List<String> var2, SearchProperties var3, int var4, List<InstanceStatus> var5, Date var6, String var7, SequencingOrder var8, int var9) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> findRelationshipsByProperty(String var1, InstanceProperties var2, MatchCriteria var3, int var4, List<InstanceStatus> var5, Date var6, String var7, SequencingOrder var8, int var9) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> findRelationshipsByPropertyValue(String var1, String var2, int var3, List<InstanceStatus> var4, Date var5, String var6, SequencingOrder var7, int var8) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void recordCompletionStatus(CompletionStatus var1, List<String> var2, Map<String, String> var3, List<NewActionTarget> var4) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException;

    public abstract CompletionStatus getCompletionStatus();

    public String toString() {
        return "ArchiveContext{userId='" + this.userId + "', requestType='" + this.requestType + "', requestParameters=" + this.requestParameters + ", requestSourceElements=" + this.requestSourceElements + ", actionTargetElements=" + this.actionTargetElements + "}";
    }
}

