/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.archivemanager.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.engineservices.archivemanager.api.ArchiveManagerAPI;
import org.odpi.openmetadata.engineservices.archivemanager.client.rest.ArchiveManagerRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ArchiveManagerClient
implements ArchiveManagerAPI {
    private String serverName;
    private String serverPlatformRootURL;
    private String archiveEngineName;
    private ArchiveManagerRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public ArchiveManagerClient(String serverPlatformRootURL, String serverName, String archiveEngineName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.archiveEngineName = archiveEngineName;
        this.restClient = new ArchiveManagerRESTClient(serverName, serverPlatformRootURL);
    }

    public ArchiveManagerClient(String serverPlatformRootURL, String serverName, String archiveEngineName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.archiveEngineName = archiveEngineName;
        this.restClient = new ArchiveManagerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public ConnectorReport validateConnector(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateConnector";
        String nameParameter = "connectorProviderClassName";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/archive-manager/users/{1}/validate-connector";
        this.invalidParameterHandler.validateUserId(userId, "validateConnector");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        ConnectorTypeResponse restResult = this.restClient.callOCFConnectorTypeGetRESTCall("validateConnector", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/archive-manager/users/{1}/validate-connector", new Object[]{this.serverName, userId, connectorProviderClassName});
        return new ConnectorReport(restResult);
    }
}

