/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.assetanalysis.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.engineservices.assetanalysis.api.AssetAnalysisAPI;
import org.odpi.openmetadata.engineservices.assetanalysis.client.rest.AssetAnalysisRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryEngine;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryEngineException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;

public class AssetAnalysisClient
extends DiscoveryEngine
implements AssetAnalysisAPI {
    private final String serverName;
    private final String serverPlatformRootURL;
    private final String discoveryEngineName;
    private final AssetAnalysisRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public AssetAnalysisClient(String serverPlatformRootURL, String serverName, String discoveryEngineName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.discoveryEngineName = discoveryEngineName;
        this.restClient = new AssetAnalysisRESTClient(serverName, serverPlatformRootURL);
    }

    public AssetAnalysisClient(String serverPlatformRootURL, String serverName, String discoveryEngineName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.discoveryEngineName = discoveryEngineName;
        this.restClient = new AssetAnalysisRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public ConnectorReport validateConnector(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateConnector";
        String nameParameter = "connectorProviderClassName";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/validate-connector";
        this.invalidParameterHandler.validateUserId(userId, "validateConnector");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        ConnectorReportResponse restResult = this.restClient.callOCFConnectorReportGetRESTCall("validateConnector", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/validate-connector", new Object[]{this.serverName, userId, connectorProviderClassName});
        return restResult.getConnectorReport();
    }

    public String discoverAsset(String userId, String assetGUID, String discoveryRequestType) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        return this.discoverAsset(userId, assetGUID, discoveryRequestType, null, null);
    }

    public String discoverAsset(String userId, String assetGUID, String discoveryRequestType, Map<String, String> analysisParameters) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        return this.discoverAsset(userId, assetGUID, discoveryRequestType, analysisParameters, null);
    }

    public String discoverAsset(String userId, String assetGUID, String discoveryRequestType, Map<String, String> analysisParameters, List<String> annotationTypes) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "discoverAsset";
        String assetGUIDParameterName = "assetGUID";
        String discoveryRequestTypeParameterName = "discoveryRequestType";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-request-types/{3}/assets/{4}";
        this.invalidParameterHandler.validateUserId(userId, "discoverAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "discoverAsset");
        this.invalidParameterHandler.validateName(discoveryRequestType, "discoveryRequestType", "discoverAsset");
        DiscoveryRequestRequestBody requestBody = new DiscoveryRequestRequestBody();
        requestBody.setAnalysisParameters(analysisParameters);
        requestBody.setAnnotationTypes(annotationTypes);
        try {
            GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("discoverAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-request-types/{3}/assets/{4}", requestBody, new Object[]{this.serverName, userId, this.discoveryEngineName, discoveryRequestType, assetGUID});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            return restResult.getGUID();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }

    public void scanAllAssets(String userId, String discoveryRequestType, Map<String, String> analysisParameters, List<String> annotationTypes) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "scanAllAssets";
        String discoveryRequestTypeParameterName = "discoveryRequestType";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-request-types/{3}/assets";
        this.invalidParameterHandler.validateUserId(userId, "scanAllAssets");
        this.invalidParameterHandler.validateName(discoveryRequestType, "discoveryRequestType", "scanAllAssets");
        DiscoveryRequestRequestBody requestBody = new DiscoveryRequestRequestBody();
        requestBody.setAnalysisParameters(analysisParameters);
        requestBody.setAnnotationTypes(annotationTypes);
        try {
            VoidResponse restResult = this.restClient.callVoidPostRESTCall("scanAllAssets", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-request-types/{3}/assets", requestBody, new Object[]{this.serverName, userId, this.discoveryEngineName, discoveryRequestType});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }

    public DiscoveryRequestStatus getDiscoveryStatus(String userId, String discoveryRequestGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        DiscoveryAnalysisReport report = this.getDiscoveryReport(userId, discoveryRequestGUID);
        if (report != null) {
            return report.getDiscoveryRequestStatus();
        }
        return null;
    }

    public DiscoveryAnalysisReport getDiscoveryReport(String userId, String discoveryRequestGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getDiscoveryAnalysisReport";
        String reportGUIDParameterName = "discoveryRequestGUID";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-analysis-reports/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryRequestGUID, "discoveryRequestGUID", "getDiscoveryAnalysisReport");
        try {
            DiscoveryAnalysisReportResponse restResult = this.restClient.callDiscoveryAnalysisReportGetRESTCall("getDiscoveryAnalysisReport", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-analysis-reports/{3}", new Object[]{this.serverName, userId, this.discoveryEngineName, discoveryRequestGUID});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            return restResult.getAnalysisReport();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryRequestGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getDiscoveryReportAnnotations";
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-analysis-reports/{3}/annotations?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validateGUID(discoveryRequestGUID, "discoveryReportGUID", "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryReportAnnotations");
        try {
            AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall("getDiscoveryReportAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/discovery-analysis-reports/{3}/annotations?startingFrom={4}&maximumResults={5}", new Object[]{this.serverName, userId, this.discoveryEngineName, discoveryRequestGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            return restResult.getAnnotations();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/annotations/{4}/extended-annotations?startingFrom={5}&maximumResults={6}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        try {
            AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall("getExtendedAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/annotations/{4}/extended-annotations?startingFrom={5}&maximumResults={6}", new Object[]{this.serverName, userId, this.discoveryEngineName, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            return restResult.getAnnotations();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }

    public Annotation getAnnotation(String userId, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getAnnotation";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/annotations/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getAnnotation");
        try {
            AnnotationResponse restResult = this.restClient.callAnnotationGetRESTCall("getAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/asset-analysis/users/{1}/discovery-engines/{2}/annotations/{3}", new Object[]{this.serverName, userId, this.discoveryEngineName, annotationGUID});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            return restResult.getAnnotation();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }
}

