/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.assetanalysis.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.engineservices.assetanalysis.server.AssetAnalysisRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/engine-services/asset-analysis/users/{userId}/discovery-engines/{discoveryEngineName}"})
@Tag(name="Asset Analysis OMES", description="The Asset Analysis OMES provide the core subsystem for driving requests for automated metadata discovery services.", externalDocs=@ExternalDocumentation(description="Asset Analysis Open Metadata Engine Services (OMES)", url="https://egeria-project.org/services/omes/asset-analysis/overview/"))
public class DiscoveryEngineResource {
    private AssetAnalysisRESTServices restAPI = new AssetAnalysisRESTServices();

    @PostMapping(path={"/discovery-request-types/{discoveryRequestType}/assets/{assetGUID}"})
    public GUIDResponse discoverAsset(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String discoveryRequestType, @RequestBody DiscoveryRequestRequestBody requestBody) {
        return this.restAPI.discoverAsset(serverName, discoveryEngineName, userId, assetGUID, discoveryRequestType, requestBody);
    }

    @PostMapping(path={"/discovery-request-types/{discoveryRequestType}/assets"})
    public VoidResponse scanAllAssets(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestType, @RequestBody(required=false) DiscoveryRequestRequestBody requestBody) {
        return this.restAPI.scanAllAssets(serverName, discoveryEngineName, userId, discoveryRequestType, requestBody);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}"})
    public DiscoveryAnalysisReportResponse getDiscoveryAnalysisReport(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestGUID) {
        return this.restAPI.getDiscoveryAnalysisReport(serverName, discoveryEngineName, userId, discoveryRequestGUID);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}/annotations"})
    public AnnotationListResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getDiscoveryReportAnnotations(serverName, discoveryEngineName, userId, discoveryRequestGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/annotations/{annotationGUID}/extended-annotations"})
    public AnnotationListResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getExtendedAnnotations(serverName, discoveryEngineName, userId, annotationGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/annotations/{annotationGUID}"})
    public AnnotationResponse getAnnotation(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String annotationGUID) {
        return this.restAPI.getAnnotation(serverName, discoveryEngineName, userId, annotationGUID);
    }
}

