/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.client;

import org.odpi.openmetadata.accessservice.assetcatalog.AssetCatalogInterface;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.InvalidParameterException;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipsResponse;
import org.springframework.web.client.RestTemplate;

public class AssetCatalog
implements AssetCatalogInterface {
    private String omasServerURL;
    private RestTemplate restTemplate;

    public AssetCatalog(String newServerURL) {
        this.omasServerURL = newServerURL;
        this.restTemplate = new RestTemplate();
    }

    @Override
    public AssetDescriptionResponse getAssetSummary(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetSummary";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/asset-summary/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getAssetDetails(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetDetails";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/asset-details/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getAssetUniverse(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetUniverse";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/asset-universe/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, assetId);
    }

    @Override
    public RelationshipsResponse getAssetRelationships(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetRelationships";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/asset-relationships/{1}";
        return this.callGetRelationshipsResponse(url, userId, assetId);
    }

    @Override
    public ClassificationsResponse getClassificationForAsset(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getClassificationForAsset";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/asset-classifications/{1}";
        return this.callGetClassificationResponse(url, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getAssetsByProperty(String userId, String propertyValue) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetsByProperty";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, propertyValue);
        String url = "/{0}/assets-by-property/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, propertyValue);
    }

    @Override
    public AssetDescriptionResponse getAssetsByClassificationName(String userId, String classificationName) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetsByClassificationName";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, classificationName);
        String url = "/{0}/assets-by-classification-name/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, classificationName);
    }

    @Override
    public RelationshipsResponse getLinkingRelationships(String userId, String startAssetId, String endAssetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getLinkingRelationships";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, startAssetId);
        this.validateParameter(methodName, endAssetId);
        String url = "/{0}/assets-linking-relationships/from/{1}/to/{2}";
        return this.callGetRelationshipsResponse(url, userId, startAssetId, endAssetId);
    }

    @Override
    public AssetDescriptionResponse getLinkingAssets(String userId, String startAssetId, String endAssetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getLinkingAssets";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, startAssetId);
        this.validateParameter(methodName, endAssetId);
        String url = "/{0}/linking-assets/from/{1}/to/{2}";
        return this.callGetAssetDescriptionResponse(url, userId, startAssetId, endAssetId);
    }

    @Override
    public AssetDescriptionResponse getRelatedAssets(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getRelatedAssets";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/related-assets/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getAssetsFromNeighborhood(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetsFromNeighborhood";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/assets-from-neighborhood/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, assetId);
    }

    @Override
    public RelationshipsResponse getRelationshipsFromNeighborhood(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getRelationshipsFromNeighborhood";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/{0}/related-relationships/{1}";
        return this.callGetRelationshipsResponse(url, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getLastCreatedAssets(String userId) throws InvalidParameterException, PropertyServerException {
        String methodName = "getLastCreatedAssets";
        this.doBasicChecks(methodName, userId);
        String url = "/{0}/last-created";
        return this.callGetAssetDescriptionResponse(url, userId, new String[0]);
    }

    @Override
    public AssetDescriptionResponse getLastUpdatedAssets(String userId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getLastUpdatedAssets";
        this.doBasicChecks(methodName, userId);
        String url = "/{0}/last-updated";
        return this.callGetAssetDescriptionResponse(url, userId, new String[0]);
    }

    @Override
    public RelationshipsResponse getRelationship(String userId, String relationshipId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getRelationship";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, relationshipId);
        String url = "/{0}/relationships/{1}";
        return this.callGetRelationshipsResponse(url, userId, relationshipId);
    }

    @Override
    public RelationshipsResponse getRelationshipByLabel(String userId, String propertyName) throws PropertyServerException, InvalidParameterException {
        String methodName = "getRelationshipByLabel";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, propertyName);
        String url = "/{0}/relationships/property-name/{1}";
        return this.callGetRelationshipsResponse(url, userId, propertyName);
    }

    @Override
    public RelationshipsResponse searchForRelationships(String userId, String relationshipTypeId, String criteria) throws PropertyServerException, InvalidParameterException {
        String methodName = "searchForRelationships";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, relationshipTypeId);
        String url = "/{0}/type/{1}/search/{2}";
        return this.callGetRelationshipsResponse(url, userId, relationshipTypeId, criteria);
    }

    @Override
    public AssetDescriptionResponse searchAssets(String userId, String searchCriteria) throws PropertyServerException, InvalidParameterException {
        String methodName = "searchAssets";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, searchCriteria);
        String url = "/{0}/search-asset/{1}";
        return this.callGetAssetDescriptionResponse(url, userId, searchCriteria);
    }

    private void doBasicChecks(String methodName, String userId) throws PropertyServerException, InvalidParameterException {
        this.validateServerURL(methodName);
        this.validateUserId(methodName, userId);
    }

    private AssetDescriptionResponse callGetAssetDescriptionResponse(String url, String userId, String ... params) {
        AssetDescriptionResponse restResult = new AssetDescriptionResponse();
        return (AssetDescriptionResponse)this.restTemplate.getForObject(this.omasServerURL + url, restResult.getClass(), new Object[]{userId, params});
    }

    private RelationshipsResponse callGetRelationshipsResponse(String url, String userId, String ... params) {
        RelationshipsResponse restResult = new RelationshipsResponse();
        return (RelationshipsResponse)this.restTemplate.getForObject(this.omasServerURL + url, restResult.getClass(), new Object[]{userId, params});
    }

    private ClassificationsResponse callGetClassificationResponse(String url, String userId, String assetId) {
        ClassificationsResponse restResult = new ClassificationsResponse();
        return (ClassificationsResponse)this.restTemplate.getForObject(this.omasServerURL + url, restResult.getClass(), new Object[]{userId, assetId});
    }

    private void validateServerURL(String methodName) throws PropertyServerException {
        if (this.omasServerURL == null || this.omasServerURL.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.SERVER_URL_NOT_SPECIFIED;
            throw new PropertyServerException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateUserId(String methodName, String userId) throws InvalidParameterException {
        if (userId == null || "".equals(userId)) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NULL_USER_ID;
            throw new InvalidParameterException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateParameter(String methodName, Object parameter) throws InvalidParameterException {
        if (parameter == null || "".equals(parameter)) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.PARAMETER_NULL;
            throw new InvalidParameterException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

