/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.client;

import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalogInterface;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipsResponse;
import org.springframework.web.client.RestTemplate;

public class AssetCatalog
implements AssetCatalogInterface {
    private String serverName;
    private String omasServerURL;
    private RestTemplate restTemplate;

    public AssetCatalog(String serverName, String newServerURL) {
        this.serverName = serverName;
        this.omasServerURL = newServerURL;
        this.restTemplate = new RestTemplate();
    }

    @Override
    public AssetDescriptionResponse getAssetSummary(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetSummary";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-summary/{2}";
        return this.getRestCall(url, AssetDescriptionResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getAssetDetails(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetDetails";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-details/{2}";
        return this.getRestCall(url, AssetDescriptionResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getAssetUniverse(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetUniverse";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-universe/{2}";
        return this.getRestCall(url, AssetDescriptionResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public RelationshipsResponse getAssetRelationships(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetRelationships";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-relationships/{2}";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, RelationshipsResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public RelationshipsResponse getAssetRelationshipsForType(String userId, String assetId, String relationshipType) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetRelationshipsForType";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        this.validateParameter(methodName, relationshipType);
        String url = "/{0}/asset-relationships/{1}?type={2}";
        return this.getRestCall(url, RelationshipsResponse.class, userId, assetId, relationshipType);
    }

    @Override
    public ClassificationsResponse getClassificationForAsset(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getClassificationForAsset";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-classifications/{2}";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, ClassificationsResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getLinkingAssets(String userId, String startAssetId, String endAssetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getLinkingAssets";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, startAssetId);
        this.validateParameter(methodName, endAssetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/linking-assets/from/{2}/to/{3}";
        return this.getRestCall(url, AssetDescriptionResponse.class, this.serverName, userId, startAssetId, endAssetId);
    }

    @Override
    public AssetDescriptionResponse getRelatedAssets(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getRelatedAssets";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/related-assets/{2}";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, AssetDescriptionResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getAssetsFromNeighborhood(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getAssetsFromNeighborhood";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/assets-from-neighborhood/{2}";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, AssetDescriptionResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public RelationshipsResponse getRelationshipsFromNeighborhood(String userId, String assetId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getRelationshipsFromNeighborhood";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, assetId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/related-relationships/{2}";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, RelationshipsResponse.class, this.serverName, userId, assetId);
    }

    @Override
    public AssetDescriptionResponse getLastCreatedAssets(String userId) throws InvalidParameterException, PropertyServerException {
        String methodName = "getLastCreatedAssets";
        this.doBasicChecks(methodName, userId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/last-created";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, AssetDescriptionResponse.class, this.serverName, userId);
    }

    @Override
    public AssetDescriptionResponse getLastUpdatedAssets(String userId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getLastUpdatedAssets";
        this.doBasicChecks(methodName, userId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/last-updated";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, AssetDescriptionResponse.class, this.serverName, userId);
    }

    @Override
    public RelationshipsResponse getRelationship(String userId, String relationshipId) throws PropertyServerException, InvalidParameterException {
        String methodName = "getRelationship";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, relationshipId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/relationships/{2}";
        return this.getRestCall(url, RelationshipsResponse.class, this.serverName, userId, relationshipId);
    }

    @Override
    public RelationshipsResponse searchForRelationships(String userId, String relationshipTypeId, String criteria) throws PropertyServerException, InvalidParameterException {
        String methodName = "searchForRelationships";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, relationshipTypeId);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/type/{2}/search/{3}";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, RelationshipsResponse.class, this.serverName, userId, relationshipTypeId, criteria);
    }

    @Override
    public AssetResponse searchForAssets(String userId, String searchCriteria) throws PropertyServerException, InvalidParameterException {
        String methodName = "searchAssets";
        this.doBasicChecks(methodName, userId);
        this.validateParameter(methodName, searchCriteria);
        String url = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/search/{2}";
        SearchParameters requestBody = this.getSearchParameters();
        return this.postRestCall(url, requestBody, AssetResponse.class, this.serverName, userId, searchCriteria);
    }

    private <T> T postRestCall(String url, Object requestBody, Class<T> clazz, Object ... params) {
        return (T)this.restTemplate.postForObject(this.omasServerURL + url, requestBody, clazz, params);
    }

    private <T> T getRestCall(String url, Class<T> clazz, Object ... params) {
        return (T)this.restTemplate.getForObject(this.omasServerURL + url, clazz, params);
    }

    private void doBasicChecks(String methodName, String userId) throws PropertyServerException, InvalidParameterException {
        this.validateServerURL(methodName);
        this.validateUserId(methodName, userId);
    }

    private void validateServerURL(String methodName) throws PropertyServerException {
        if (this.omasServerURL == null || this.omasServerURL.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.SERVER_URL_NOT_SPECIFIED;
            throw new PropertyServerException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateUserId(String methodName, String userId) throws InvalidParameterException {
        if (userId == null || "".equals(userId)) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NULL_USER_ID;
            throw new InvalidParameterException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateParameter(String methodName, Object parameter) throws InvalidParameterException {
        if (parameter == null || "".equals(parameter)) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.PARAMETER_NULL;
            throw new InvalidParameterException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private SearchParameters getSearchParameters() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setLimit(Integer.valueOf(0));
        searchParameters.setOffset(Integer.valueOf(0));
        searchParameters.setStatus(Status.ACTIVE);
        return searchParameters;
    }
}

