/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog;

import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalogInterface;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipsResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;

public class AssetCatalog
extends FFDCRESTClient
implements AssetCatalogInterface {
    private static final String BASE_PATH = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}";
    private static final String ASSET_DETAILS = "/asset-details/{2}?assetType={3}";
    private static final String ASSET_UNIVERSE = "/asset-universe/{2}?assetType={3}";
    private static final String ASSET_RELATIONSHIPS = "/asset-relationships/{2}?assetType={3}&relationshipType={4}&from={5}&pageSize={6}";
    private static final String ASSET_CLASSIFICATIONS = "/asset-classifications/{2}?assetType={3}&classificationName={4}";
    private static final String LINKING_ASSET = "/linking-assets/from/{2}/to/{3}";
    private static final String LINKING_RELATIONSHIPS = "/linking-assets-relationships/from/{2}/to/{3}";
    private static final String ASSETS_FROM_NEIGHBORHOOD = "/assets-from-neighborhood/{2}";
    private static final String SEARCH = "/search?searchCriteria={2}";
    private static final String ASSET_CONTEXT = "/asset-context/{2}?assetType={3}";
    private static final String RELATIONSHIP_BETWEEN_ENTITIES = "/relationship-between-entities/{2}/{3}?relationshipType={4}";
    private static final String SUPPORTED_TYPES = "/supportedTypes?type={2}";
    private static final String GUID_PARAMETER = "assetGUID";
    private static final String START_ASSET_GUID = "startAssetGUID";
    private static final String END_ASSET_GUID = "endAssetGUID";
    private static final String SEARCH_PARAMETERS = "searchParameters";
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public AssetCatalog(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public AssetCatalog(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    @Override
    public AssetDescriptionResponse getAssetDetails(String userId, String assetGUID, String assetType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetDetails";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        AssetDescriptionResponse response = (AssetDescriptionResponse)this.callGetRESTCall(methodName, AssetDescriptionResponse.class, this.serverPlatformURLRoot + BASE_PATH + ASSET_DETAILS, new Object[]{this.serverName, userId, assetGUID, assetType});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)response);
        return response;
    }

    @Override
    public AssetDescriptionResponse getAssetUniverse(String userId, String assetGUID, String assetType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetUniverse";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        AssetDescriptionResponse response = (AssetDescriptionResponse)this.callGetRESTCall(methodName, AssetDescriptionResponse.class, this.serverPlatformURLRoot + BASE_PATH + ASSET_UNIVERSE, new Object[]{this.serverName, userId, assetGUID, assetType});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)response);
        return response;
    }

    @Override
    public RelationshipsResponse getAssetRelationships(String userId, String assetGUID, String assetType, String relationshipType, Integer from, Integer pageSize) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetRelationships";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        this.invalidParameterHandler.validatePaging(from.intValue(), pageSize.intValue(), methodName);
        RelationshipsResponse relationshipsResponse = (RelationshipsResponse)this.callGetRESTCall(methodName, RelationshipsResponse.class, this.serverPlatformURLRoot + BASE_PATH + ASSET_RELATIONSHIPS, new Object[]{this.serverName, userId, assetGUID, assetType, relationshipType, from, pageSize});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)relationshipsResponse);
        return relationshipsResponse;
    }

    @Override
    public ClassificationsResponse getClassificationsForAsset(String userId, String assetGUID, String assetType, String classificationName) throws InvalidParameterException, PropertyServerException {
        String methodName = "getClassificationsForAsset";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        ClassificationsResponse classificationsResponse = (ClassificationsResponse)this.callGetRESTCall(methodName, ClassificationsResponse.class, this.serverPlatformURLRoot + BASE_PATH + ASSET_CLASSIFICATIONS, new Object[]{this.serverName, userId, assetGUID, assetType, classificationName});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)classificationsResponse);
        return classificationsResponse;
    }

    @Override
    public AssetDescriptionResponse getLinkingAssets(String userId, String startAssetGUID, String endAssetGUID) throws InvalidParameterException, PropertyServerException {
        String methodName = "getLinkingAssets";
        this.validateStartAndEndAssetsGUIDs(userId, startAssetGUID, endAssetGUID, methodName);
        AssetDescriptionResponse response = (AssetDescriptionResponse)this.callGetRESTCall(methodName, AssetDescriptionResponse.class, this.serverPlatformURLRoot + BASE_PATH + LINKING_ASSET, new Object[]{this.serverName, userId, startAssetGUID, endAssetGUID});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)response);
        return response;
    }

    @Override
    public RelationshipsResponse getLinkingRelationships(String userId, String startAssetGUID, String endAssetGUID) throws InvalidParameterException, PropertyServerException {
        String methodName = "getLinkingRelationships";
        this.validateStartAndEndAssetsGUIDs(userId, startAssetGUID, endAssetGUID, methodName);
        RelationshipsResponse response = (RelationshipsResponse)this.callGetRESTCall(methodName, RelationshipsResponse.class, this.serverPlatformURLRoot + BASE_PATH + LINKING_RELATIONSHIPS, new Object[]{this.serverName, userId, startAssetGUID, endAssetGUID});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)response);
        return response;
    }

    @Override
    public AssetDescriptionResponse getAssetsFromNeighborhood(String userId, String assetGUID, SearchParameters searchParameters) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetsFromNeighborhood";
        this.validateSearchParams(userId, assetGUID, searchParameters, methodName);
        AssetDescriptionResponse response = (AssetDescriptionResponse)this.callPostRESTCall(methodName, AssetDescriptionResponse.class, this.serverPlatformURLRoot + BASE_PATH + ASSETS_FROM_NEIGHBORHOOD, searchParameters, new Object[]{this.serverName, userId, assetGUID});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)response);
        return response;
    }

    @Override
    public AssetResponse searchByType(String userId, String searchCriteria, SearchParameters searchParameters) throws InvalidParameterException, PropertyServerException {
        String methodName = "searchByType";
        this.invalidParameterHandler.validateUserId(methodName, userId);
        this.invalidParameterHandler.validateSearchString(searchCriteria, "searchCriteria", methodName);
        this.invalidParameterHandler.validateObject((Object)searchParameters, SEARCH_PARAMETERS, methodName);
        AssetResponse assetResponse = (AssetResponse)this.callPostRESTCall(methodName, AssetResponse.class, this.serverPlatformURLRoot + BASE_PATH + SEARCH, searchParameters, new Object[]{this.serverName, userId, searchCriteria});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)assetResponse);
        return assetResponse;
    }

    @Override
    public AssetResponse getAssetContext(String userId, String assetGUID, String assetType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetContext";
        this.invalidParameterHandler.validateUserId(methodName, userId);
        this.invalidParameterHandler.validateSearchString(assetGUID, GUID_PARAMETER, methodName);
        AssetResponse assetResponse = (AssetResponse)this.callGetRESTCall(methodName, AssetResponse.class, this.serverPlatformURLRoot + BASE_PATH + ASSET_CONTEXT, new Object[]{this.serverName, userId, assetGUID, assetType});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)assetResponse);
        return assetResponse;
    }

    @Override
    public RelationshipResponse getRelationshipBetweenEntities(String userId, String entity1GUID, String entity2GUID, String relationshipType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getRelationshipBetweenEntities";
        this.validateStartAndEndAssetsGUIDs(userId, entity1GUID, entity2GUID, methodName);
        RelationshipResponse relationshipResponse = (RelationshipResponse)this.callGetRESTCall(methodName, RelationshipResponse.class, this.serverPlatformURLRoot + BASE_PATH + RELATIONSHIP_BETWEEN_ENTITIES, new Object[]{this.serverName, userId, entity1GUID, entity2GUID, relationshipType});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)relationshipResponse);
        return relationshipResponse;
    }

    @Override
    public AssetCatalogSupportedTypes getSupportedTypes(String userId, String type) throws PropertyServerException, InvalidParameterException {
        String methodName = "getSupportedTypes";
        AssetCatalogSupportedTypes assetCatalogSupportedTypes = (AssetCatalogSupportedTypes)this.callGetRESTCall(methodName, AssetCatalogSupportedTypes.class, this.serverPlatformURLRoot + BASE_PATH + SUPPORTED_TYPES, new Object[]{this.serverName, userId, type});
        this.detectExceptions(methodName, (AssetCatalogOMASAPIResponse)assetCatalogSupportedTypes);
        return assetCatalogSupportedTypes;
    }

    private void validateUserAndAssetGUID(String userId, String assetGUID, String methodName, String guidParameter) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        this.invalidParameterHandler.validateUserId(methodName, userId);
        this.invalidParameterHandler.validateGUID(assetGUID, guidParameter, methodName);
    }

    private void validateStartAndEndAssetsGUIDs(String userId, String startAssetGUID, String endAssetGUID, String methodName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        this.validateUserAndAssetGUID(userId, startAssetGUID, methodName, START_ASSET_GUID);
        this.invalidParameterHandler.validateGUID(endAssetGUID, END_ASSET_GUID, methodName);
    }

    private void validateSearchParams(String userId, String assetGUID, SearchParameters searchParameters, String methodName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        this.invalidParameterHandler.validateObject((Object)searchParameters, SEARCH_PARAMETERS, methodName);
    }

    private void detectExceptions(String methodName, AssetCatalogOMASAPIResponse response) throws InvalidParameterException, PropertyServerException {
        this.restExceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)response);
        this.restExceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)response);
    }
}

