/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog;

import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalogInterface;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;

public class AssetCatalog
extends OCFRESTClient
implements AssetCatalogInterface {
    private static final String BASE_PATH = "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}";
    private static final String ASSET_DETAILS = "/asset-details/{2}?assetType={3}";
    private static final String ASSET_UNIVERSE = "/asset-universe/{2}?assetType={3}";
    private static final String ASSET_RELATIONSHIPS = "/asset-relationships/{2}?assetType={3}&relationshipType={4}&from={5}&pageSize={6}";
    private static final String ASSET_CLASSIFICATIONS = "/asset-classifications/{2}?assetType={3}&classificationName={4}";
    private static final String SEARCH = "/search?searchCriteria={2}";
    private static final String ASSET_CONTEXT = "/asset-context/{2}?assetType={3}";
    private static final String RELATIONSHIP_BETWEEN_ENTITIES = "/relationship-between-entities/{2}/{3}?relationshipType={4}";
    private static final String SUPPORTED_TYPES = "/supportedTypes?type={2}";
    private static final String GUID_PARAMETER = "assetGUID";
    private static final String START_ASSET_GUID = "startAssetGUID";
    private static final String END_ASSET_GUID = "endAssetGUID";
    private static final String SEARCH_PARAMETERS = "searchParameters";
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public AssetCatalog(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public AssetCatalog(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    @Override
    public AssetCatalogResponse getAssetDetails(String userId, String assetGUID, String assetType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetDetails";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        AssetCatalogResponse response = (AssetCatalogResponse)this.callGetRESTCall(methodName, AssetCatalogResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-details/{2}?assetType={3}", new Object[]{this.serverName, userId, assetGUID, assetType});
        this.detectExceptions((AssetCatalogOMASAPIResponse)response);
        return response;
    }

    @Override
    public AssetCatalogResponse getAssetUniverse(String userId, String assetGUID, String assetType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetUniverse";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        AssetCatalogResponse response = (AssetCatalogResponse)this.callGetRESTCall(methodName, AssetCatalogResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-universe/{2}?assetType={3}", new Object[]{this.serverName, userId, assetGUID, assetType});
        this.detectExceptions((AssetCatalogOMASAPIResponse)response);
        return response;
    }

    @Override
    public RelationshipListResponse getAssetRelationships(String userId, String assetGUID, String assetType, String relationshipType, Integer from, Integer pageSize) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetRelationships";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        this.invalidParameterHandler.validatePaging(from.intValue(), pageSize.intValue(), methodName);
        RelationshipListResponse relationshipListResponse = (RelationshipListResponse)this.callGetRESTCall(methodName, RelationshipListResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-relationships/{2}?assetType={3}&relationshipType={4}&from={5}&pageSize={6}", new Object[]{this.serverName, userId, assetGUID, assetType, relationshipType, from, pageSize});
        this.detectExceptions((AssetCatalogOMASAPIResponse)relationshipListResponse);
        return relationshipListResponse;
    }

    @Override
    public ClassificationListResponse getClassificationsForAsset(String userId, String assetGUID, String assetType, String classificationName) throws InvalidParameterException, PropertyServerException {
        String methodName = "getClassificationsForAsset";
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        ClassificationListResponse classificationListResponse = (ClassificationListResponse)this.callGetRESTCall(methodName, ClassificationListResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-classifications/{2}?assetType={3}&classificationName={4}", new Object[]{this.serverName, userId, assetGUID, assetType, classificationName});
        this.detectExceptions((AssetCatalogOMASAPIResponse)classificationListResponse);
        return classificationListResponse;
    }

    @Override
    public AssetListResponse searchByType(String userId, String searchCriteria, SearchParameters searchParameters) throws InvalidParameterException, PropertyServerException {
        String methodName = "searchByType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchCriteria, "searchCriteria", methodName);
        this.invalidParameterHandler.validateObject((Object)searchParameters, SEARCH_PARAMETERS, methodName);
        AssetListResponse assetResponse = (AssetListResponse)this.callPostRESTCall(methodName, AssetListResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/search?searchCriteria={2}", searchParameters, new Object[]{this.serverName, userId, searchCriteria});
        this.detectExceptions((AssetCatalogOMASAPIResponse)assetResponse);
        return assetResponse;
    }

    @Override
    public AssetResponse getAssetContext(String userId, String assetGUID, String assetType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getAssetContext";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(assetGUID, GUID_PARAMETER, methodName);
        AssetResponse assetResponse = (AssetResponse)this.callGetRESTCall(methodName, AssetResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/asset-context/{2}?assetType={3}", new Object[]{this.serverName, userId, assetGUID, assetType});
        this.detectExceptions((AssetCatalogOMASAPIResponse)assetResponse);
        return assetResponse;
    }

    @Override
    public RelationshipResponse getRelationshipBetweenEntities(String userId, String entity1GUID, String entity2GUID, String relationshipType) throws InvalidParameterException, PropertyServerException {
        String methodName = "getRelationshipBetweenEntities";
        this.validateStartAndEndAssetsGUIDs(userId, entity1GUID, entity2GUID, methodName);
        RelationshipResponse relationshipResponse = (RelationshipResponse)this.callGetRESTCall(methodName, RelationshipResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/relationship-between-entities/{2}/{3}?relationshipType={4}", new Object[]{this.serverName, userId, entity1GUID, entity2GUID, relationshipType});
        this.detectExceptions((AssetCatalogOMASAPIResponse)relationshipResponse);
        return relationshipResponse;
    }

    @Override
    public AssetCatalogSupportedTypes getSupportedTypes(String userId, String type) throws PropertyServerException, InvalidParameterException {
        String methodName = "getSupportedTypes";
        AssetCatalogSupportedTypes assetCatalogSupportedTypes = (AssetCatalogSupportedTypes)this.callGetRESTCall(methodName, AssetCatalogSupportedTypes.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-catalog/users/{1}/supportedTypes?type={2}", new Object[]{this.serverName, userId, type});
        this.detectExceptions((AssetCatalogOMASAPIResponse)assetCatalogSupportedTypes);
        return assetCatalogSupportedTypes;
    }

    private void validateUserAndAssetGUID(String userId, String assetGUID, String methodName, String guidParameter) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, guidParameter, methodName);
    }

    private void validateStartAndEndAssetsGUIDs(String userId, String startAssetGUID, String endAssetGUID, String methodName) throws InvalidParameterException {
        this.validateUserAndAssetGUID(userId, startAssetGUID, methodName, START_ASSET_GUID);
        this.invalidParameterHandler.validateGUID(endAssetGUID, END_ASSET_GUID, methodName);
    }

    private void validateSearchParams(String userId, String assetGUID, SearchParameters searchParameters, String methodName) throws InvalidParameterException {
        this.validateUserAndAssetGUID(userId, assetGUID, methodName, GUID_PARAMETER);
        this.invalidParameterHandler.validateObject((Object)searchParameters, SEARCH_PARAMETERS, methodName);
    }

    private void detectExceptions(AssetCatalogOMASAPIResponse response) throws InvalidParameterException, PropertyServerException {
        this.restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)response);
        this.restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)response);
    }
}

