/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum AssetCatalogAuditCode {
    SERVICE_INITIALIZING("OMAS-ASSET-CATALOG-0001", OMRSAuditLogRecordSeverity.INFO, "The Asset Catalog Open Metadata Access Service (OMAS) is initializing", "The local server has started up the Asset Catalog OMAS.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_REGISTERED_WITH_TOPIC("OMAS-ASSET-CATALOG-0002", OMRSAuditLogRecordSeverity.INFO, "The Asset Catalog Open Metadata Access Service (OMAS) is registering a listener with the OMRS Topic", "The Asset Catalog OMAS is registering to receive events from the connected open metadata repositories.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_INITIALIZED("OMAS-ASSET-CATALOG-0003", OMRSAuditLogRecordSeverity.INFO, "The Asset Catalog Open Metadata Access Service (OMAS) is initialized", "The Asset Catalog OMAS has completed initialization.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_SHUTDOWN("OMAS-ASSET-CATALOG-0004", OMRSAuditLogRecordSeverity.INFO, "The Asset Catalog Open Metadata Access Service (OMAS) is shutting down", "The local server has requested shut down of the Asset Catalog OMAS.", "No action is required.  This is part of the normal operation of the server.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private AssetCatalogAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

