/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservice.assetcatalog.admin.AssetCatalogAdmin;
import org.odpi.openmetadata.accessservice.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservice.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.util.Converter;
import org.odpi.openmetadata.accessservice.assetcatalog.util.ExceptionUtil;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class AssetCatalogAssetService {
    private static OMRSMetadataCollection metadataCollection;
    private Converter converter = new Converter();
    private ExceptionUtil exceptionUtil = new ExceptionUtil();

    public AssetCatalogAssetService() {
        AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CATALOG_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, AssetCatalogAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
    }

    public static void setRepositoryConnector(OMRSRepositoryConnector localRepositoryConnector) {
        try {
            metadataCollection = localRepositoryConnector.getMetadataCollection();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public AssetDescriptionResponse getAssetSummaryById(String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntitySummary entitySummary = this.getEntitySummary(userId, assetId);
            if (entitySummary != null) {
                AssetDescription assetDescription = this.converter.getAssetDescription(entitySummary);
                response.setAssetDescriptionList(Arrays.asList(assetDescription));
            }
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetDetailsById(String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntityDetail entityDetail = this.getEntityDetails(userId, assetId);
            if (entityDetail != null) {
                AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
                response.setAssetDescriptionList(Arrays.asList(assetDescription));
            }
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public ClassificationsResponse getClassificationByAssetGUID(String userId, String assetId, Integer limit, Integer offset) {
        ClassificationsResponse response = new ClassificationsResponse();
        try {
            EntityDetail asset = this.getEntityDetails(userId, assetId);
            if (asset != null) {
                response.setClassifications(this.converter.toClassifications(asset.getClassifications()));
            }
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public RelationshipsResponse getAssetRelationships(String userId, String assetId, String relationshipType, Status status, Integer fromElement, Integer pageSize, String property, SequenceOrderType orderType) {
        String relationshipTypeID = this.getTypeID(userId, relationshipType);
        List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List<Relationship> relationships = this.getRelationships(userId, assetId, fromElement, pageSize, property, relationshipTypeID, instanceStatuses, sequencingOrder);
            if (relationships != null) {
                response.setRelationships(this.converter.toRelationships(relationships));
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsByClassificationName(String userId, String assetTypeId, String classificationName, Integer limit, Integer offset, String orderProperty, SequenceOrderType orderType, Status status) {
        List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List entitiesByClassification = metadataCollection.findEntitiesByClassification(userId, assetTypeId, classificationName, null, null, offset.intValue(), instanceStatuses, null, orderProperty, sequencingOrder, limit.intValue());
            if (entitiesByClassification != null) {
                response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesByClassification));
            }
        }
        catch (ClassificationErrorException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsByProperty(String userId, String assetTypeId, String matchProperty, String propertyValue, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) {
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        InstanceProperties matchProperties = null;
        matchProperties = matchProperty != null ? this.converter.getMatchProperties(matchProperty, propertyValue) : this.converter.getMatchProperties("qualifiedName", propertyValue);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List entitiesByProperty = metadataCollection.findEntitiesByProperty(userId, assetTypeId, matchProperties, MatchCriteria.ANY, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue());
            if (entitiesByProperty != null) {
                response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesByProperty));
            }
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsFromNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            InstanceGraph entityNeighborhood = this.getAssetNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
            if (entityNeighborhood != null) {
                response.setAssetDescriptionList(this.converter.getAssetsDetails(entityNeighborhood.getEntities()));
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public RelationshipsResponse getRelationshipsFromNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            InstanceGraph entityNeighborhood = this.getAssetNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
            if (entityNeighborhood != null && entityNeighborhood.getRelationships() != null) {
                response.setRelationships(this.converter.toRelationships(entityNeighborhood.getRelationships()));
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetUniverseByGUID(String userId, String assetGUID) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        AssetDescription assetDescription = new AssetDescription();
        try {
            EntityDetail entityDetails = this.getEntityDetails(userId, assetGUID);
            assetDescription = this.converter.getAssetDescription(entityDetails);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        try {
            List<Relationship> relationships = this.getRelationships(userId, assetGUID, 0, 0, null, null, null, null);
            assetDescription.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        response.setAssetDescriptionList(Arrays.asList(assetDescription));
        return response;
    }

    public RelationshipsResponse getLinkingRelationships(String userId, String startAssetId, String endAssetId) {
        List<InstanceStatus> limitByStatus = this.converter.getInstanceStatuses(null);
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus, null);
            if (linkingEntities != null && linkingEntities.getRelationships() != null) {
                response.setRelationships(this.converter.toRelationships(linkingEntities.getRelationships()));
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public AssetDescriptionResponse getLinkingAssets(String userId, String startAssetId, String endAssetId) {
        List<InstanceStatus> limitByStatus = this.converter.getInstanceStatuses(null);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus, null);
            if (linkingEntities != null && linkingEntities.getEntities() != null) {
                response.setAssetDescriptionList(this.converter.getAssetsDetails(linkingEntities.getEntities()));
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public AssetDescriptionResponse getRelatedAssets(String userId, String startAssetId, String instanceType, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) {
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        ArrayList<String> instanceTypes = null;
        if (instanceType != null) {
            instanceTypes = new ArrayList<String>();
            instanceTypes.add(instanceType);
        }
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List relatedEntities = metadataCollection.getRelatedEntities(userId, startAssetId, instanceTypes, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue());
            if (relatedEntities != null) {
                response.setAssetDescriptionList(this.converter.getAssetsDetails(relatedEntities));
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public List<AssetDescription> getLastUpdatedAssets(String userId, String entityTypeGUID, Date fromDate, Date toDate, Status status, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status1) {
        return null;
    }

    public List<AssetDescription> getLastCreatedAssets(String userId, String assetTypeId, Date fromDate, Date toDate, Status status, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status1) {
        return null;
    }

    private EntitySummary getEntitySummary(String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException {
        return metadataCollection.getEntitySummary(userId, assetId);
    }

    private EntityDetail getEntityDetails(String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException {
        return metadataCollection.getEntityDetail(userId, assetId);
    }

    private String getTypeID(String userId, String relationshipType) {
        if (relationshipType != null) {
            try {
                TypeDef typeDefByName = metadataCollection.getTypeDefByName(userId, relationshipType);
                return typeDefByName.getGUID();
            }
            catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private List<Relationship> getRelationships(String userId, String assetId, Integer fromElement, Integer pageSize, String property, String relationshipTypeID, List<InstanceStatus> instanceStatuses, SequencingOrder sequencingOrder) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        return metadataCollection.getRelationshipsForEntity(userId, assetId, relationshipTypeID, fromElement.intValue(), instanceStatuses, null, property, sequencingOrder, pageSize.intValue());
    }

    private InstanceGraph getAssetNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException {
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(relationshipStatus);
        return metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, limitResultsByStatus, null, null, level.intValue());
    }
}

