/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.service;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.accessservice.assetcatalog.admin.AssetCatalogAdmin;
import org.odpi.openmetadata.accessservice.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.util.Converter;
import org.odpi.openmetadata.accessservice.assetcatalog.util.ExceptionUtil;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class AssetCatalogRelationshipService {
    private static OMRSMetadataCollection metadataCollection;
    private Converter converter = new Converter();
    private ExceptionUtil exceptionUtil = new ExceptionUtil();

    public AssetCatalogRelationshipService() {
        AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CATALOG_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, AssetCatalogAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
    }

    public static void setRepositoryConnector(OMRSRepositoryConnector localRepositoryConnector) {
        try {
            metadataCollection = localRepositoryConnector.getMetadataCollection();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public RelationshipsResponse getRelationshipById(String userId, String relationshipId) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            Relationship relationship = metadataCollection.getRelationship(userId, relationshipId);
            response.setRelationships(Arrays.asList(this.converter.toRelationship(relationship)));
        }
        catch (InvalidParameterException | RelationshipNotKnownException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public RelationshipsResponse getRelationshipByProperty(String userId, String relationshipTypeGUID, String matchProperty, String propertyValue, Integer pageSize, Integer fromElement, SequenceOrderType orderType, String orderProperty, Status status) {
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        SequencingOrder order = this.converter.getSequencingOrder(orderType);
        InstanceProperties matchProperties = this.converter.getMatchProperties(matchProperty, propertyValue);
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List relationshipsByProperty = metadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, MatchCriteria.ANY, fromElement.intValue(), limitResultsByStatus, null, orderProperty, order, pageSize.intValue());
            if (relationshipsByProperty != null && !relationshipsByProperty.isEmpty()) {
                response.setRelationships(this.converter.toRelationships(relationshipsByProperty));
            }
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public RelationshipsResponse searchForRelationships(String userId, String relationshipTypeGUID, String searchCriteria, Integer pageSize, Integer fromElement, String orderProperty, SequenceOrderType orderType, Status status) {
        SequencingOrder order = this.converter.getSequencingOrder(orderType);
        List<InstanceStatus> statusList = this.converter.getInstanceStatuses(status);
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List relationshipsByPropertyValue = metadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromElement.intValue(), statusList, null, orderProperty, order, pageSize.intValue());
            if (relationshipsByPropertyValue != null && !relationshipsByPropertyValue.isEmpty()) {
                response.setRelationships(this.converter.toRelationships(relationshipsByPropertyValue));
            }
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureException((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }
}

