/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.service;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservice.assetcatalog.admin.AssetCatalogAdmin;
import org.odpi.openmetadata.accessservice.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Column;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Connection;
import org.odpi.openmetadata.accessservice.assetcatalog.model.DataType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Database;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Endpoint;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Schema;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Table;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.util.Converter;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefGalleryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefResponse;

public class OMASCatalogRESTServices {
    private static OMRSMetadataCollection metadataCollection;
    private Converter converter = new Converter();

    public OMASCatalogRESTServices() {
        AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CATALOG_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, AssetCatalogAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
    }

    public static void setRepositoryConnector(OMRSRepositoryConnector localRepositoryConnector) {
        try {
            metadataCollection = localRepositoryConnector.getMetadataCollection();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TypeDefGalleryResponse getAllTypes(String userId) {
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        TypeDefGallery typeDefGallery = null;
        try {
            typeDefGallery = metadataCollection.getAllTypes(userId);
        }
        catch (RepositoryErrorException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
        if (typeDefGallery != null) {
            response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
            response.setTypeDefs((List)typeDefGallery.getTypeDefs());
        }
        return response;
    }

    public TypeDefResponse getTypeDefByGUID(String userId, String guid) {
        TypeDefResponse response = new TypeDefResponse();
        try {
            TypeDef typeDefByGUID = metadataCollection.getTypeDefByGUID(userId, guid);
            response.setTypeDef(typeDefByGUID);
        }
        catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
            response.setRelatedHTTPCode(e.getReportedHTTPCode());
            response.setExceptionClassName(e.getClass().getName());
        }
        return response;
    }

    public AssetDescriptionResponse searchAssets(String userId, String searchCriteria) {
        List<EntityDetail> matchCriteriaEntities = this.findEntitiesBySearchCriteria(userId, searchCriteria);
        ArrayList<AssetDescription> assetDescriptions = new ArrayList<AssetDescription>(matchCriteriaEntities.size());
        for (EntityDetail entityDetail : matchCriteriaEntities) {
            AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
            ArrayList<Connection> connections = new ArrayList<Connection>();
            if (!entityDetail.getType().getTypeDefName().equals("GlossaryTerm")) {
                Connection connection = this.getConnectionToAsset(userId, entityDetail);
                connections.add(connection);
            } else {
                List<Relationship> relationshipsToColumn = this.getRelationshipByType(userId, entityDetail.getGUID(), "SemanticAssignment");
                if (relationshipsToColumn != null && !relationshipsToColumn.isEmpty()) {
                    assetDescription.setRelationships(this.converter.toRelationships(relationshipsToColumn));
                    for (Relationship relationship : relationshipsToColumn) {
                        EntityDetail relationalColumn = this.getThePairEntity(userId, entityDetail.getGUID(), relationship);
                        if (relationalColumn == null) continue;
                        Connection connection = this.getConnectionToAsset(userId, relationalColumn);
                        connections.add(connection);
                    }
                }
            }
            assetDescription.setConnection(connections);
            assetDescriptions.add(assetDescription);
        }
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        response.setAssetDescriptionList(assetDescriptions);
        return response;
    }

    private List<EntityDetail> findEntitiesBySearchCriteria(String userId, String searchCriteria) {
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        entities.addAll(this.findEntitiesByType(userId, searchCriteria, null));
        return entities;
    }

    private List<EntityDetail> findEntitiesByType(String userId, String searchCriteria, String entityType) {
        String GUID = null;
        if (entityType != null) {
            GUID = this.getTypeByName(userId, entityType);
        }
        try {
            List entitiesByPropertyValue = metadataCollection.findEntitiesByPropertyValue(userId, GUID, searchCriteria, 0, null, null, null, null, SequencingOrder.ANY, 0);
            if (entitiesByPropertyValue != null) {
                return entitiesByPropertyValue;
            }
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
        return new ArrayList<EntityDetail>();
    }

    private List<Relationship> getRelationshipByType(String userId, String entityGUID, String relationshipType) {
        String guid = null;
        if (relationshipType != null) {
            guid = this.getTypeByName(userId, relationshipType);
        }
        ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>(1);
        instanceStatuses.add(InstanceStatus.ACTIVE);
        try {
            List relationshipsForEntity = metadataCollection.getRelationshipsForEntity(userId, entityGUID, guid, 0, instanceStatuses, null, null, SequencingOrder.ANY, 0);
            if (relationshipsForEntity != null) {
                return relationshipsForEntity;
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
        return new ArrayList<Relationship>();
    }

    private String getTypeByName(String userId, String typeName) {
        try {
            TypeDef typeDefByName = metadataCollection.getTypeDefByName(userId, typeName);
            return typeDefByName.getGUID();
        }
        catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Connection getConnectionToAsset(String userId, EntityDetail relationalColumn) {
        String typeDefName;
        Connection connection = new Connection();
        switch (typeDefName = relationalColumn.getType().getTypeDefName()) {
            case "RelationalColumn": {
                this.processColumn(userId, relationalColumn, connection);
                break;
            }
            case "RelationalTable": {
                this.processRelationalTable(userId, connection, new Table(), relationalColumn);
                break;
            }
            case "DataStore": {
                this.processDataStore(userId, connection, relationalColumn);
            }
        }
        return connection;
    }

    private void processColumn(String userId, EntityDetail relationalColumn, Connection connection) {
        EntityDetail relationalTableType;
        Column column = this.getColumn(userId, relationalColumn);
        connection.setColumn(column);
        Table table = new Table();
        List<Relationship> relationshipsToTableType = this.getRelationshipByType(userId, relationalColumn.getGUID(), "AttributeForSchema");
        if (relationshipsToTableType != null && !relationshipsToTableType.isEmpty() && (relationalTableType = this.getThePairEntity(userId, relationalColumn.getGUID(), relationshipsToTableType.get(0))) != null) {
            EntityDetail relationalTable;
            this.getTableTypeAttributes(table, relationalTableType);
            List<Relationship> relationshipsToTables = this.getRelationshipByType(userId, relationalTableType.getGUID(), "SchemaAttributeType");
            if (relationshipsToTables != null && !relationshipsToTables.isEmpty() && (relationalTable = this.getThePairEntity(userId, relationalTableType.getGUID(), relationshipsToTables.get(0))) != null) {
                this.processRelationalTable(userId, connection, table, relationalTable);
            }
        }
    }

    private DataType getColumnType(String userId, EntityDetail relationalColumn) {
        EntityDetail columnType;
        List<Relationship> relationshipsToType = this.getRelationshipByType(userId, relationalColumn.getGUID(), "SchemaAttributeType");
        if (relationshipsToType != null && !relationshipsToType.isEmpty() && (columnType = this.getThePairEntity(userId, relationalColumn.getGUID(), relationshipsToType.get(0))) != null && columnType.getProperties() != null) {
            PrimitivePropertyValue value = (PrimitivePropertyValue)columnType.getProperties().getPropertyValue("type");
            if (value != null) {
                PrimitiveDefCategory primitiveValue = value.getPrimitiveDefCategory();
                return this.converter.getDataTypeDef(primitiveValue);
            }
            return null;
        }
        return null;
    }

    private void processRelationalTable(String userId, Connection connection, Table table, EntityDetail relationalTable) {
        EntityDetail relationalDbSchemaType;
        table.setName(this.getPropertyValue(relationalTable.getProperties(), "name"));
        table.setGuid(relationalTable.getGUID());
        connection.setTable(table);
        List<Relationship> relationshipsToRelationalDBSchemaType = this.getRelationshipByType(userId, relationalTable.getGUID(), "AttributeForSchema");
        if (relationshipsToRelationalDBSchemaType != null && !relationshipsToRelationalDBSchemaType.isEmpty() && (relationalDbSchemaType = this.getThePairEntity(userId, relationalTable.getGUID(), relationshipsToRelationalDBSchemaType.get(0))) != null) {
            EntityDetail deployedDbSchema;
            Schema schema = this.getSchema(relationalDbSchemaType);
            List<Relationship> relationshipsToDeployedDBSchema = this.getRelationshipByType(userId, relationalDbSchemaType.getGUID(), "AssetSchemaType");
            if (relationshipsToDeployedDBSchema != null && !relationshipsToDeployedDBSchema.isEmpty() && (deployedDbSchema = this.getThePairEntity(userId, relationalDbSchemaType.getGUID(), relationshipsToDeployedDBSchema.get(0))) != null && deployedDbSchema.getProperties() != null) {
                schema.setDeployedDbSchemaName(this.getPropertyValue(deployedDbSchema.getProperties(), "name"));
                List<Relationship> relationshipsToDataStore = this.getRelationshipByType(userId, deployedDbSchema.getGUID(), "DataContentForDataSet");
                if (relationshipsToDataStore != null && !relationshipsToDataStore.isEmpty()) {
                    EntityDetail dataStore = this.getThePairEntity(userId, deployedDbSchema.getGUID(), relationshipsToDataStore.get(0));
                    this.processDataStore(userId, connection, dataStore);
                }
            }
            connection.setSchema(schema);
        }
    }

    private void processDataStore(String userId, Connection connection, EntityDetail dataStore) {
        Database database = this.getDatabase(dataStore);
        connection.setDatabase(database);
        this.getPropertiesForDataStore(userId, connection, dataStore);
    }

    private void getPropertiesForDataStore(String userId, Connection connection, EntityDetail dataStore) {
        InstanceProperties properties;
        EntityDetail connectionEntity;
        List<Relationship> relationshipsToConnection = this.getRelationshipByType(userId, dataStore.getGUID(), "ConnectionToAsset");
        if (relationshipsToConnection != null && !relationshipsToConnection.isEmpty() && (connectionEntity = this.getThePairEntity(userId, dataStore.getGUID(), relationshipsToConnection.get(0))) != null && (properties = connectionEntity.getProperties()) != null) {
            connection.setDisplayName(this.getPropertyValue(properties, "name"));
            connection.setDescription(this.getPropertyValue(properties, "description"));
            connection.setGuid(connectionEntity.getGUID());
            this.getConnectorType(userId, connection, connectionEntity);
            this.buildEndpoint(userId, connection, connectionEntity);
        }
    }

    private Column getColumn(String userId, EntityDetail relationalColumn) {
        Column column = new Column();
        column.setName(this.getPropertyValue(relationalColumn.getProperties(), "name"));
        column.setType(this.getColumnType(userId, relationalColumn));
        column.setGuid(relationalColumn.getGUID());
        return column;
    }

    private void buildEndpoint(String userId, Connection connection, EntityDetail connectionEntity) {
        EntityDetail endpointEntity;
        List<Relationship> relationshipsToEndpoint = this.getRelationshipByType(userId, connectionEntity.getGUID(), "ConnectionEndpoint");
        if (relationshipsToEndpoint != null && !relationshipsToEndpoint.isEmpty() && (endpointEntity = this.getThePairEntity(userId, connectionEntity.getGUID(), relationshipsToEndpoint.get(0))) != null) {
            Endpoint endpoint = this.getEndpoint(endpointEntity);
            connection.setEndpoint(endpoint);
        }
    }

    private void getConnectorType(String userId, Connection connection, EntityDetail connectionEntity) {
        InstanceProperties properties;
        EntityDetail connectorType;
        List<Relationship> relationshipsToConnectorType = this.getRelationshipByType(userId, connectionEntity.getGUID(), "ConnectionConnectorType");
        if (relationshipsToConnectorType != null && !relationshipsToConnectorType.isEmpty() && (connectorType = this.getThePairEntity(userId, connectionEntity.getGUID(), relationshipsToConnectorType.get(0))) != null && (properties = connectorType.getProperties()) != null) {
            connection.setConnectorName(this.getPropertyValue(properties, "name"));
            connection.setConnectorDescription(this.getPropertyValue(properties, "description"));
            connection.setConnectorProvider(this.getPropertyValue(properties, "connectorProviderClassName"));
        }
    }

    private String getPropertyValue(InstanceProperties instanceProperties, String propertyName) {
        PrimitivePropertyValue value = (PrimitivePropertyValue)instanceProperties.getPropertyValue(propertyName);
        if (value != null) {
            return (String)value.getPrimitiveValue();
        }
        return null;
    }

    private void getTableTypeAttributes(Table table, EntityDetail relationalTableType) {
        InstanceProperties properties = relationalTableType.getProperties();
        table.setGuid(relationalTableType.getGUID());
        table.setTypeName(this.getPropertyValue(properties, "displayName"));
        table.setOwner(this.getPropertyValue(properties, "owner"));
        table.setTypeUsage(this.getPropertyValue(properties, "usage"));
        table.setTypeEncodingStandard(this.getPropertyValue(properties, "encodingStandard"));
        table.setTypeVersion(this.getPropertyValue(properties, "versionNumber"));
    }

    private Schema getSchema(EntityDetail entityDb) {
        InstanceProperties properties = entityDb.getProperties();
        Schema schema = new Schema();
        schema.setGuid(entityDb.getGUID());
        schema.setAuthor(this.getPropertyValue(properties, "author"));
        schema.setName(this.getPropertyValue(properties, "displayName"));
        schema.setEncodingStandard(this.getPropertyValue(properties, "encodingStandard"));
        schema.setVersionNr(this.getPropertyValue(properties, "versionNumber"));
        return schema;
    }

    private Database getDatabase(EntityDetail databaseEntity) {
        InstanceProperties properties = databaseEntity.getProperties();
        Database database = new Database();
        database.setGuid(databaseEntity.getGUID());
        database.setName(this.getPropertyValue(properties, "name"));
        database.setDescription(this.getPropertyValue(properties, "description"));
        database.setOwner(this.getPropertyValue(properties, "owner"));
        database.setType(this.getPropertyValue(properties, "type"));
        return database;
    }

    private Endpoint getEndpoint(EntityDetail endpointEntity) {
        InstanceProperties properties = endpointEntity.getProperties();
        Endpoint endpoint = new Endpoint();
        endpoint.setGuid(endpointEntity.getGUID());
        endpoint.setName(this.getPropertyValue(properties, "name"));
        endpoint.setDescription(this.getPropertyValue(properties, "description"));
        endpoint.setNetworkAddress(this.getPropertyValue(properties, "networkAddress"));
        endpoint.setProtocol(this.getPropertyValue(properties, "protocol"));
        endpoint.setEncryptionMethod(this.getPropertyValue(properties, "encryptionMethod"));
        return endpoint;
    }

    private EntityDetail getThePairEntity(String userId, String entityDetailGUID, Relationship relationship) {
        try {
            if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
                return metadataCollection.getEntityDetail(userId, relationship.getEntityTwoProxy().getGUID());
            }
            return metadataCollection.getEntityDetail(userId, relationship.getEntityOneProxy().getGUID());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

