/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.service;

import java.util.List;
import org.odpi.openmetadata.accessservice.assetcatalog.admin.AssetCatalogAdmin;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.RelationshipNotFoundException;
import org.odpi.openmetadata.accessservice.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.service.RepositoryValidatorHandler;
import org.odpi.openmetadata.accessservice.assetcatalog.util.Converter;
import org.odpi.openmetadata.accessservice.assetcatalog.util.ExceptionHandler;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class AssetCatalogRelationshipService {
    private static OMRSRepositoryConnector repositoryConnector;
    private static String serverName;
    private Converter converter = new Converter();
    private ExceptionHandler exceptionHandler = new ExceptionHandler();
    private RepositoryValidatorHandler repositoryHandler;

    public AssetCatalogRelationshipService() {
        AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CATALOG_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, AssetCatalogAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
        this.repositoryHandler = new RepositoryValidatorHandler(repositoryConnector);
    }

    public static void setRepositoryConnector(OMRSRepositoryConnector repositoryConnector, String serverName) {
        AssetCatalogRelationshipService.repositoryConnector = repositoryConnector;
        AssetCatalogRelationshipService.serverName = serverName;
    }

    public RelationshipResponse getRelationshipById(String userId, String relationshipId) {
        RelationshipResponse response = new RelationshipResponse();
        try {
            Relationship relationship = this.getRelationship(userId, relationshipId);
            response.setRelationship(this.converter.toRelationship(relationship));
        }
        catch (PropertyServerException | RelationshipNotFoundException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        catch (InvalidParameterException | RelationshipNotKnownException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public RelationshipsResponse getRelationshipByProperty(String userId, String relationshipTypeGUID, String matchProperty, String propertyValue, Integer pageSize, Integer fromElement, SequenceOrderType orderType, String orderProperty, Status status) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List<Relationship> relationshipsByProperty = this.getRelationshipsByProperty(userId, relationshipTypeGUID, matchProperty, propertyValue, pageSize, fromElement, orderType, orderProperty, status);
            response.setRelationships(this.converter.toRelationships(relationshipsByProperty));
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException | RelationshipNotFoundException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public RelationshipsResponse searchForRelationships(String userId, String relationshipTypeGUID, String searchCriteria, Integer pageSize, Integer fromElement, String orderProperty, SequenceOrderType orderType, Status status) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List<Relationship> relationships = this.searchRelationships(userId, relationshipTypeGUID, searchCriteria, pageSize, fromElement, orderProperty, orderType, status);
            response.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (PropertyServerException | RelationshipNotFoundException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    private Relationship getRelationship(String userId, String relationshipId) throws PropertyServerException, InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException, RelationshipNotFoundException {
        OMRSMetadataCollection metadataCollection = this.repositoryHandler.getMetadataCollection();
        Relationship relationship = metadataCollection.getRelationship(userId, relationshipId);
        if (relationship == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.RELATIONSHIP_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationshipId, serverName});
            throw new RelationshipNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRelationshipById", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationship;
    }

    private List<Relationship> getRelationshipsByProperty(String userId, String relationshipTypeGUID, String matchProperty, String propertyValue, Integer pageSize, Integer fromElement, SequenceOrderType orderType, String orderProperty, Status status) throws PropertyServerException, InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException, RelationshipNotFoundException {
        OMRSMetadataCollection metadataCollection = this.repositoryHandler.getMetadataCollection();
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        SequencingOrder order = this.converter.getSequencingOrder(orderType);
        InstanceProperties matchProperties = this.converter.getMatchProperties(matchProperty, propertyValue);
        List relationshipsByProperty = metadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, MatchCriteria.ANY, fromElement.intValue(), limitResultsByStatus, null, orderProperty, order, pageSize.intValue());
        if (relationshipsByProperty == null || relationshipsByProperty.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.RELATIONSHIPS_WITH_PROPERTY_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{matchProperty, serverName});
            throw new RelationshipNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRelationshipByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationshipsByProperty;
    }

    private List<Relationship> searchRelationships(String userId, String relationshipTypeGUID, String searchCriteria, Integer pageSize, Integer fromElement, String orderProperty, SequenceOrderType orderType, Status status) throws PropertyServerException, InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException, RelationshipNotFoundException {
        OMRSMetadataCollection metadataCollection = this.repositoryHandler.getMetadataCollection();
        SequencingOrder order = this.converter.getSequencingOrder(orderType);
        List<InstanceStatus> statusList = this.converter.getInstanceStatuses(status);
        List relationshipsByPropertyValue = metadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromElement.intValue(), statusList, null, orderProperty, order, pageSize.intValue());
        if (relationshipsByPropertyValue == null || relationshipsByPropertyValue.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.RELATIONSHIPS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{searchCriteria, serverName});
            throw new RelationshipNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationshipsByPropertyValue;
    }
}

