/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservice.assetcatalog.admin.AssetCatalogAdmin;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.AssetNotFoundException;
import org.odpi.openmetadata.accessservice.assetcatalog.exception.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservice.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Column;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Connection;
import org.odpi.openmetadata.accessservice.assetcatalog.model.DataType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Database;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Endpoint;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Schema;
import org.odpi.openmetadata.accessservice.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Table;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.util.Converter;
import org.odpi.openmetadata.accessservice.assetcatalog.util.ExceptionHandler;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class AssetCatalogService {
    private static OMRSRepositoryConnector repositoryConnector;
    private static String serverName;
    private Converter converter = new Converter();
    private ExceptionHandler exceptionUtil = new ExceptionHandler();

    public AssetCatalogService() {
        AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CATALOG_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, AssetCatalogAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
    }

    public static void setRepositoryConnector(OMRSRepositoryConnector repositoryConnector, String serverName) {
        AssetCatalogService.repositoryConnector = repositoryConnector;
        AssetCatalogService.serverName = serverName;
    }

    public AssetDescriptionResponse getAssetSummaryById(String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntitySummary entitySummary = this.getEntitySummary(userId, assetId);
            AssetDescription assetDescription = this.converter.getAssetDescription(entitySummary);
            response.setAssetDescriptionList(Arrays.asList(assetDescription));
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetDetailsById(String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntityDetail entityDetail = this.getEntityDetails(userId, assetId);
            AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
            response.setAssetDescriptionList(Arrays.asList(assetDescription));
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public ClassificationsResponse getClassificationByAssetGUID(String userId, String assetId, Integer limit, Integer offset) {
        ClassificationsResponse response = new ClassificationsResponse();
        try {
            List<Classification> assetClassifications = this.getAssetClassifications(userId, assetId);
            response.setClassifications(this.converter.toClassifications(assetClassifications));
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException | ClassificationNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public RelationshipsResponse getAssetRelationships(String userId, String assetId, String relationshipType, Status status, Integer fromElement, Integer pageSize, String property, SequenceOrderType orderType) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            String relationshipTypeID = this.getTypeID(userId, relationshipType);
            List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
            SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
            List<Relationship> relationships = this.getRelationships(userId, assetId, fromElement, pageSize, property, relationshipTypeID, instanceStatuses, sequencingOrder);
            response.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsByClassificationName(String userId, String assetTypeId, String classificationName, Integer limit, Integer offset, String orderProperty, SequenceOrderType orderType, Status status) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<EntityDetail> entitiesByClassification = this.findEntitiesByClassifications(userId, assetTypeId, classificationName, limit, offset, orderProperty, orderType, status);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesByClassification));
        }
        catch (ClassificationErrorException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsByProperty(String userId, String assetTypeId, String matchProperty, String propertyValue, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<EntityDetail> entitiesByProperty = this.findEntitiesByProperty(userId, assetTypeId, matchProperty, propertyValue, limit, offset, orderType, orderProperty, status);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesByProperty));
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsFromNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<EntityDetail> entitiesFromNeighborhood = this.getEntitiesFromNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesFromNeighborhood));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public RelationshipsResponse getRelationshipsFromNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List<Relationship> relationshipsFromAssetNeighborhood = this.getRelationshipsFromAssetNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
            response.setRelationships(this.converter.toRelationships(relationshipsFromAssetNeighborhood));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetUniverseByGUID(String userId, String assetGUID) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        AssetDescription assetDescription = new AssetDescription();
        try {
            EntityDetail entityDetails = this.getEntityDetails(userId, assetGUID);
            assetDescription = this.converter.getAssetDescription(entityDetails);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        try {
            List<Relationship> relationships = this.getRelationships(userId, assetGUID, 0, 0, null, null, null, null);
            assetDescription.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        response.setAssetDescriptionList(Arrays.asList(assetDescription));
        return response;
    }

    public RelationshipsResponse getLinkingRelationships(String userId, String startAssetId, String endAssetId) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List<Relationship> relationships = this.getLinkingRelationshipsBetweenAssets(userId, startAssetId, endAssetId);
            response.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetDescriptionResponse getLinkingAssets(String userId, String startAssetId, String endAssetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<EntityDetail> intermediateAssets = this.getIntermediateAssets(userId, startAssetId, endAssetId);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(intermediateAssets));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetDescriptionResponse getRelatedAssets(String userId, String startAssetId, String instanceType, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<EntityDetail> relatedAssets = this.getRelatedAsset(userId, startAssetId, instanceType, limit, offset, orderType, orderProperty, status);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(relatedAssets));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public List<AssetDescription> getLastUpdatedAssets(String userId, String entityTypeGUID, Date fromDate, Date toDate, Status status, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status1) {
        return null;
    }

    public List<AssetDescription> getLastCreatedAssets(String userId, String assetTypeId, Date fromDate, Date toDate, Status status, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status1) {
        return null;
    }

    public AssetDescriptionResponse searchAssets(String userId, String searchCriteria) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
            List<EntityDetail> matchCriteriaEntities = this.findEntitiesBySearchCriteria(metadataCollection, userId, searchCriteria);
            ArrayList<AssetDescription> assetDescriptions = new ArrayList<AssetDescription>(matchCriteriaEntities.size());
            for (EntityDetail entityDetail : matchCriteriaEntities) {
                AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
                ArrayList<Connection> connections = new ArrayList<Connection>();
                if (!entityDetail.getType().getTypeDefName().equals("GlossaryTerm")) {
                    Connection connection = this.getConnectionToAsset(metadataCollection, userId, entityDetail);
                    connections.add(connection);
                } else {
                    List<Relationship> relationshipsToColumn = this.getRelationshipByType(metadataCollection, userId, entityDetail.getGUID(), "SemanticAssignment");
                    if (relationshipsToColumn != null && !relationshipsToColumn.isEmpty()) {
                        assetDescription.setRelationships(this.converter.toRelationships(relationshipsToColumn));
                        for (Relationship relationship : relationshipsToColumn) {
                            EntityDetail relationalColumn = this.getThePairEntity(metadataCollection, userId, entityDetail.getGUID(), relationship);
                            if (relationalColumn == null) continue;
                            Connection connection = this.getConnectionToAsset(metadataCollection, userId, relationalColumn);
                            connections.add(connection);
                        }
                    }
                }
                assetDescription.setConnection(connections);
                assetDescriptions.add(assetDescription);
            }
            response.setAssetDescriptionList(assetDescriptions);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    private EntitySummary getEntitySummary(String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, AssetNotFoundException {
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        EntitySummary entitySummary = metadataCollection.getEntitySummary(userId, assetId);
        if (entitySummary == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitySummary;
    }

    private EntityDetail getEntityDetails(String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, AssetNotFoundException {
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        EntityDetail entityDetail = metadataCollection.getEntityDetail(userId, assetId);
        if (entityDetail == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entityDetail;
    }

    private List<Classification> getAssetClassifications(String userId, String assetId) throws UserNotAuthorizedException, EntityNotKnownException, InvalidParameterException, RepositoryErrorException, EntityProxyOnlyException, AssetNotFoundException, ClassificationNotFoundException {
        EntityDetail asset = this.getEntityDetails(userId, assetId);
        if (asset.getClassifications() == null || asset.getClassifications().isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new ClassificationNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return asset.getClassifications();
    }

    private String getTypeID(String userId, String relationshipType) throws AssetNotFoundException, RepositoryErrorException {
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        if (relationshipType == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.PARAMETER_NULL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"type", "getTypeID"});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            return metadataCollection.getTypeDefByName(userId, relationshipType).getGUID();
        }
        catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Relationship> getRelationships(String userId, String assetId, Integer fromElement, Integer pageSize, String property, String relationshipTypeID, List<InstanceStatus> instanceStatuses, SequencingOrder sequencingOrder) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException {
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        List relationshipsForEntity = metadataCollection.getRelationshipsForEntity(userId, assetId, relationshipTypeID, fromElement.intValue(), instanceStatuses, null, property, sequencingOrder, pageSize.intValue());
        if (relationshipsForEntity == null || relationshipsForEntity.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.RELATIONSHIPS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationshipsForEntity;
    }

    private List<EntityDetail> getEntitiesFromNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, AssetNotFoundException {
        InstanceGraph entityNeighborhood = this.getAssetNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
        List entities = entityNeighborhood.getEntities();
        if (entities == null || entities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_ASSET_FROM_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getEntitiesFromNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entities;
    }

    private List<Relationship> getRelationshipsFromAssetNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws InvalidParameterException, PropertyErrorException, AssetNotFoundException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException, TypeErrorException, RepositoryErrorException {
        InstanceGraph entityNeighborhood = this.getAssetNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
        List entities = entityNeighborhood.getRelationships();
        if (entities == null || entities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_RELATIONSHIPS_FROM_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRelationshipsFromAssetNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entities;
    }

    private InstanceGraph getAssetNeighborhood(String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, AssetNotFoundException {
        List<InstanceStatus> limitResultsByStatus;
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        InstanceGraph entityNeighborhood = metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, limitResultsByStatus = this.converter.getInstanceStatuses(relationshipStatus), null, null, level.intValue());
        if (entityNeighborhood == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getAssetNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entityNeighborhood;
    }

    private List<EntityDetail> findEntitiesBySearchCriteria(OMRSMetadataCollection metadataCollection, String userId, String searchCriteria) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        entities.addAll(this.findEntitiesByType(metadataCollection, userId, searchCriteria, "GlossaryTerm"));
        entities.addAll(this.findEntitiesByType(metadataCollection, userId, searchCriteria, "Asset"));
        entities.addAll(this.findEntitiesByType(metadataCollection, userId, searchCriteria, "SchemaElement"));
        return entities;
    }

    private List<EntityDetail> findEntitiesByType(OMRSMetadataCollection metadataCollection, String userId, String searchCriteria, String entityType) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        List entitiesByPropertyValue;
        String GUID = null;
        if (entityType != null) {
            GUID = this.getTypeByName(metadataCollection, userId, entityType);
        }
        if ((entitiesByPropertyValue = metadataCollection.findEntitiesByPropertyValue(userId, GUID, searchCriteria, 0, null, null, null, null, SequencingOrder.ANY, 0)) != null) {
            return entitiesByPropertyValue;
        }
        return new ArrayList<EntityDetail>();
    }

    private List<Relationship> getRelationshipByType(OMRSMetadataCollection metadataCollection, String userId, String entityGUID, String relationshipType) {
        String guid = null;
        if (relationshipType != null) {
            guid = this.getTypeByName(metadataCollection, userId, relationshipType);
        }
        ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>(1);
        instanceStatuses.add(InstanceStatus.ACTIVE);
        try {
            List relationshipsForEntity = metadataCollection.getRelationshipsForEntity(userId, entityGUID, guid, 0, instanceStatuses, null, null, SequencingOrder.ANY, 0);
            if (relationshipsForEntity != null) {
                return relationshipsForEntity;
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
        return new ArrayList<Relationship>();
    }

    private String getTypeByName(OMRSMetadataCollection metadataCollection, String userId, String typeName) {
        try {
            TypeDef typeDefByName = metadataCollection.getTypeDefByName(userId, typeName);
            return typeDefByName.getGUID();
        }
        catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Connection getConnectionToAsset(OMRSMetadataCollection metadataCollection, String userId, EntityDetail relationalColumn) {
        String typeDefName;
        Connection connection = new Connection();
        switch (typeDefName = relationalColumn.getType().getTypeDefName()) {
            case "RelationalColumn": {
                this.processColumn(metadataCollection, userId, relationalColumn, connection);
                break;
            }
            case "RelationalTable": {
                this.processRelationalTable(metadataCollection, userId, connection, new Table(), relationalColumn);
                break;
            }
            case "DataStore": {
                this.processDataStore(metadataCollection, userId, connection, relationalColumn);
            }
        }
        return connection;
    }

    private void processColumn(OMRSMetadataCollection metadataCollection, String userId, EntityDetail relationalColumn, Connection connection) {
        EntityDetail relationalTableType;
        Column column = this.getColumn(metadataCollection, userId, relationalColumn);
        connection.setColumn(column);
        Table table = new Table();
        List<Relationship> relationshipsToTableType = this.getRelationshipByType(metadataCollection, userId, relationalColumn.getGUID(), "AttributeForSchema");
        if (relationshipsToTableType != null && !relationshipsToTableType.isEmpty() && (relationalTableType = this.getThePairEntity(metadataCollection, userId, relationalColumn.getGUID(), relationshipsToTableType.get(0))) != null) {
            EntityDetail relationalTable;
            this.getTableTypeAttributes(table, relationalTableType);
            List<Relationship> relationshipsToTables = this.getRelationshipByType(metadataCollection, userId, relationalTableType.getGUID(), "SchemaAttributeType");
            if (relationshipsToTables != null && !relationshipsToTables.isEmpty() && (relationalTable = this.getThePairEntity(metadataCollection, userId, relationalTableType.getGUID(), relationshipsToTables.get(0))) != null) {
                this.processRelationalTable(metadataCollection, userId, connection, table, relationalTable);
            }
        }
    }

    private DataType getColumnType(OMRSMetadataCollection metadataCollection, String userId, EntityDetail relationalColumn) {
        EntityDetail columnType;
        List<Relationship> relationshipsToType = this.getRelationshipByType(metadataCollection, userId, relationalColumn.getGUID(), "SchemaAttributeType");
        if (relationshipsToType != null && !relationshipsToType.isEmpty() && (columnType = this.getThePairEntity(metadataCollection, userId, relationalColumn.getGUID(), relationshipsToType.get(0))) != null && columnType.getProperties() != null) {
            PrimitivePropertyValue value = (PrimitivePropertyValue)columnType.getProperties().getPropertyValue("type");
            if (value != null) {
                PrimitiveDefCategory primitiveValue = value.getPrimitiveDefCategory();
                return this.converter.getDataTypeDef(primitiveValue);
            }
            return null;
        }
        return null;
    }

    private void processRelationalTable(OMRSMetadataCollection metadataCollection, String userId, Connection connection, Table table, EntityDetail relationalTable) {
        EntityDetail relationalDbSchemaType;
        table.setName(this.getPropertyValue(relationalTable.getProperties(), "name"));
        table.setGuid(relationalTable.getGUID());
        connection.setTable(table);
        List<Relationship> relationshipsToRelationalDBSchemaType = this.getRelationshipByType(metadataCollection, userId, relationalTable.getGUID(), "AttributeForSchema");
        if (relationshipsToRelationalDBSchemaType != null && !relationshipsToRelationalDBSchemaType.isEmpty() && (relationalDbSchemaType = this.getThePairEntity(metadataCollection, userId, relationalTable.getGUID(), relationshipsToRelationalDBSchemaType.get(0))) != null) {
            EntityDetail deployedDbSchema;
            Schema schema = this.getSchema(relationalDbSchemaType);
            List<Relationship> relationshipsToDeployedDBSchema = this.getRelationshipByType(metadataCollection, userId, relationalDbSchemaType.getGUID(), "AssetSchemaType");
            if (relationshipsToDeployedDBSchema != null && !relationshipsToDeployedDBSchema.isEmpty() && (deployedDbSchema = this.getThePairEntity(metadataCollection, userId, relationalDbSchemaType.getGUID(), relationshipsToDeployedDBSchema.get(0))) != null && deployedDbSchema.getProperties() != null) {
                schema.setDeployedDbSchemaName(this.getPropertyValue(deployedDbSchema.getProperties(), "name"));
                List<Relationship> relationshipsToDataStore = this.getRelationshipByType(metadataCollection, userId, deployedDbSchema.getGUID(), "DataContentForDataSet");
                if (relationshipsToDataStore != null && !relationshipsToDataStore.isEmpty()) {
                    EntityDetail dataStore = this.getThePairEntity(metadataCollection, userId, deployedDbSchema.getGUID(), relationshipsToDataStore.get(0));
                    this.processDataStore(metadataCollection, userId, connection, dataStore);
                }
            }
            connection.setSchema(schema);
        }
    }

    private void processDataStore(OMRSMetadataCollection metadataCollection, String userId, Connection connection, EntityDetail dataStore) {
        Database database = this.getDatabase(dataStore);
        connection.setDatabase(database);
        this.getPropertiesForDataStore(metadataCollection, userId, connection, dataStore);
    }

    private void getPropertiesForDataStore(OMRSMetadataCollection metadataCollection, String userId, Connection connection, EntityDetail dataStore) {
        InstanceProperties properties;
        EntityDetail connectionEntity;
        List<Relationship> relationshipsToConnection = this.getRelationshipByType(metadataCollection, userId, dataStore.getGUID(), "ConnectionToAsset");
        if (relationshipsToConnection != null && !relationshipsToConnection.isEmpty() && (connectionEntity = this.getThePairEntity(metadataCollection, userId, dataStore.getGUID(), relationshipsToConnection.get(0))) != null && (properties = connectionEntity.getProperties()) != null) {
            connection.setDisplayName(this.getPropertyValue(properties, "name"));
            connection.setDescription(this.getPropertyValue(properties, "description"));
            connection.setGuid(connectionEntity.getGUID());
            this.getConnectorType(metadataCollection, userId, connection, connectionEntity);
            this.buildEndpoint(metadataCollection, userId, connection, connectionEntity);
        }
    }

    private Column getColumn(OMRSMetadataCollection metadataCollection, String userId, EntityDetail relationalColumn) {
        Column column = new Column();
        column.setName(this.getPropertyValue(relationalColumn.getProperties(), "name"));
        column.setType(this.getColumnType(metadataCollection, userId, relationalColumn));
        column.setGuid(relationalColumn.getGUID());
        return column;
    }

    private void buildEndpoint(OMRSMetadataCollection metadataCollection, String userId, Connection connection, EntityDetail connectionEntity) {
        EntityDetail endpointEntity;
        List<Relationship> relationshipsToEndpoint = this.getRelationshipByType(metadataCollection, userId, connectionEntity.getGUID(), "ConnectionEndpoint");
        if (relationshipsToEndpoint != null && !relationshipsToEndpoint.isEmpty() && (endpointEntity = this.getThePairEntity(metadataCollection, userId, connectionEntity.getGUID(), relationshipsToEndpoint.get(0))) != null) {
            Endpoint endpoint = this.getEndpoint(endpointEntity);
            connection.setEndpoint(endpoint);
        }
    }

    private void getConnectorType(OMRSMetadataCollection metadataCollection, String userId, Connection connection, EntityDetail connectionEntity) {
        InstanceProperties properties;
        EntityDetail connectorType;
        List<Relationship> relationshipsToConnectorType = this.getRelationshipByType(metadataCollection, userId, connectionEntity.getGUID(), "ConnectionConnectorType");
        if (relationshipsToConnectorType != null && !relationshipsToConnectorType.isEmpty() && (connectorType = this.getThePairEntity(metadataCollection, userId, connectionEntity.getGUID(), relationshipsToConnectorType.get(0))) != null && (properties = connectorType.getProperties()) != null) {
            connection.setConnectorName(this.getPropertyValue(properties, "name"));
            connection.setConnectorDescription(this.getPropertyValue(properties, "description"));
            connection.setConnectorProvider(this.getPropertyValue(properties, "connectorProviderClassName"));
        }
    }

    private String getPropertyValue(InstanceProperties instanceProperties, String propertyName) {
        PrimitivePropertyValue value = (PrimitivePropertyValue)instanceProperties.getPropertyValue(propertyName);
        if (value != null) {
            return (String)value.getPrimitiveValue();
        }
        return null;
    }

    private void getTableTypeAttributes(Table table, EntityDetail relationalTableType) {
        InstanceProperties properties = relationalTableType.getProperties();
        table.setGuid(relationalTableType.getGUID());
        table.setTypeName(this.getPropertyValue(properties, "displayName"));
        table.setOwner(this.getPropertyValue(properties, "owner"));
        table.setTypeUsage(this.getPropertyValue(properties, "usage"));
        table.setTypeEncodingStandard(this.getPropertyValue(properties, "encodingStandard"));
        table.setTypeVersion(this.getPropertyValue(properties, "versionNumber"));
    }

    private Schema getSchema(EntityDetail entityDb) {
        InstanceProperties properties = entityDb.getProperties();
        Schema schema = new Schema();
        schema.setGuid(entityDb.getGUID());
        schema.setAuthor(this.getPropertyValue(properties, "author"));
        schema.setName(this.getPropertyValue(properties, "displayName"));
        schema.setEncodingStandard(this.getPropertyValue(properties, "encodingStandard"));
        schema.setVersionNr(this.getPropertyValue(properties, "versionNumber"));
        return schema;
    }

    private Database getDatabase(EntityDetail databaseEntity) {
        InstanceProperties properties = databaseEntity.getProperties();
        Database database = new Database();
        database.setGuid(databaseEntity.getGUID());
        database.setName(this.getPropertyValue(properties, "name"));
        database.setDescription(this.getPropertyValue(properties, "description"));
        database.setOwner(this.getPropertyValue(properties, "owner"));
        database.setType(this.getPropertyValue(properties, "type"));
        return database;
    }

    private Endpoint getEndpoint(EntityDetail endpointEntity) {
        InstanceProperties properties = endpointEntity.getProperties();
        Endpoint endpoint = new Endpoint();
        endpoint.setGuid(endpointEntity.getGUID());
        endpoint.setName(this.getPropertyValue(properties, "name"));
        endpoint.setDescription(this.getPropertyValue(properties, "description"));
        endpoint.setNetworkAddress(this.getPropertyValue(properties, "networkAddress"));
        endpoint.setProtocol(this.getPropertyValue(properties, "protocol"));
        endpoint.setEncryptionMethod(this.getPropertyValue(properties, "encryptionMethod"));
        return endpoint;
    }

    private EntityDetail getThePairEntity(OMRSMetadataCollection metadataCollection, String userId, String entityDetailGUID, Relationship relationship) {
        try {
            if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
                return metadataCollection.getEntityDetail(userId, relationship.getEntityTwoProxy().getGUID());
            }
            return metadataCollection.getEntityDetail(userId, relationship.getEntityOneProxy().getGUID());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<EntityDetail> findEntitiesByClassifications(String userId, String assetTypeId, String classificationName, Integer limit, Integer offset, String orderProperty, SequenceOrderType orderType, Status status) throws ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException {
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List entitiesByClassification = metadataCollection.findEntitiesByClassification(userId, assetTypeId, classificationName, null, null, offset.intValue(), instanceStatuses, null, orderProperty, sequencingOrder, limit.intValue());
        if (entitiesByClassification == null || entitiesByClassification.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_WITH_CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationName, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitiesByClassification;
    }

    private List<EntityDetail> findEntitiesByProperty(String userId, String assetTypeId, String matchProperty, String propertyValue, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException {
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        InstanceProperties matchProperties = matchProperty != null ? this.converter.getMatchProperties(matchProperty, propertyValue) : this.converter.getMatchProperties("qualifiedName", propertyValue);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List entitiesByProperty = metadataCollection.findEntitiesByProperty(userId, assetTypeId, matchProperties, MatchCriteria.ANY, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue());
        if (entitiesByProperty == null || entitiesByProperty.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_WITH_CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{matchProperty, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitiesByProperty;
    }

    private List<Relationship> getLinkingRelationshipsBetweenAssets(String userId, String startAssetId, String endAssetId) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, AssetNotFoundException {
        List<InstanceStatus> limitByStatus;
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus = this.converter.getInstanceStatuses(null), null);
        if (linkingEntities == null || linkingEntities.getRelationships() != null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.LINKING_RELATIONSHIPS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, endAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getLinkingRelationshipsBetweenAssets", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return linkingEntities.getRelationships();
    }

    private List<EntityDetail> getIntermediateAssets(String userId, String startAssetId, String endAssetId) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, AssetNotFoundException {
        List<InstanceStatus> limitByStatus;
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus = this.converter.getInstanceStatuses(null), null);
        if (linkingEntities == null || linkingEntities.getEntities() == null || linkingEntities.getEntities().isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.LINKING_ASSETS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, endAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getIntermediateAssets", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return linkingEntities.getEntities();
    }

    private List<EntityDetail> getRelatedAsset(String userId, String startAssetId, final String instanceType, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException {
        List relatedEntities;
        OMRSMetadataCollection metadataCollection = repositoryConnector.getMetadataCollection();
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        ArrayList<String> instanceTypes = null;
        if (instanceType != null) {
            instanceTypes = new ArrayList<String>(){
                {
                    this.add(instanceType);
                }
            };
        }
        if ((relatedEntities = metadataCollection.getRelatedEntities(userId, startAssetId, (List)instanceTypes, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue())) == null || relatedEntities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_RELATED_ASSETS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relatedEntities;
    }
}

