/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.service;

import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogRegistration;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogServicesInstance;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogServicesInstanceMap;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class AssetCatalogInstanceHandler {
    private static AssetCatalogServicesInstanceMap instanceMap = new AssetCatalogServicesInstanceMap();

    AssetCatalogInstanceHandler() {
        AssetCatalogRegistration.registerAccessService();
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws PropertyServerException {
        AssetCatalogServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance == null) {
            this.throwServiceNotInitializedException(serverName, "getMetadataCollection");
        }
        return instance.getMetadataCollection();
    }

    public OMRSRepositoryHelper getRepositoryHelper(String serverName) throws PropertyServerException {
        AssetCatalogServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance == null) {
            return this.throwServiceNotInitializedException(serverName, "getRepositoryHelper");
        }
        return instance.getRepositoryHelper();
    }

    private OMRSRepositoryHelper throwServiceNotInitializedException(String serverName, String getRepositoryHelper) throws PropertyServerException {
        String methodName = getRepositoryHelper;
        AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
        throw new PropertyServerException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

