/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetNotFoundException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.NotImplementedException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetElement;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Column;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Connection;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Connector;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Context;
import org.odpi.openmetadata.accessservices.assetcatalog.model.DataType;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Database;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Element;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Endpoint;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Schema;
import org.odpi.openmetadata.accessservices.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Table;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Term;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogInstanceHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.util.Converter;
import org.odpi.openmetadata.accessservices.assetcatalog.util.ExceptionHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class AssetCatalogService {
    private static AssetCatalogInstanceHandler instanceHandler = new AssetCatalogInstanceHandler();
    private OMRSMetadataCollection metadataCollectionForSearch;
    private String serverName;
    private TypeDefGallery allTypes = new TypeDefGallery();
    private Converter converter = new Converter();
    private ExceptionHandler exceptionUtil = new ExceptionHandler();

    public AssetDescriptionResponse getAssetSummaryById(String serverName, String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntitySummary entitySummary = this.getEntitySummary(serverName, userId, assetId);
            AssetDescription assetDescription = this.converter.getAssetDescription(entitySummary);
            ArrayList<AssetDescription> assets = new ArrayList<AssetDescription>(1);
            assets.add(assetDescription);
            response.setAssetDescriptionList(assets);
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetDetailsById(String serverName, String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntityDetail entityDetail = this.getEntityDetails(serverName, userId, assetId);
            AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
            ArrayList<AssetDescription> assets = new ArrayList<AssetDescription>(1);
            assets.add(assetDescription);
            response.setAssetDescriptionList(assets);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public ClassificationsResponse getClassificationByAssetGUID(String serverName, String userId, String assetId, SearchParameters searchParameters) {
        ClassificationsResponse response = new ClassificationsResponse();
        try {
            List<Classification> assetClassifications = this.getAssetClassifications(serverName, userId, assetId);
            response.setClassifications(this.converter.toClassifications(assetClassifications));
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public RelationshipsResponse getAssetRelationships(String serverName, String userId, String assetId, SearchParameters parameters) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            String relationshipType = null;
            Status status = null;
            Integer fromElement = null;
            Integer pageSize = null;
            String property = null;
            SequenceOrderType orderType = null;
            if (parameters != null) {
                status = parameters.getStatus();
                orderType = parameters.getOrderType();
                property = parameters.getPropertyName();
                pageSize = parameters.getLimit();
                fromElement = parameters.getOffset();
                if (parameters.getTypes() != null && !parameters.getTypes().isEmpty()) {
                    relationshipType = (String)parameters.getTypes().get(0);
                }
            }
            String relationshipTypeID = this.getTypeDefGUID(userId, relationshipType, serverName);
            List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
            SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
            List<Relationship> relationships = this.getRelationships(serverName, userId, assetId, fromElement, pageSize, property, relationshipTypeID, instanceStatuses, sequencingOrder);
            response.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsByClassificationName(String serverName, String userId, String classificationName, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            String assetTypeId = null;
            Status status = null;
            Integer offset = null;
            Integer limit = null;
            String property = null;
            SequenceOrderType orderType = null;
            if (searchParameters != null) {
                status = searchParameters.getStatus();
                orderType = searchParameters.getOrderType();
                property = searchParameters.getPropertyName();
                limit = searchParameters.getLimit();
                offset = searchParameters.getOffset();
                if (searchParameters.getTypes() != null && !searchParameters.getTypes().isEmpty()) {
                    assetTypeId = (String)searchParameters.getTypes().get(0);
                }
            }
            List<EntityDetail> entitiesByClassification = this.findEntitiesByClassifications(serverName, userId, assetTypeId, classificationName, limit, offset, property, orderType, status);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesByClassification));
        }
        catch (ClassificationErrorException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsByProperty(String serverName, String userId, String propertyValue, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            String assetTypeId = null;
            Status status = null;
            Integer offset = null;
            Integer limit = null;
            String propertyName = null;
            String orderProperty = null;
            SequenceOrderType orderType = null;
            if (searchParameters != null) {
                status = searchParameters.getStatus();
                orderType = searchParameters.getOrderType();
                orderProperty = searchParameters.getOrderProperty();
                propertyName = searchParameters.getPropertyName();
                limit = searchParameters.getLimit();
                offset = searchParameters.getOffset();
                if (searchParameters.getTypes() != null && !searchParameters.getTypes().isEmpty()) {
                    assetTypeId = (String)searchParameters.getTypes().get(0);
                }
            }
            List<EntityDetail> entitiesByProperty = this.findEntitiesByProperty(serverName, userId, assetTypeId, propertyName, propertyValue, limit, offset, orderType, orderProperty, status);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesByProperty));
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsFromNeighborhood(String serverName, String userId, String entityGUID, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            Integer level = null;
            Status status = null;
            List entityTypesGuid = null;
            List<String> relationshipTypes = null;
            if (searchParameters != null) {
                status = searchParameters.getStatus();
                level = searchParameters.getLevel();
                if (searchParameters.getTypes() != null) {
                    entityTypesGuid = searchParameters.getTypes();
                }
            }
            List<EntityDetail> entitiesFromNeighborhood = this.getEntitiesFromNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, status, level);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesFromNeighborhood));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public RelationshipsResponse getRelationshipsFromNeighborhood(String serverName, String userId, String entityGUID, SearchParameters searchParameters) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            Integer level = null;
            List entityTypesGuid = null;
            List<String> relationshipTypes = null;
            Status relationshipStatus = null;
            if (searchParameters != null) {
                level = searchParameters.getLevel();
                relationshipStatus = searchParameters.getStatus();
                if (searchParameters.getTypes() != null) {
                    entityTypesGuid = searchParameters.getTypes();
                }
            }
            List<Relationship> relationshipsFromAssetNeighborhood = this.getRelationshipsFromAssetNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
            response.setRelationships(this.converter.toRelationships(relationshipsFromAssetNeighborhood));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetUniverseByGUID(String serverName, String userId, String assetGUID) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        AssetDescription assetDescription = new AssetDescription();
        try {
            EntityDetail entityDetails = this.getEntityDetails(serverName, userId, assetGUID);
            assetDescription = this.converter.getAssetDescription(entityDetails);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        try {
            List<Relationship> relationships = this.getRelationships(serverName, userId, assetGUID, 0, 0, null, null, null, null);
            assetDescription.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        ArrayList<AssetDescription> assets = new ArrayList<AssetDescription>(1);
        assets.add(assetDescription);
        response.setAssetDescriptionList(assets);
        return response;
    }

    public RelationshipsResponse getLinkingRelationships(String serverName, String userId, String startAssetId, String endAssetId) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List<Relationship> relationships = this.getLinkingRelationshipsBetweenAssets(serverName, userId, startAssetId, endAssetId);
            response.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getLinkingAssets(String serverName, String userId, String startAssetId, String endAssetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<EntityDetail> intermediateAssets = this.getIntermediateAssets(serverName, userId, startAssetId, endAssetId);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(intermediateAssets));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getRelatedAssets(String serverName, String userId, String startAssetId, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            Integer limit = 0;
            Status status = null;
            List instanceType = null;
            Integer offset = null;
            SequenceOrderType orderType = null;
            String orderProperty = null;
            if (searchParameters != null) {
                limit = searchParameters.getLimit();
                status = searchParameters.getStatus();
                offset = searchParameters.getOffset();
                orderType = searchParameters.getOrderType();
                orderProperty = searchParameters.getOrderProperty();
                if (searchParameters.getTypes() != null) {
                    instanceType = searchParameters.getTypes();
                }
            }
            List<EntityDetail> relatedAssets = this.getRelatedAsset(serverName, userId, startAssetId, instanceType, limit, offset, orderType, orderProperty, status);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(relatedAssets));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public List<AssetDescription> getLastUpdatedAssets(String serverName, String userId, SearchParameters searchParameters) throws NotImplementedException {
        AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.METHOD_NOT_IMPLEMENTED;
        String methodName = "getLastUpdatedAssets";
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, userId, serverName});
        throw new NotImplementedException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public List<AssetDescription> getLastCreatedAssets(String serverName, String userId, SearchParameters searchParameters) throws NotImplementedException {
        AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.METHOD_NOT_IMPLEMENTED;
        String methodName = "getLastCreatedAssets";
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, userId, serverName});
        throw new NotImplementedException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public AssetDescriptionResponse searchAssets(String serverName, String userId, String searchCriteria, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<AssetDescription> assetDescriptions = this.searchAssets(serverName, userId, searchCriteria, true);
            response.setAssetDescriptionList(assetDescriptions);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse searchAssetsByPropertyValue(String serverName, String userId, String searchCriteria, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<AssetDescription> assetDescriptions = this.searchAssets(serverName, userId, searchCriteria, false);
            response.setAssetDescriptionList(assetDescriptions);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    private List<AssetDescription> searchAssets(String serverName, String userId, String searchCriteria, boolean containsConnectionDetails) throws PropertyServerException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityNotKnownException, EntityProxyOnlyException, TypeDefNotKnownException {
        this.setMetadataRepositoryDetails(serverName, userId);
        List<AssetDescription> assetDescriptions = this.processAssetsBySearchCriteria(userId, searchCriteria);
        this.setAssetsConnection(userId, assetDescriptions, containsConnectionDetails);
        return assetDescriptions;
    }

    private void setMetadataRepositoryDetails(String serverName, String userId) throws PropertyServerException, RepositoryErrorException, UserNotAuthorizedException {
        this.metadataCollectionForSearch = instanceHandler.getMetadataCollection(serverName);
        this.allTypes = this.metadataCollectionForSearch.getAllTypes(userId);
        this.serverName = serverName;
    }

    private List<AssetDescription> processAssetsBySearchCriteria(String userId, String searchCriteria) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityNotKnownException, EntityProxyOnlyException, TypeDefNotKnownException {
        List<EntityDetail> matchCriteriaEntities = this.findEntitiesBySearchCriteria(this.metadataCollectionForSearch, userId, searchCriteria);
        ArrayList<AssetDescription> assetDescriptions = new ArrayList<AssetDescription>(matchCriteriaEntities.size());
        for (EntityDetail entityDetail : matchCriteriaEntities) {
            AssetDescription assetDescription;
            InstanceType entityType = entityDetail.getType();
            if (entityType.getTypeDefName().equals("GlossaryTerm")) {
                assetDescription = this.processGlossaryTerm(userId, entityDetail);
                assetDescriptions.add(assetDescription);
                continue;
            }
            if (!this.hasSuperTypeAsset(entityType).booleanValue() && !this.hasSuperTypeSchemaAttribute(entityType).booleanValue()) continue;
            assetDescription = this.processAsset(userId, entityDetail);
            assetDescriptions.add(assetDescription);
        }
        return assetDescriptions;
    }

    private void setAssetsConnection(String userId, List<AssetDescription> assetDescriptions, boolean containsDetails) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException, PropertyServerException {
        for (AssetDescription assetDescription : assetDescriptions) {
            List contexts = assetDescription.getContexts();
            if (contexts == null) continue;
            for (Context context : contexts) {
                if (context.getDatabase() == null || context.getDatabase().getGuid() == null) continue;
                Connection connection = containsDetails ? this.getConnectionDetails(this.metadataCollectionForSearch, userId, context.getDatabase().getGuid()) : this.getConnectionId(userId, context.getDatabase().getGuid());
                context.setConnection(connection);
            }
        }
    }

    private EntitySummary getEntitySummary(String serverName, String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        EntitySummary entitySummary = metadataCollection.getEntitySummary(userId, assetId);
        if (entitySummary == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitySummary;
    }

    private EntityDetail getEntityDetails(String serverName, String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        EntityDetail entityDetail = metadataCollection.getEntityDetail(userId, assetId);
        if (entityDetail == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entityDetail;
    }

    private List<Classification> getAssetClassifications(String serverName, String userId, String assetId) throws UserNotAuthorizedException, EntityNotKnownException, InvalidParameterException, RepositoryErrorException, EntityProxyOnlyException, AssetNotFoundException, ClassificationNotFoundException, PropertyServerException {
        EntityDetail asset = this.getEntityDetails(serverName, userId, assetId);
        if (asset.getClassifications() == null || asset.getClassifications().isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new ClassificationNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return asset.getClassifications();
    }

    private String getTypeID(String userId, String typeName, OMRSMetadataCollection metadataCollection) throws AssetNotFoundException, PropertyServerException {
        if (typeName != null) {
            try {
                return metadataCollection.getTypeDefByName(userId, typeName).getGUID();
            }
            catch (InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private List<Relationship> getRelationships(String serverName, String userId, String assetId, Integer fromElement, Integer pageSize, String property, String relationshipTypeID, List<InstanceStatus> instanceStatuses, SequencingOrder sequencingOrder) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        List relationshipsForEntity = metadataCollection.getRelationshipsForEntity(userId, assetId, relationshipTypeID, fromElement.intValue(), instanceStatuses, null, property, sequencingOrder, pageSize.intValue());
        if (relationshipsForEntity == null || relationshipsForEntity.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.RELATIONSHIPS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationshipsForEntity;
    }

    private List<EntityDetail> getEntitiesFromNeighborhood(String serverName, String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, AssetNotFoundException, PropertyServerException {
        InstanceGraph entityNeighborhood = this.getAssetNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
        List entities = entityNeighborhood.getEntities();
        if (entities == null || entities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_ASSET_FROM_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getEntitiesFromNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entities;
    }

    private List<Relationship> getRelationshipsFromAssetNeighborhood(String serverName, String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws InvalidParameterException, PropertyErrorException, AssetNotFoundException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException, TypeErrorException, RepositoryErrorException, PropertyServerException {
        InstanceGraph entityNeighborhood = this.getAssetNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
        List entities = entityNeighborhood.getRelationships();
        if (entities == null || entities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_RELATIONSHIPS_FROM_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRelationshipsFromAssetNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entities;
    }

    private InstanceGraph getAssetNeighborhood(String serverName, String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, AssetNotFoundException, PropertyServerException {
        List<InstanceStatus> limitResultsByStatus;
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        InstanceGraph entityNeighborhood = metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, limitResultsByStatus = this.converter.getInstanceStatuses(relationshipStatus), null, null, level.intValue());
        if (entityNeighborhood == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getAssetNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entityNeighborhood;
    }

    private List<EntityDetail> findEntitiesBySearchCriteria(OMRSMetadataCollection metadataCollection, String userId, String searchCriteria) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        entities.addAll(this.findEntitiesByType(metadataCollection, userId, searchCriteria, null));
        return entities;
    }

    private List<EntityDetail> findEntitiesByType(OMRSMetadataCollection metadataCollection, String userId, String searchCriteria, String entityType) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        String typeDefGUID = this.getTypeDefGUID(entityType);
        List entitiesByPropertyValue = metadataCollection.findEntitiesByPropertyValue(userId, typeDefGUID, searchCriteria, 0, null, null, null, null, SequencingOrder.ANY, 0);
        if (entitiesByPropertyValue != null) {
            return entitiesByPropertyValue;
        }
        return new ArrayList<EntityDetail>();
    }

    private String getTypeDefGUID(String userId, String typeName, String serverName) throws RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, UserNotAuthorizedException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        return this.getTypeName(userId, typeName, metadataCollection);
    }

    private String getTypeName(String userId, String typeName, OMRSMetadataCollection metadataCollection) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        TypeDef typeDefByName = metadataCollection.getTypeDefByName(userId, typeName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    private String getTypeDefGUID(String entityType) {
        if (this.allTypes.getTypeDefs() != null) {
            return this.allTypes.getTypeDefs().stream().filter(s -> s.getName().equals(entityType)).findAny().map(TypeDefLink::getGUID).orElse(null);
        }
        return null;
    }

    private List<Relationship> getRelationshipByType(OMRSMetadataCollection metadataCollection, String userId, String entityGUID, String relationshipType) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, TypeDefNotKnownException {
        String typeGuid = this.getTypeName(userId, relationshipType, metadataCollection);
        ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>(1);
        instanceStatuses.add(InstanceStatus.ACTIVE);
        List relationshipsForEntity = metadataCollection.getRelationshipsForEntity(userId, entityGUID, typeGuid, 0, instanceStatuses, null, null, SequencingOrder.ANY, 0);
        if (relationshipsForEntity != null) {
            return relationshipsForEntity;
        }
        return new ArrayList<Relationship>();
    }

    private AssetDescription processGlossaryTerm(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
        List<Relationship> relationshipsToColumn = this.getRelationshipByType(this.metadataCollectionForSearch, userId, entityDetail.getGUID(), "SemanticAssignment");
        List<Context> glossaryTermConnections = this.getGlossaryTermConnections(userId, entityDetail, relationshipsToColumn);
        if (!glossaryTermConnections.isEmpty()) {
            assetDescription.setContexts(glossaryTermConnections);
        }
        return assetDescription;
    }

    private AssetDescription processAsset(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
        Context context = this.getConnectionToAsset(this.metadataCollectionForSearch, userId, entityDetail);
        if (context != null) {
            ArrayList<Context> contexts = new ArrayList<Context>();
            contexts.add(context);
            assetDescription.setContexts(contexts);
        }
        return assetDescription;
    }

    private List<Context> getGlossaryTermConnections(String userId, EntityDetail entityDetail, List<Relationship> relationshipsToColumn) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, FunctionNotSupportedException, PropertyErrorException, TypeErrorException, PagingErrorException, TypeDefNotKnownException {
        ArrayList<Context> contexts = new ArrayList<Context>();
        if (!relationshipsToColumn.isEmpty()) {
            for (Relationship relationship : relationshipsToColumn) {
                Context context = this.processColumn(userId, entityDetail, relationship);
                if (context == null) continue;
                contexts.add(context);
            }
        }
        return contexts;
    }

    private Context processColumn(String userId, EntityDetail entityDetail, Relationship relationship) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, FunctionNotSupportedException, PropertyErrorException, TypeErrorException, PagingErrorException, TypeDefNotKnownException {
        EntityDetail relationalColumn = this.getThePairEntity(this.metadataCollectionForSearch, userId, entityDetail.getGUID(), relationship);
        if (relationalColumn != null) {
            return this.getConnectionToAsset(this.metadataCollectionForSearch, userId, relationalColumn);
        }
        return null;
    }

    private Context getConnectionToAsset(OMRSMetadataCollection metadataCollection, String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        String typeDefName;
        switch (typeDefName = entityDetail.getType().getTypeDefName()) {
            case "RelationalColumn": {
                return this.processColumn(metadataCollection, userId, entityDetail);
            }
            case "RelationalTable": {
                return this.processTable(userId, entityDetail);
            }
            case "DataStore": {
                return this.processDataStore(entityDetail);
            }
            case "DeployedDatabaseSchema": {
                return this.processDataSet(userId, entityDetail);
            }
        }
        return null;
    }

    private Context processDataSet(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        Context context = new Context();
        String dataSetName = this.converter.getStringPropertyValue(entityDetail.getProperties(), "displayName");
        this.getDataSet(userId, entityDetail, context, dataSetName);
        return context;
    }

    private Context processDataStore(EntityDetail dataStore) {
        Context context = new Context();
        Database database = this.getDatabase(dataStore);
        if (database != null) {
            context.setDatabase(database);
        }
        return context;
    }

    private Context processTable(String userId, EntityDetail relationalTable) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        Context context = new Context();
        this.getDatabaseSchema(userId, relationalTable, context);
        return context;
    }

    private Context processColumn(OMRSMetadataCollection metadataCollection, String userId, EntityDetail relationalColumn) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        Context context = new Context();
        Column column = this.getColumn(metadataCollection, userId, relationalColumn);
        context.setColumn(column);
        this.getTable(userId, relationalColumn, context);
        return context;
    }

    private void getDataSet(String userId, EntityDetail entityDetail, Context context, String dataSetName) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        Database database;
        EntityDetail dataSet = this.getTheEndOfRelationship(userId, entityDetail.getGUID(), "DataContentForDataSet");
        if (dataSet != null && (database = this.getDatabase(dataSet)) != null) {
            database.setDataSetName(dataSetName);
            context.setDatabase(database);
        }
    }

    private void getTable(String userId, EntityDetail relationalColumn, Context context) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        EntityDetail relationalTable;
        EntityDetail relationalTableType = this.getTheEndOfRelationship(userId, relationalColumn.getGUID(), "AttributeForSchema");
        if (relationalTableType != null && (relationalTable = this.getTheEndOfRelationship(userId, relationalTableType.getGUID(), "SchemaAttributeType")) != null) {
            Table table = this.getTable(relationalTableType, relationalTable);
            context.setTable(table);
            this.getDatabaseSchema(userId, relationalTable, context);
        }
    }

    private void getDatabaseSchema(String userId, EntityDetail relationalTable, Context context) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        EntityDetail relationalDbSchemaType = this.getTheEndOfRelationship(userId, relationalTable.getGUID(), "AttributeForSchema");
        if (relationalDbSchemaType != null) {
            Schema schema = this.getSchema(relationalDbSchemaType);
            context.setSchema(schema);
            EntityDetail deployedDbSchema = this.getTheEndOfRelationship(userId, relationalDbSchemaType.getGUID(), "AssetSchemaType");
            if (deployedDbSchema != null && deployedDbSchema.getProperties() != null) {
                String dataSetName = this.converter.getStringPropertyValue(deployedDbSchema.getProperties(), "displayName");
                this.getDataSet(userId, context, deployedDbSchema, dataSetName);
            }
        }
    }

    private void getDataSet(String userId, Context context, EntityDetail deployedDbSchema, String dataSetName) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        EntityDetail dataSet = this.getTheEndOfRelationship(userId, deployedDbSchema.getGUID(), "DataContentForDataSet");
        if (dataSet != null) {
            Database database = this.getDatabase(dataSet);
            if (database != null) {
                database.setDataSetName(dataSetName);
            }
            context.setDatabase(database);
        }
    }

    private Connection getConnectionDetails(OMRSMetadataCollection metadataCollection, String userId, String dataSetGuid) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException, PropertyServerException {
        EntityDetail connectionEntity = this.getTheEndOfRelationship(userId, dataSetGuid, "ConnectionToAsset");
        if (connectionEntity != null) {
            Connection connection = this.getConnection(connectionEntity);
            Connector connectorType = this.getConnectorType(metadataCollection, userId, connectionEntity);
            Endpoint endpoint = this.getEndpoint(metadataCollection, userId, connectionEntity);
            if (connectorType != null) {
                connection.setConnector(connectorType);
            }
            if (endpoint != null) {
                connection.setEndpoint(endpoint);
            }
            return connection;
        }
        return null;
    }

    private Connection getConnectionId(String userId, String dataSetGuid) throws InvalidParameterException, TypeDefNotKnownException, PropertyErrorException, EntityProxyOnlyException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, UserNotAuthorizedException, TypeErrorException, RepositoryErrorException {
        EntityDetail connectionEntity = this.getTheEndOfRelationship(userId, dataSetGuid, "ConnectionToAsset");
        if (connectionEntity != null) {
            Connection connection = new Connection();
            connection.setGuid(connectionEntity.getGUID());
        }
        return null;
    }

    private Column getColumn(OMRSMetadataCollection metadataCollection, String userId, EntityDetail relationalColumn) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        Column column = new Column();
        column.setName(this.converter.getStringPropertyValue(relationalColumn.getProperties(), "name"));
        column.setType(this.getColumnType(metadataCollection, userId, relationalColumn));
        column.setGuid(relationalColumn.getGUID());
        return column;
    }

    private Connection getConnection(EntityDetail entityDetail) throws PropertyServerException {
        Connection connection = new Connection();
        InstanceProperties properties = entityDetail.getProperties();
        if (properties != null) {
            connection.setDisplayName(this.converter.getStringPropertyValue(properties, "name"));
            connection.setDescription(this.converter.getStringPropertyValue(properties, "description"));
            connection.setGuid(entityDetail.getGUID());
            OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(this.serverName);
            connection.setSecuredProperties(this.converter.getAdditionalPropertiesFromEntity(properties, "securedProperties", repositoryHelper));
            connection.setSecuredProperties(this.converter.getAdditionalPropertiesFromEntity(properties, "additionalProperties", repositoryHelper));
        }
        return connection;
    }

    private Endpoint getEndpoint(OMRSMetadataCollection metadataCollection, String userId, EntityDetail connectionEntity) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        EntityDetail endpointEntity;
        List<Relationship> relationshipsToEndpoint = this.getRelationshipByType(metadataCollection, userId, connectionEntity.getGUID(), "ConnectionEndpoint");
        if (!relationshipsToEndpoint.isEmpty() && (endpointEntity = this.getThePairEntity(metadataCollection, userId, connectionEntity.getGUID(), relationshipsToEndpoint.get(0))) != null) {
            return this.getEndpoint(endpointEntity);
        }
        return null;
    }

    private Endpoint getEndpoint(EntityDetail endpointEntity) {
        InstanceProperties properties = endpointEntity.getProperties();
        Endpoint endpoint = new Endpoint();
        endpoint.setGuid(endpointEntity.getGUID());
        endpoint.setName(this.converter.getStringPropertyValue(properties, "name"));
        endpoint.setDescription(this.converter.getStringPropertyValue(properties, "description"));
        endpoint.setNetworkAddress(this.converter.getStringPropertyValue(properties, "networkAddress"));
        endpoint.setProtocol(this.converter.getStringPropertyValue(properties, "protocol"));
        endpoint.setEncryptionMethod(this.converter.getStringPropertyValue(properties, "encryptionMethod"));
        return endpoint;
    }

    private Connector getConnectorType(OMRSMetadataCollection metadataCollection, String userId, EntityDetail connectionEntity) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException, PropertyServerException {
        EntityDetail connectorType;
        List<Relationship> relationshipsToConnectorType = this.getRelationshipByType(metadataCollection, userId, connectionEntity.getGUID(), "ConnectionConnectorType");
        if (!relationshipsToConnectorType.isEmpty() && (connectorType = this.getThePairEntity(metadataCollection, userId, connectionEntity.getGUID(), relationshipsToConnectorType.get(0))) != null) {
            return this.getConnector(connectorType);
        }
        return null;
    }

    private Connector getConnector(EntityDetail entityDetail) throws PropertyServerException {
        InstanceProperties properties = entityDetail.getProperties();
        if (properties == null) {
            return null;
        }
        Connector connector = new Connector();
        connector.setName(this.converter.getStringPropertyValue(properties, "name"));
        connector.setDescription(this.converter.getStringPropertyValue(properties, "description"));
        connector.setProvider(this.converter.getStringPropertyValue(properties, "connectorProviderClassName"));
        OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(this.serverName);
        connector.setAdditionalProperties(this.converter.getAdditionalPropertiesFromEntity(properties, "additionalProperties", repositoryHelper));
        return connector;
    }

    private Table getTable(EntityDetail relationalTableType, EntityDetail relationalTable) {
        InstanceProperties properties;
        Table table = new Table();
        if (relationalTable != null) {
            table.setGuid(relationalTable.getGUID());
            if (relationalTable.getProperties() != null) {
                table.setName(this.converter.getStringPropertyValue(relationalTable.getProperties(), "name"));
            }
        }
        if ((properties = relationalTableType.getProperties()) == null) {
            return null;
        }
        table.setGuid(relationalTableType.getGUID());
        table.setTypeName(this.converter.getStringPropertyValue(properties, "displayName"));
        table.setOwner(this.converter.getStringPropertyValue(properties, "owner"));
        table.setTypeUsage(this.converter.getStringPropertyValue(properties, "usage"));
        table.setTypeEncodingStandard(this.converter.getStringPropertyValue(properties, "encodingStandard"));
        table.setTypeVersion(this.converter.getStringPropertyValue(properties, "versionNumber"));
        return table;
    }

    private Schema getSchema(EntityDetail entityDb) {
        InstanceProperties properties = entityDb.getProperties();
        Schema schema = new Schema();
        schema.setGuid(entityDb.getGUID());
        schema.setAuthor(this.converter.getStringPropertyValue(properties, "author"));
        schema.setName(this.converter.getStringPropertyValue(properties, "displayName"));
        schema.setEncodingStandard(this.converter.getStringPropertyValue(properties, "encodingStandard"));
        schema.setVersionNr(this.converter.getStringPropertyValue(properties, "versionNumber"));
        return schema;
    }

    private Database getDatabase(EntityDetail databaseEntity) {
        InstanceProperties properties = databaseEntity.getProperties();
        if (properties == null) {
            return null;
        }
        Database database = new Database();
        database.setGuid(databaseEntity.getGUID());
        database.setName(this.converter.getStringPropertyValue(properties, "name"));
        database.setDescription(this.converter.getStringPropertyValue(properties, "description"));
        database.setOwner(this.converter.getStringPropertyValue(properties, "owner"));
        database.setType(this.converter.getStringPropertyValue(properties, "dataType"));
        return database;
    }

    private EntityDetail getThePairEntity(OMRSMetadataCollection metadataCollection, String userId, String entityDetailGUID, Relationship relationship) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException {
        if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
            return metadataCollection.getEntityDetail(userId, relationship.getEntityTwoProxy().getGUID());
        }
        return metadataCollection.getEntityDetail(userId, relationship.getEntityOneProxy().getGUID());
    }

    private List<EntityDetail> findEntitiesByClassifications(String serverName, String userId, String assetTypeId, String classificationName, Integer limit, Integer offset, String orderProperty, SequenceOrderType orderType, Status status) throws ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List entitiesByClassification = metadataCollection.findEntitiesByClassification(userId, assetTypeId, classificationName, null, null, offset.intValue(), instanceStatuses, null, orderProperty, sequencingOrder, limit.intValue());
        if (entitiesByClassification == null || entitiesByClassification.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_WITH_CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationName, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitiesByClassification;
    }

    private List<EntityDetail> findEntitiesByProperty(String serverName, String userId, String assetTypeId, String matchProperty, String propertyValue, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        InstanceProperties matchProperties = this.getInstanceProperties(matchProperty, propertyValue);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List entitiesByProperty = metadataCollection.findEntitiesByProperty(userId, assetTypeId, matchProperties, MatchCriteria.ANY, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue());
        if (entitiesByProperty == null || entitiesByProperty.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_WITH_CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{matchProperty, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitiesByProperty;
    }

    private InstanceProperties getInstanceProperties(String matchProperty, String propertyValue) {
        if (matchProperty != null) {
            return this.converter.getMatchProperties(matchProperty, propertyValue);
        }
        return this.converter.getMatchProperties("qualifiedName", propertyValue);
    }

    private List<Relationship> getLinkingRelationshipsBetweenAssets(String serverName, String userId, String startAssetId, String endAssetId) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, AssetNotFoundException, PropertyServerException {
        List<InstanceStatus> limitByStatus;
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus = this.converter.getInstanceStatuses(null), null);
        if (linkingEntities == null || linkingEntities.getRelationships() != null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.LINKING_RELATIONSHIPS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, endAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getLinkingRelationshipsBetweenAssets", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return linkingEntities.getRelationships();
    }

    private List<EntityDetail> getIntermediateAssets(String serverName, String userId, String startAssetId, String endAssetId) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, AssetNotFoundException, PropertyServerException {
        List<InstanceStatus> limitByStatus;
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus = this.converter.getInstanceStatuses(null), null);
        if (linkingEntities == null || linkingEntities.getEntities() == null || linkingEntities.getEntities().isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.LINKING_ASSETS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, endAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getIntermediateAssets", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return linkingEntities.getEntities();
    }

    private List<EntityDetail> getRelatedAsset(String serverName, String userId, String startAssetId, List<String> instanceTypes, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        List relatedEntities = metadataCollection.getRelatedEntities(userId, startAssetId, instanceTypes, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue());
        if (relatedEntities == null || relatedEntities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_RELATED_ASSETS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relatedEntities;
    }

    private List<Relationship> getRelationshipsByAssetId(String userId, String entityId, String relationshipType) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, TypeDefNotKnownException {
        return this.getRelationshipByType(this.metadataCollectionForSearch, userId, entityId, relationshipType);
    }

    private EntityDetail getTheEndOfRelationship(String userId, String assetId, String relationshipType) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        List<Relationship> relationshipsToColumnTypes = this.getRelationshipsByAssetId(userId, assetId, relationshipType);
        if (relationshipsToColumnTypes.isEmpty() || relationshipsToColumnTypes.size() != 1) {
            return null;
        }
        return this.getThePairEntity(this.metadataCollectionForSearch, userId, assetId, relationshipsToColumnTypes.get(0));
    }

    private List<EntityDetail> getTheEndsRelationship(String userId, String assetId, String relationshipType) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        List<Relationship> relationships = this.getRelationshipsByAssetId(userId, assetId, relationshipType);
        if (relationships.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>(relationships.size());
        for (Relationship relationship : relationships) {
            entityDetails.add(this.getThePairEntity(this.metadataCollectionForSearch, userId, assetId, relationship));
        }
        return entityDetails;
    }

    private DataType getColumnType(OMRSMetadataCollection metadataCollection, String userId, EntityDetail relationalColumn) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        EntityDetail columnType;
        List<Relationship> relationshipsToType = this.getRelationshipByType(metadataCollection, userId, relationalColumn.getGUID(), "SchemaAttributeType");
        if (!relationshipsToType.isEmpty() && (columnType = this.getThePairEntity(metadataCollection, userId, relationalColumn.getGUID(), relationshipsToType.get(0))) != null && columnType.getProperties() != null) {
            return this.converter.getColumnTypeValue(columnType);
        }
        return null;
    }

    private Boolean hasSuperTypeAsset(InstanceType type) {
        List typeDefSuperTypes = type.getTypeDefSuperTypes();
        long asset = typeDefSuperTypes.stream().filter(s -> s.getName().equals("Asset")).count();
        if (asset == 1L) {
            return Boolean.TRUE;
        }
        String parentName = ((TypeDefLink)typeDefSuperTypes.get(0)).getName();
        return this.hasSuperTypeAsset(parentName);
    }

    private Boolean hasSuperTypeAsset(String type) {
        return this.allTypes.getTypeDefs().stream().filter(s -> s.getName().equals(type)).filter(t -> t.getSuperType().getName().equals("Asset")).count() == 1L ? Boolean.TRUE : Boolean.FALSE;
    }

    private Boolean hasSuperTypeSchemaAttribute(InstanceType type) {
        List typeDefSuperTypes = type.getTypeDefSuperTypes();
        long schemaAttribute = typeDefSuperTypes.stream().filter(s -> s.getName().equals("SchemaElement") || s.getName().equals("SchemaAttribute")).count();
        if (schemaAttribute == 1L) {
            return Boolean.TRUE;
        }
        String parentName = ((TypeDefLink)typeDefSuperTypes.get(0)).getName();
        return this.hasSuperTypeSchemaElement(parentName);
    }

    private Boolean hasSuperTypeSchemaElement(String type) {
        return this.allTypes.getTypeDefs().stream().filter(s -> s.getName().equals(type)).filter(t -> t.getSuperType().getName().equals("SchemaElement") || t.getSuperType().getName().equals("SchemaAttribute")).count() == 1L ? Boolean.TRUE : Boolean.FALSE;
    }

    public AssetResponse searchAssetsGeneric(String serverName, String userId, String searchCriteria, SearchParameters searchParameters) {
        AssetResponse response = new AssetResponse();
        try {
            this.setMetadataRepositoryDetails(serverName, userId);
            List<EntityDetail> entitiesByType = this.searchEntityByCriteria(this.metadataCollectionForSearch, userId, searchCriteria, "GlossaryTerm", searchParameters);
            ArrayList<Term> terms = new ArrayList<Term>(entitiesByType.size());
            HashMap<String, List<Connection>> knownAssetConnection = new HashMap<String, List<Connection>>();
            for (EntityDetail glossaryTerm : entitiesByType) {
                Term term = this.buildTerm(glossaryTerm);
                List<EntityDetail> schemas = this.getTheEndsRelationship(userId, glossaryTerm.getGUID(), "SemanticAssignment");
                ArrayList<AssetElement> assets = new ArrayList<AssetElement>(schemas.size());
                for (EntityDetail schema : schemas) {
                    AssetElement assetElement = new AssetElement();
                    Element firstElement = this.buildElement(schema);
                    assetElement.getSubElements().add(firstElement);
                    this.findAsset(userId, Collections.singletonList(schema), assetElement, knownAssetConnection);
                    assets.add(assetElement);
                }
                term.setElements(assets);
                terms.add(term);
            }
            response.setTerms(terms);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)((Object)e));
        }
        return response;
    }

    private void findAsset(String userId, List<EntityDetail> entitiesByType, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        for (EntityDetail entityDetail : entitiesByType) {
            List<EntityDetail> theEndOfRelationship = this.getTheEndsRelationship(userId, entityDetail.getGUID(), "AttributeForSchema");
            for (EntityDetail entity : theEndOfRelationship) {
                Optional<TypeDef> isComplexSchemaType = this.isComplexSchemaType(entity.getType().getTypeDefName());
                if (isComplexSchemaType.isPresent()) {
                    EntityDetail dataSet = this.getTheEndOfRelationship(userId, entity.getGUID(), "AssetSchemaType");
                    assetElement.getSubElements().add(this.buildElement(dataSet));
                    this.setAssetDetails(userId, assetElement, knownAssetConnection, dataSet);
                    return;
                }
                List<EntityDetail> schemaAttributeTypeEntities = this.getTheEndsRelationship(userId, entity.getGUID(), "SchemaAttributeType");
                this.getSubElements(assetElement, schemaAttributeTypeEntities);
                this.findAsset(userId, schemaAttributeTypeEntities, assetElement, knownAssetConnection);
            }
        }
    }

    private void setAssetDetails(String userId, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection, EntityDetail dataSet) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        EntityDetail asset = this.getTheEndOfRelationship(userId, dataSet.getGUID(), "DataContentForDataSet");
        if (asset != null) {
            this.setAssetElementAttributes(assetElement, asset);
            this.setConnections(userId, assetElement, knownAssetConnection, asset);
        }
    }

    private void getSubElements(AssetElement assetElement, List<EntityDetail> schemaAttributeTypeEntities) {
        List<Element> elements = this.getElements(schemaAttributeTypeEntities);
        assetElement.getSubElements().addAll(elements);
    }

    private void setConnections(String userId, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection, EntityDetail asset) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        if (knownAssetConnection.containsKey(asset.getGUID())) {
            assetElement.setConnectionIds(knownAssetConnection.get(asset.getGUID()));
        } else {
            List<Connection> connections = this.getConnections(userId, asset.getGUID());
            knownAssetConnection.put(asset.getGUID(), connections);
            assetElement.setConnectionIds(connections);
        }
    }

    private void setAssetElementAttributes(AssetElement assetElement, EntityDetail asset) {
        assetElement.setGuid(asset.getGUID());
        assetElement.setType(asset.getType().getTypeDefName());
        assetElement.setQualifiedName(this.converter.getStringPropertyValue(asset.getProperties(), "qualifiedName"));
        assetElement.setProperties(this.converter.getMapProperties(asset.getProperties()));
    }

    private List<Element> getElements(List<EntityDetail> schemaAttributeTypeEntities) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (EntityDetail schemaAttributeType : schemaAttributeTypeEntities) {
            Element element = this.buildElement(schemaAttributeType);
            elements.add(element);
        }
        return elements;
    }

    private Element buildElement(EntityDetail entityDetail) {
        Term element = this.buildTerm(entityDetail);
        return element;
    }

    private Term buildTerm(EntityDetail glossaryTerm) {
        Term term = new Term();
        term.setGuid(glossaryTerm.getGUID());
        term.setType(glossaryTerm.getType().getTypeDefName());
        term.setQualifiedName(this.converter.getStringPropertyValue(glossaryTerm.getProperties(), "qualifiedName"));
        term.setProperties(this.converter.getMapProperties(glossaryTerm.getProperties()));
        return term;
    }

    private Optional<TypeDef> isComplexSchemaType(String typeDefName) {
        return this.allTypes.getTypeDefs().stream().filter(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType")).findAny();
    }

    private List<Connection> getConnections(String userId, String dataSetGuid) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        List<EntityDetail> connections = this.getTheEndsRelationship(userId, dataSetGuid, "ConnectionToAsset");
        if (!connections.isEmpty()) {
            return connections.stream().map(t -> new Connection(t.getGUID(), this.converter.getStringPropertyValue(t.getProperties(), "qualifiedName"))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<EntityDetail> searchEntityByCriteria(OMRSMetadataCollection metadataCollection, String userId, String searchCriteria, String entityType, SearchParameters searchParameters) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        String typeDefGUID = this.getTypeDefGUID(entityType);
        List entitiesByPropertyValue = metadataCollection.findEntitiesByPropertyValue(userId, typeDefGUID, searchCriteria, searchParameters.getOffset() != null ? searchParameters.getOffset() : 0, searchParameters.getStatus() != null ? this.converter.getInstanceStatuses(searchParameters.getStatus()) : this.converter.getInstanceStatuses(Status.ACTIVE), null, null, searchParameters.getOrderProperty(), searchParameters.getOrderType() != null ? this.converter.getSequencingOrder(searchParameters.getOrderType()) : null, searchParameters.getLimit() != null ? searchParameters.getLimit() : 0);
        if (entitiesByPropertyValue != null) {
            return entitiesByPropertyValue;
        }
        return Collections.emptyList();
    }
}

