/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.service;

import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.NewInstanceException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogServicesInstanceMap;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetCatalogServicesInstance {
    private OMRSRepositoryConnector repositoryConnector;
    private OMRSMetadataCollection metadataCollection;
    private String serverName;

    public AssetCatalogServicesInstance(OMRSRepositoryConnector repositoryConnector) throws NewInstanceException {
        String methodName = "new ServiceInstance";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                AssetCatalogServicesInstanceMap.setNewInstanceForJVM(this.serverName, this);
            }
            catch (Exception error) {
                AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.OMRS_NOT_INITIALIZED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
                throw new NewInstanceException(errorCode.getHttpErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHttpErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getServerName"});
        throw new NewInstanceException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getServerName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSMetadataCollection getMetadataCollection() throws PropertyServerException {
        String methodName = "getMetadataCollection";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.metadataCollection;
        }
        AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSRepositoryHelper getRepositoryHelper() {
        return this.repositoryConnector.getRepositoryHelper();
    }

    public void shutdown() {
        AssetCatalogServicesInstanceMap.removeInstanceForJVM(this.serverName);
    }
}

