/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Asset;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.DataType;
import org.odpi.openmetadata.accessservices.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Status;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class Converter {
    private HashMap<String, DataType> dataTypes = this.getDataTypeMap();

    public List<AssetDescription> getAssetsDetails(List<EntityDetail> entityDetails) {
        return entityDetails.stream().map(this::getAssetDescription).collect(Collectors.toCollection(() -> new ArrayList(entityDetails.size())));
    }

    public AssetDescription getAssetDescription(EntityDetail entityDetail) {
        AssetDescription assetDescription = new AssetDescription();
        assetDescription.setGuid(entityDetail.getGUID());
        assetDescription.setMetadataCollectionId(entityDetail.getMetadataCollectionId());
        assetDescription.setDisplayName((String)this.getPropertyValue(entityDetail.getProperties(), "name"));
        assetDescription.setCreatedBy(entityDetail.getCreatedBy());
        assetDescription.setCreateTime(entityDetail.getCreateTime());
        assetDescription.setUpdatedBy(entityDetail.getUpdatedBy());
        assetDescription.setUpdateTime(entityDetail.getUpdateTime());
        assetDescription.setVersion(Long.valueOf(entityDetail.getVersion()));
        assetDescription.setTypeDefName(entityDetail.getType().getTypeDefName());
        assetDescription.setTypeDefDescription(entityDetail.getType().getTypeDefDescription());
        assetDescription.setUrl(entityDetail.getInstanceURL());
        assetDescription.setStatus(this.getStatus(entityDetail.getStatus().getName()));
        assetDescription.setProperties(this.getProperties(entityDetail.getProperties()));
        if (entityDetail.getClassifications() != null) {
            assetDescription.setClassifications(this.toClassifications(entityDetail.getClassifications()));
        }
        return assetDescription;
    }

    public AssetDescription getAssetDescription(EntitySummary entitySummary) {
        AssetDescription assetDescription = new AssetDescription();
        assetDescription.setGuid(entitySummary.getGUID());
        assetDescription.setMetadataCollectionId(entitySummary.getMetadataCollectionId());
        assetDescription.setCreatedBy(entitySummary.getCreatedBy());
        assetDescription.setCreateTime(entitySummary.getCreateTime());
        assetDescription.setUpdatedBy(entitySummary.getUpdatedBy());
        assetDescription.setUpdateTime(entitySummary.getUpdateTime());
        assetDescription.setVersion(Long.valueOf(entitySummary.getVersion()));
        assetDescription.setTypeDefName(entitySummary.getType().getTypeDefName());
        assetDescription.setTypeDefDescription(entitySummary.getType().getTypeDefDescription());
        assetDescription.setUrl(entitySummary.getInstanceURL());
        assetDescription.setStatus(this.getStatus(entitySummary.getStatus().getName()));
        if (entitySummary.getClassifications() != null && !entitySummary.getClassifications().isEmpty()) {
            assetDescription.setClassifications(this.toClassifications(entitySummary.getClassifications()));
        }
        return assetDescription;
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship> toRelationships(List<Relationship> relationshipsEntity) {
        if (relationshipsEntity == null) {
            return new ArrayList<org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship>();
        }
        return relationshipsEntity.stream().map(this::toRelationship).collect(Collectors.toCollection(() -> new ArrayList(relationshipsEntity.size())));
    }

    public org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship toRelationship(Relationship rel) {
        org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship relationship = new org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship();
        relationship.setGuid(rel.getGUID());
        relationship.setCreatedBy(rel.getCreatedBy());
        relationship.setCreateTime(rel.getCreateTime());
        relationship.setUpdatedBy(rel.getUpdatedBy());
        relationship.setUpdateTime(rel.getUpdateTime());
        relationship.setVersion(Long.valueOf(rel.getVersion()));
        relationship.setStatus(this.getStatus(rel.getStatus().getName()));
        relationship.setTypeDefName(rel.getType().getTypeDefName());
        relationship.setTypeDefDescription(rel.getType().getTypeDefDescription());
        relationship.setFromEntity(this.getAsset(rel.getEntityOneProxy()));
        relationship.setToEntity(this.getAsset(rel.getEntityTwoProxy()));
        return relationship;
    }

    public InstanceProperties getMatchProperties(String matchProperty, String propertyValue) {
        InstanceProperties instanceProperties = new InstanceProperties();
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)propertyValue);
        instanceProperties.setProperty(matchProperty, (InstancePropertyValue)primitivePropertyValue);
        return instanceProperties;
    }

    public List<InstanceStatus> getInstanceStatuses(Status status) {
        if (status == null) {
            return this.getActiveInstanceStatusList();
        }
        return this.getInstanceStatusList(status);
    }

    public SequencingOrder getSequencingOrder(SequenceOrderType orderType) {
        if (orderType == null) {
            return SequencingOrder.ANY;
        }
        return this.getOrderType(orderType);
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification> toClassifications(List<Classification> classificationsFromEntity) {
        if (classificationsFromEntity == null || classificationsFromEntity.isEmpty()) {
            return new ArrayList<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification>();
        }
        ArrayList<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification> classifications = new ArrayList<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification>(classificationsFromEntity.size());
        for (Classification classificationEntity : classificationsFromEntity) {
            Map<String, Object> properties;
            org.odpi.openmetadata.accessservices.assetcatalog.model.Classification classification = new org.odpi.openmetadata.accessservices.assetcatalog.model.Classification();
            classification.setName(classificationEntity.getName());
            if (classificationEntity.getClassificationOrigin() != null && classificationEntity.getClassificationOrigin().getDescription() != null) {
                classification.setOrigin(classificationEntity.getClassificationOrigin().getDescription());
            }
            classification.setOriginGUID(classificationEntity.getClassificationOriginGUID());
            classification.setCreatedBy(classificationEntity.getCreatedBy());
            classification.setCreateTime(classificationEntity.getCreateTime());
            classification.setUpdatedBy(classificationEntity.getUpdatedBy());
            classification.setUpdateTime(classificationEntity.getUpdateTime());
            classification.setVersion(Long.valueOf(classificationEntity.getVersion()));
            classification.setStatus(this.getStatus(classificationEntity.getStatus().getName()));
            classification.setTypeDefName(classificationEntity.getType().getTypeDefName());
            classification.setTypeDefDescription(classificationEntity.getType().getTypeDefDescription());
            if (classificationEntity.getProperties() != null && (properties = this.getProperties(classificationEntity.getProperties())) != null && !properties.isEmpty()) {
                classification.setProperties(properties);
            }
            classifications.add(classification);
        }
        return classifications;
    }

    private Status getStatus(String statusName) {
        switch (statusName) {
            case "<Unknown>": {
                return Status.UNKNOWN;
            }
            case "Proposed": {
                return Status.PROPOSED;
            }
            case "Draft": {
                return Status.DRAFT;
            }
            case "Prepared": {
                return Status.PREPARED;
            }
            case "Active": {
                return Status.ACTIVE;
            }
            case "Deleted": {
                return Status.DELETED;
            }
        }
        return Status.UNKNOWN;
    }

    private Asset getAsset(EntityProxy entityProxy) {
        Asset asset = new Asset();
        asset.setGuid(entityProxy.getGUID());
        if (entityProxy.getUniqueProperties() != null) {
            asset.setName((String)this.getPropertyValue(entityProxy.getUniqueProperties(), "name"));
        }
        asset.setMetadataCollectionId(entityProxy.getMetadataCollectionId());
        asset.setCreatedBy(entityProxy.getCreatedBy());
        asset.setCreateTime(entityProxy.getCreateTime());
        asset.setUpdatedBy(entityProxy.getUpdatedBy());
        asset.setUpdateTime(entityProxy.getUpdateTime());
        asset.setStatus(this.getStatus(entityProxy.getStatus().getName()));
        asset.setVersion(Long.valueOf(entityProxy.getVersion()));
        asset.setTypeDefName(entityProxy.getType().getTypeDefName());
        asset.setTypeDefDescription(entityProxy.getType().getTypeDefDescription());
        return asset;
    }

    private List<InstanceStatus> getActiveInstanceStatusList() {
        ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>(1);
        instanceStatuses.add(InstanceStatus.ACTIVE);
        return instanceStatuses;
    }

    private List<InstanceStatus> getInstanceStatusList(Status statusName) {
        ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>(1);
        InstanceStatus status = this.getInstanceStatus(statusName);
        instanceStatuses.add(status);
        return instanceStatuses;
    }

    private InstanceStatus getInstanceStatus(Status statusName) {
        switch (statusName) {
            case ACTIVE: {
                return InstanceStatus.ACTIVE;
            }
            case PROPOSED: {
                return InstanceStatus.PROPOSED;
            }
            case PREPARED: {
                return InstanceStatus.PREPARED;
            }
            case DELETED: {
                return InstanceStatus.DELETED;
            }
            case DRAFT: {
                return InstanceStatus.DRAFT;
            }
        }
        return InstanceStatus.UNKNOWN;
    }

    private Map<String, Object> getProperties(InstanceProperties instanceProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Iterator propertyNames = instanceProperties.getPropertyNames();
        while (propertyNames.hasNext()) {
            String propertyName = (String)propertyNames.next();
            Object propertyValue = this.getPropertyValue(instanceProperties, propertyName);
            properties.put(propertyName, propertyValue);
        }
        return properties;
    }

    private Object getPropertyValue(InstanceProperties instanceProperties, String propertyName) {
        EnumPropertyValue value;
        if (instanceProperties.getPropertyValue(propertyName) instanceof PrimitivePropertyValue) {
            PrimitivePropertyValue value2 = (PrimitivePropertyValue)instanceProperties.getPropertyValue(propertyName);
            if (value2 != null) {
                return value2.getPrimitiveValue();
            }
        } else if (instanceProperties.getPropertyValue(propertyName) instanceof EnumPropertyValue && (value = (EnumPropertyValue)instanceProperties.getPropertyValue(propertyName)) != null) {
            return value.getDescription();
        }
        return null;
    }

    public String getStringPropertyValue(InstanceProperties instanceProperties, String propertyName) {
        PrimitivePropertyValue value = (PrimitivePropertyValue)instanceProperties.getPropertyValue(propertyName);
        if (value != null && value.getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) {
            return (String)value.getPrimitiveValue();
        }
        return null;
    }

    private SequencingOrder getOrderType(SequenceOrderType orderType) {
        switch (orderType) {
            case GUID: {
                return SequencingOrder.GUID;
            }
            case LAST_UPDATE_OLDEST: {
                return SequencingOrder.LAST_UPDATE_OLDEST;
            }
            case LAST_UPDATE_RECENT: {
                return SequencingOrder.LAST_UPDATE_RECENT;
            }
            case PROPERTY_ASCENDING: {
                return SequencingOrder.PROPERTY_ASCENDING;
            }
            case PROPERTY_DESCENDING: {
                return SequencingOrder.PROPERTY_DESCENDING;
            }
            case CREATION_DATE_OLDEST: {
                return SequencingOrder.CREATION_DATE_OLDEST;
            }
            case CREATION_DATE_RECENT: {
                return SequencingOrder.CREATION_DATE_RECENT;
            }
        }
        return SequencingOrder.ANY;
    }

    public DataType getColumnTypeValue(EntityDetail columnType) {
        PrimitivePropertyValue value = (PrimitivePropertyValue)columnType.getProperties().getPropertyValue("dataType");
        if (value != null) {
            PrimitiveDefCategory primitiveValue = value.getPrimitiveDefCategory();
            return this.getDataTypeDef(primitiveValue);
        }
        return null;
    }

    private DataType getDataTypeDef(PrimitiveDefCategory primitiveValue) {
        if (primitiveValue == null || !this.dataTypes.containsKey(primitiveValue.getJavaClassName())) {
            return null;
        }
        return this.dataTypes.get(primitiveValue.getJavaClassName());
    }

    private HashMap<String, DataType> getDataTypeMap() {
        HashMap<String, DataType> dataTypesMap = new HashMap<String, DataType>();
        dataTypesMap.put("java.lang.Boolean", DataType.BOOLEAN);
        dataTypesMap.put("java.lang.Byte", DataType.BYTE);
        dataTypesMap.put("java.Lang.Char", DataType.CHAR);
        dataTypesMap.put("java.lang.Short", DataType.SHORT);
        dataTypesMap.put("java.lang.Integer", DataType.INT);
        dataTypesMap.put("java.lang.Long", DataType.LONG);
        dataTypesMap.put("java.lang.Float", DataType.FLOAT);
        dataTypesMap.put("java.lang.Double", DataType.DOUBLE);
        dataTypesMap.put("java.math.BigInteger", DataType.BIG_INTEGER);
        dataTypesMap.put("java.math.BigDecimal", DataType.BIG_DECIMAL);
        dataTypesMap.put("java.lang.String", DataType.STRING);
        dataTypesMap.put("java.util.Date", DataType.DATE);
        return dataTypesMap;
    }

    public Map<String, Object> getAdditionalPropertiesFromEntity(InstanceProperties properties, String propertyName, OMRSRepositoryHelper helper) {
        InstanceProperties mapProperty = this.getMapInstanceProperties(propertyName, properties, helper);
        if (mapProperty == null) {
            return null;
        }
        Iterator additionalPropertyNames = mapProperty.getPropertyNames();
        if (additionalPropertyNames == null) {
            return null;
        }
        HashMap<String, Object> additionalPropertiesMap = new HashMap<String, Object>();
        while (additionalPropertyNames.hasNext()) {
            String additionalPropertyName = (String)additionalPropertyNames.next();
            InstancePropertyValue additionalPropertyValue = mapProperty.getPropertyValue(additionalPropertyName);
            if (additionalPropertyValue == null) continue;
            Object primitivePropertyValue = this.getPrimitivePropertyValue(additionalPropertyValue);
            additionalPropertiesMap.put(additionalPropertyName, primitivePropertyValue);
        }
        return additionalPropertiesMap;
    }

    private InstanceProperties getMapInstanceProperties(String propertyName, InstanceProperties properties, OMRSRepositoryHelper helper) {
        return helper.getMapProperty(AccessServiceDescription.ASSET_CATALOG_OMAS.getAccessServiceName(), propertyName, properties, "getMapInstanceProperties");
    }

    private Object getPrimitivePropertyValue(InstancePropertyValue additionalPropertyValue) {
        if (additionalPropertyValue != null && additionalPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)additionalPropertyValue;
            return primitivePropertyValue.getPrimitiveValue();
        }
        return null;
    }

    public Map<String, String> getMapProperties(InstanceProperties properties) {
        Map instanceProperties;
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (properties != null && (instanceProperties = properties.getInstanceProperties()) != null) {
            for (Map.Entry property : instanceProperties.entrySet()) {
                String propertyValue;
                if (property.getValue() == null || (propertyValue = this.getStringForPropertyValue((InstancePropertyValue)property.getValue())).equals("")) continue;
                attributes.put((String)property.getKey(), propertyValue);
            }
        }
        return attributes;
    }

    private String getStringForPropertyValue(InstancePropertyValue ipv) {
        if (ipv instanceof PrimitivePropertyValue) {
            PrimitiveDefCategory primtype = ((PrimitivePropertyValue)ipv).getPrimitiveDefCategory();
            switch (primtype) {
                case OM_PRIMITIVE_TYPE_STRING: {
                    return (String)((PrimitivePropertyValue)ipv).getPrimitiveValue();
                }
                case OM_PRIMITIVE_TYPE_INT: 
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: 
                case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                case OM_PRIMITIVE_TYPE_BOOLEAN: 
                case OM_PRIMITIVE_TYPE_BYTE: 
                case OM_PRIMITIVE_TYPE_CHAR: 
                case OM_PRIMITIVE_TYPE_DATE: 
                case OM_PRIMITIVE_TYPE_DOUBLE: 
                case OM_PRIMITIVE_TYPE_FLOAT: 
                case OM_PRIMITIVE_TYPE_LONG: 
                case OM_PRIMITIVE_TYPE_SHORT: {
                    return ((PrimitivePropertyValue)ipv).getPrimitiveValue().toString();
                }
            }
            return "";
        }
        if (ipv instanceof EnumPropertyValue) {
            return ((EnumPropertyValue)ipv).getSymbolicName();
        }
        return "";
    }
}

