/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum AssetCatalogAuditCode {
    SERVICE_INITIALIZING("OMAS-ASSET-CATALOG-0001", OMRSAuditLogRecordSeverity.INFO, "The Asset Catalog Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Catalog OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("OMAS-ASSET-CATALOG-0003", OMRSAuditLogRecordSeverity.INFO, "The Asset Catalog Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Asset Catalog OMAS has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OMAS-ASSET-CATALOG-0004", OMRSAuditLogRecordSeverity.INFO, "The Asset Catalog Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local server has requested shut down of an Asset Catalog OMAS instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-CATALOG-0005", OMRSAuditLogRecordSeverity.ERROR, "The Asset Catalog Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private AssetCatalogAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

