/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetNotFoundException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.NotImplementedException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetElement;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Connection;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Element;
import org.odpi.openmetadata.accessservices.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Term;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogInstanceHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.util.Converter;
import org.odpi.openmetadata.accessservices.assetcatalog.util.ExceptionHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class AssetCatalogService {
    private static AssetCatalogInstanceHandler instanceHandler = new AssetCatalogInstanceHandler();
    private OMRSMetadataCollection metadataCollectionForSearch;
    private String serverName;
    private TypeDefGallery allTypes = new TypeDefGallery();
    private Converter converter = new Converter();
    private ExceptionHandler exceptionUtil = new ExceptionHandler();

    public AssetDescriptionResponse getAssetSummaryById(String serverName, String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntitySummary entitySummary = this.getEntitySummary(serverName, userId, assetId);
            AssetDescription assetDescription = this.converter.getAssetDescription(entitySummary);
            response.setAssetDescriptionList(Collections.singletonList(assetDescription));
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetDetailsById(String serverName, String userId, String assetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            EntityDetail entityDetail = this.getEntityDetails(serverName, userId, assetId);
            AssetDescription assetDescription = this.converter.getAssetDescription(entityDetail);
            response.setAssetDescriptionList(Collections.singletonList(assetDescription));
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public ClassificationsResponse getClassificationByAssetGUID(String serverName, String userId, String assetId, SearchParameters searchParameters) {
        ClassificationsResponse response = new ClassificationsResponse();
        try {
            List<Classification> assetClassifications = this.getAssetClassifications(serverName, userId, assetId);
            response.setClassifications(this.converter.toClassifications(assetClassifications));
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public RelationshipsResponse getAssetRelationships(String serverName, String userId, String assetId, SearchParameters parameters) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            String relationshipType = null;
            Status status = null;
            Integer fromElement = null;
            Integer pageSize = null;
            String property = null;
            SequenceOrderType orderType = null;
            if (parameters != null) {
                status = parameters.getStatus();
                orderType = parameters.getOrderType();
                property = parameters.getPropertyName();
                pageSize = parameters.getLimit();
                fromElement = parameters.getOffset();
                if (parameters.getTypes() != null && !parameters.getTypes().isEmpty()) {
                    relationshipType = (String)parameters.getTypes().get(0);
                }
            }
            String relationshipTypeID = this.getTypeDefGUID(userId, relationshipType, serverName);
            List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
            SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
            List<Relationship> relationships = this.getRelationships(serverName, userId, assetId, fromElement, pageSize, property, relationshipTypeID, instanceStatuses, sequencingOrder);
            response.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetsFromNeighborhood(String serverName, String userId, String entityGUID, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            Integer level = null;
            Status status = null;
            List entityTypesGuid = null;
            List<String> relationshipTypes = null;
            if (searchParameters != null) {
                status = searchParameters.getStatus();
                level = searchParameters.getLevel();
                if (searchParameters.getTypes() != null) {
                    entityTypesGuid = searchParameters.getTypes();
                }
            }
            List<EntityDetail> entitiesFromNeighborhood = this.getEntitiesFromNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, status, level);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(entitiesFromNeighborhood));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public RelationshipsResponse getRelationshipsFromNeighborhood(String serverName, String userId, String entityGUID, SearchParameters searchParameters) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            Integer level = null;
            List entityTypesGuid = null;
            List<String> relationshipTypes = null;
            Status relationshipStatus = null;
            if (searchParameters != null) {
                level = searchParameters.getLevel();
                relationshipStatus = searchParameters.getStatus();
                if (searchParameters.getTypes() != null) {
                    entityTypesGuid = searchParameters.getTypes();
                }
            }
            List<Relationship> relationshipsFromAssetNeighborhood = this.getRelationshipsFromAssetNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
            response.setRelationships(this.converter.toRelationships(relationshipsFromAssetNeighborhood));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getAssetUniverseByGUID(String serverName, String userId, String assetGUID) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        AssetDescription assetDescription = new AssetDescription();
        try {
            EntityDetail entityDetails = this.getEntityDetails(serverName, userId, assetGUID);
            assetDescription = this.converter.getAssetDescription(entityDetails);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        try {
            List<Relationship> relationships = this.getRelationships(serverName, userId, assetGUID, 0, 0, null, null, null, null);
            assetDescription.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        response.setAssetDescriptionList(Collections.singletonList(assetDescription));
        return response;
    }

    public RelationshipsResponse getLinkingRelationships(String serverName, String userId, String startAssetId, String endAssetId) {
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            List<Relationship> relationships = this.getLinkingRelationshipsBetweenAssets(serverName, userId, startAssetId, endAssetId);
            response.setRelationships(this.converter.toRelationships(relationships));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getLinkingAssets(String serverName, String userId, String startAssetId, String endAssetId) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            List<EntityDetail> intermediateAssets = this.getIntermediateAssets(serverName, userId, startAssetId, endAssetId);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(intermediateAssets));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public AssetDescriptionResponse getRelatedAssets(String serverName, String userId, String startAssetId, SearchParameters searchParameters) {
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            Integer limit = 0;
            Status status = null;
            List instanceType = null;
            Integer offset = null;
            SequenceOrderType orderType = null;
            String orderProperty = null;
            if (searchParameters != null) {
                limit = searchParameters.getLimit();
                status = searchParameters.getStatus();
                offset = searchParameters.getOffset();
                orderType = searchParameters.getOrderType();
                orderProperty = searchParameters.getOrderProperty();
                if (searchParameters.getTypes() != null) {
                    instanceType = searchParameters.getTypes();
                }
            }
            List<EntityDetail> relatedAssets = this.getRelatedAsset(serverName, userId, startAssetId, instanceType, limit, offset, orderType, orderProperty, status);
            response.setAssetDescriptionList(this.converter.getAssetsDetails(relatedAssets));
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetCatalogException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        return response;
    }

    public List<AssetDescription> getLastUpdatedAssets(String serverName, String userId, SearchParameters searchParameters) throws NotImplementedException {
        AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.METHOD_NOT_IMPLEMENTED;
        String methodName = "getLastUpdatedAssets";
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, userId, serverName});
        throw new NotImplementedException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public List<AssetDescription> getLastCreatedAssets(String serverName, String userId, SearchParameters searchParameters) throws NotImplementedException {
        AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.METHOD_NOT_IMPLEMENTED;
        String methodName = "getLastCreatedAssets";
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, userId, serverName});
        throw new NotImplementedException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void setMetadataRepositoryDetails(String serverName, String userId) throws PropertyServerException, RepositoryErrorException, UserNotAuthorizedException, InvalidParameterException {
        this.metadataCollectionForSearch = instanceHandler.getMetadataCollection(serverName);
        this.allTypes = this.metadataCollectionForSearch.getAllTypes(userId);
        this.serverName = serverName;
    }

    private EntitySummary getEntitySummary(String serverName, String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        EntitySummary entitySummary = metadataCollection.getEntitySummary(userId, assetId);
        if (entitySummary == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getEntitySummary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitySummary;
    }

    private EntityDetail getEntityDetails(String serverName, String userId, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        EntityDetail entityDetail = metadataCollection.getEntityDetail(userId, assetId);
        if (entityDetail == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entityDetail;
    }

    private List<Classification> getAssetClassifications(String serverName, String userId, String assetId) throws UserNotAuthorizedException, EntityNotKnownException, InvalidParameterException, RepositoryErrorException, EntityProxyOnlyException, AssetNotFoundException, ClassificationNotFoundException, PropertyServerException {
        EntityDetail asset = this.getEntityDetails(serverName, userId, assetId);
        if (asset.getClassifications() == null || asset.getClassifications().isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new ClassificationNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "searchForRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return asset.getClassifications();
    }

    private List<Relationship> getRelationships(String serverName, String userId, String assetId, Integer fromElement, Integer pageSize, String property, String relationshipTypeID, List<InstanceStatus> instanceStatuses, SequencingOrder sequencingOrder) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        List relationshipsForEntity = metadataCollection.getRelationshipsForEntity(userId, assetId, relationshipTypeID, fromElement.intValue(), instanceStatuses, null, property, sequencingOrder, pageSize.intValue());
        if (relationshipsForEntity == null || relationshipsForEntity.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.RELATIONSHIPS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRelationships", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relationshipsForEntity;
    }

    private List<EntityDetail> getEntitiesFromNeighborhood(String serverName, String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, AssetNotFoundException, PropertyServerException {
        InstanceGraph entityNeighborhood = this.getAssetNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
        List entities = entityNeighborhood.getEntities();
        if (entities == null || entities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_ASSET_FROM_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getEntitiesFromNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entities;
    }

    private List<Relationship> getRelationshipsFromAssetNeighborhood(String serverName, String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws InvalidParameterException, PropertyErrorException, AssetNotFoundException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException, TypeErrorException, RepositoryErrorException, PropertyServerException {
        InstanceGraph entityNeighborhood = this.getAssetNeighborhood(serverName, userId, entityGUID, entityTypesGuid, relationshipTypes, relationshipStatus, level);
        List entities = entityNeighborhood.getRelationships();
        if (entities == null || entities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_RELATIONSHIPS_FROM_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getRelationshipsFromAssetNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entities;
    }

    private InstanceGraph getAssetNeighborhood(String serverName, String userId, String entityGUID, List<String> entityTypesGuid, List<String> relationshipTypes, Status relationshipStatus, Integer level) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, AssetNotFoundException, PropertyServerException {
        List<InstanceStatus> limitResultsByStatus;
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        InstanceGraph entityNeighborhood = metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypesGuid, relationshipTypes, limitResultsByStatus = this.converter.getInstanceStatuses(relationshipStatus), null, null, level.intValue());
        if (entityNeighborhood == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_NEIGHBORHOOD_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityGUID, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getAssetNeighborhood", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entityNeighborhood;
    }

    private String getTypeDefGUID(String userId, String typeName, String serverName) throws RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, UserNotAuthorizedException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        return this.getTypeName(userId, typeName, metadataCollection);
    }

    private String getTypeName(String userId, String typeName, OMRSMetadataCollection metadataCollection) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        TypeDef typeDefByName = metadataCollection.getTypeDefByName(userId, typeName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    private String getTypeDefGUID(String entityType) {
        if (this.allTypes.getTypeDefs() != null) {
            return this.allTypes.getTypeDefs().stream().filter(s -> s.getName().equals(entityType)).findAny().map(TypeDefLink::getGUID).orElse(null);
        }
        return null;
    }

    private List<Relationship> getRelationshipByType(OMRSMetadataCollection metadataCollection, String userId, String entityGUID, String relationshipType) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, TypeDefNotKnownException {
        String typeGuid = this.getTypeName(userId, relationshipType, metadataCollection);
        List relationshipsForEntity = metadataCollection.getRelationshipsForEntity(userId, entityGUID, typeGuid, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, SequencingOrder.ANY, 0);
        if (relationshipsForEntity != null) {
            return relationshipsForEntity;
        }
        return new ArrayList<Relationship>();
    }

    private EntityDetail getThePairEntity(OMRSMetadataCollection metadataCollection, String userId, String entityDetailGUID, Relationship relationship) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException {
        if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
            return metadataCollection.getEntityDetail(userId, relationship.getEntityTwoProxy().getGUID());
        }
        return metadataCollection.getEntityDetail(userId, relationship.getEntityOneProxy().getGUID());
    }

    private List<EntityDetail> findEntitiesByClassifications(String serverName, String userId, String assetTypeId, String classificationName, Integer limit, Integer offset, String orderProperty, SequenceOrderType orderType, Status status) throws ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        List<InstanceStatus> instanceStatuses = this.converter.getInstanceStatuses(status);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List entitiesByClassification = metadataCollection.findEntitiesByClassification(userId, assetTypeId, classificationName, null, null, offset.intValue(), instanceStatuses, null, orderProperty, sequencingOrder, limit.intValue());
        if (entitiesByClassification == null || entitiesByClassification.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_WITH_CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationName, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitiesByClassification;
    }

    private List<EntityDetail> findEntitiesByProperty(String serverName, String userId, String assetTypeId, String matchProperty, String propertyValue, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        InstanceProperties matchProperties = this.getInstanceProperties(matchProperty, propertyValue);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List entitiesByProperty = metadataCollection.findEntitiesByProperty(userId, assetTypeId, matchProperties, MatchCriteria.ANY, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue());
        if (entitiesByProperty == null || entitiesByProperty.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.ASSET_WITH_CLASSIFICATION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{matchProperty, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return entitiesByProperty;
    }

    private InstanceProperties getInstanceProperties(String matchProperty, String propertyValue) {
        if (matchProperty != null) {
            return this.converter.getMatchProperties(matchProperty, propertyValue);
        }
        return this.converter.getMatchProperties("qualifiedName", propertyValue);
    }

    private List<Relationship> getLinkingRelationshipsBetweenAssets(String serverName, String userId, String startAssetId, String endAssetId) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, AssetNotFoundException, PropertyServerException {
        List<InstanceStatus> limitByStatus;
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus = this.converter.getInstanceStatuses(null), null);
        if (linkingEntities == null || linkingEntities.getRelationships() == null) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.LINKING_RELATIONSHIPS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, endAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getLinkingRelationshipsBetweenAssets", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return linkingEntities.getRelationships();
    }

    private List<EntityDetail> getIntermediateAssets(String serverName, String userId, String startAssetId, String endAssetId) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, AssetNotFoundException, PropertyServerException {
        List<InstanceStatus> limitByStatus;
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        InstanceGraph linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetId, endAssetId, limitByStatus = this.converter.getInstanceStatuses(null), null);
        if (linkingEntities == null || linkingEntities.getEntities() == null || linkingEntities.getEntities().isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.LINKING_ASSETS_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, endAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "getIntermediateAssets", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return linkingEntities.getEntities();
    }

    private List<EntityDetail> getRelatedAsset(String serverName, String userId, String startAssetId, List<String> instanceTypes, Integer limit, Integer offset, SequenceOrderType orderType, String orderProperty, Status status) throws UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, AssetNotFoundException, PropertyServerException {
        OMRSMetadataCollection metadataCollection = instanceHandler.getMetadataCollection(serverName);
        SequencingOrder sequencingOrder = this.converter.getSequencingOrder(orderType);
        List<InstanceStatus> limitResultsByStatus = this.converter.getInstanceStatuses(status);
        List relatedEntities = metadataCollection.getRelatedEntities(userId, startAssetId, instanceTypes, offset.intValue(), limitResultsByStatus, null, null, orderProperty, sequencingOrder, limit.intValue());
        if (relatedEntities == null || relatedEntities.isEmpty()) {
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.NO_RELATED_ASSETS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{startAssetId, serverName});
            throw new AssetNotFoundException(errorCode.getHttpErrorCode(), this.getClass().getName(), "findEntitiesByClassifications", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return relatedEntities;
    }

    private List<Relationship> getRelationshipsByAssetId(String userId, String entityId, String relationshipType) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, TypeDefNotKnownException {
        return this.getRelationshipByType(this.metadataCollectionForSearch, userId, entityId, relationshipType);
    }

    private EntityDetail getTheEndOfRelationship(String userId, String assetId, String relationshipType) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        List<Relationship> relationshipsToColumnTypes = this.getRelationshipsByAssetId(userId, assetId, relationshipType);
        if (relationshipsToColumnTypes.isEmpty() || relationshipsToColumnTypes.size() != 1) {
            return null;
        }
        return this.getThePairEntity(this.metadataCollectionForSearch, userId, assetId, relationshipsToColumnTypes.get(0));
    }

    private List<EntityDetail> getTheEndsRelationship(String userId, String assetId, String relationshipType) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        List<Relationship> relationships = this.getRelationshipsByAssetId(userId, assetId, relationshipType);
        if (relationships.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>(relationships.size());
        for (Relationship relationship : relationships) {
            entityDetails.add(this.getThePairEntity(this.metadataCollectionForSearch, userId, assetId, relationship));
        }
        return entityDetails;
    }

    public AssetResponse findAssetsBySearchedPropertyValue(String serverName, String userId, String searchCriteria, SearchParameters searchParameters) {
        AssetResponse response = new AssetResponse();
        try {
            this.setMetadataRepositoryDetails(serverName, userId);
            List<EntityDetail> entities = this.searchEntityByCriteria(this.metadataCollectionForSearch, userId, searchCriteria, "GlossaryTerm", searchParameters);
            List<EntityDetail> assets = this.searchEntityByCriteria(this.metadataCollectionForSearch, userId, searchCriteria, "Asset", searchParameters);
            entities.addAll(assets);
            ArrayList<Term> terms = new ArrayList<Term>(entities.size());
            for (EntityDetail entity : entities) {
                Term term = this.buildTerm(entity);
                terms.add(term);
            }
            response.setAssets(terms);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)((Object)e));
        }
        return response;
    }

    public AssetResponse buildAssetContext(String serverName, String userId, String assetId) {
        AssetResponse response = new AssetResponse();
        try {
            this.setMetadataRepositoryDetails(serverName, userId);
            EntityDetail entityDetail = this.getEntityDetails(serverName, userId, assetId);
            HashMap<String, List<Connection>> knownAssetConnection = new HashMap<String, List<Connection>>();
            String typeDefName = entityDetail.getType().getTypeDefName();
            if (typeDefName.equals("GlossaryTerm")) {
                Term term = this.getStructureForGlossaryTerm(userId, knownAssetConnection, entityDetail);
                response.setAssets(Collections.singletonList(term));
            } else {
                Term term = this.buildTerm(entityDetail);
                AssetElement assetElement = new AssetElement();
                if (this.isAsset(typeDefName).isPresent()) {
                    this.getAsset(userId, assetElement, knownAssetConnection, entityDetail);
                } else {
                    this.buildContextForAsset(userId, assetElement, knownAssetConnection, entityDetail);
                }
                term.setElements(Collections.singletonList(assetElement));
                response.setAssets(Collections.singletonList(term));
            }
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (AssetNotFoundException | PropertyServerException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)e);
        }
        return response;
    }

    public AssetResponse searchAssetsGeneric(String serverName, String userId, String searchCriteria, SearchParameters searchParameters) {
        AssetResponse response = new AssetResponse();
        try {
            this.setMetadataRepositoryDetails(serverName, userId);
            List<EntityDetail> entitiesByType = this.searchEntityByCriteria(this.metadataCollectionForSearch, userId, searchCriteria, "GlossaryTerm", searchParameters);
            ArrayList<Term> terms = new ArrayList<Term>(entitiesByType.size());
            HashMap<String, List<Connection>> knownAssetConnection = new HashMap<String, List<Connection>>();
            for (EntityDetail glossaryTerm : entitiesByType) {
                Term term = this.getStructureForGlossaryTerm(userId, knownAssetConnection, glossaryTerm);
                terms.add(term);
            }
            response.setAssets(terms);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException e) {
            this.exceptionUtil.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, (AssetCatalogException)((Object)e));
        }
        return response;
    }

    private Term getStructureForGlossaryTerm(String userId, Map<String, List<Connection>> knownAssetConnection, EntityDetail glossaryTerm) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        Term term = this.buildTerm(glossaryTerm);
        List<EntityDetail> schemas = this.getTheEndsRelationship(userId, glossaryTerm.getGUID(), "SemanticAssignment");
        ArrayList<AssetElement> assets = new ArrayList<AssetElement>(schemas.size());
        for (EntityDetail schema : schemas) {
            AssetElement assetElement = new AssetElement();
            Element firstElement = this.buildElement(schema);
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(firstElement);
            assetElement.setContext(elements);
            this.findAsset(userId, Collections.singletonList(schema), assetElement, knownAssetConnection);
            assets.add(assetElement);
        }
        term.setElements(assets);
        return term;
    }

    private void findAsset(String userId, List<EntityDetail> entitiesByType, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        for (EntityDetail entityDetail : entitiesByType) {
            List<EntityDetail> theEndOfRelationship = this.getTheEndsRelationship(userId, entityDetail.getGUID(), "AttributeForSchema");
            for (EntityDetail entity : theEndOfRelationship) {
                this.addElement(assetElement, this.buildElement(entity));
                Optional<TypeDef> isComplexSchemaType = this.isComplexSchemaType(entity.getType().getTypeDefName());
                if (isComplexSchemaType.isPresent()) {
                    this.setAssetDetails(userId, assetElement, knownAssetConnection, entity);
                    return;
                }
                List<EntityDetail> schemaAttributeTypeEntities = this.getTheEndsRelationship(userId, entity.getGUID(), "SchemaAttributeType");
                this.getSubElements(assetElement, schemaAttributeTypeEntities);
                this.findAsset(userId, schemaAttributeTypeEntities, assetElement, knownAssetConnection);
            }
        }
    }

    private void buildContextForAsset(String userId, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection, EntityDetail entityDetail) throws InvalidParameterException, TypeDefNotKnownException, PropertyErrorException, EntityProxyOnlyException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, UserNotAuthorizedException, TypeErrorException, RepositoryErrorException {
        Optional<TypeDef> isComplexSchemaType = this.isComplexSchemaType(entityDetail.getType().getTypeDefName());
        if (isComplexSchemaType.isPresent()) {
            this.setAssetDetails(userId, assetElement, knownAssetConnection, entityDetail);
        } else {
            List<EntityDetail> attributeForSchemas = this.getTheEndsRelationship(userId, entityDetail.getGUID(), "AttributeForSchema");
            for (EntityDetail attributeForSchema : attributeForSchemas) {
                Element element = this.buildElement(attributeForSchema);
                this.addElement(assetElement, element);
                if (this.isComplexSchemaType(attributeForSchema.getType().getTypeDefName()).isPresent()) {
                    this.setAssetDetails(userId, assetElement, knownAssetConnection, attributeForSchema);
                    return;
                }
                List<EntityDetail> schemaAttributeTypeEntities = this.getTheEndsRelationship(userId, attributeForSchema.getGUID(), "SchemaAttributeType");
                this.getSubElements(assetElement, schemaAttributeTypeEntities);
                for (EntityDetail schema : schemaAttributeTypeEntities) {
                    this.buildContextForAsset(userId, assetElement, knownAssetConnection, schema);
                }
            }
        }
    }

    private void addElement(AssetElement assetElement, Element element) {
        if (assetElement.getContext() != null) {
            assetElement.getContext().add(element);
        } else {
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(element);
            assetElement.setContext(elements);
        }
    }

    private void setAssetDetails(String userId, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection, EntityDetail entity) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        EntityDetail dataSet = this.getTheEndOfRelationship(userId, entity.getGUID(), "AssetSchemaType");
        if (assetElement.getContext() != null && dataSet != null) {
            assetElement.getContext().add(this.buildElement(dataSet));
        } else {
            assetElement.setContext(Collections.singletonList(this.buildElement(dataSet)));
        }
        this.getAsset(userId, assetElement, knownAssetConnection, dataSet);
    }

    private void getAsset(String userId, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection, EntityDetail dataSet) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        if (dataSet == null) {
            return;
        }
        List<Relationship> relationshipsToColumnTypes = this.getRelationshipsByAssetId(userId, dataSet.getGUID(), "DataContentForDataSet");
        if (!relationshipsToColumnTypes.isEmpty() && relationshipsToColumnTypes.size() == 1) {
            if (relationshipsToColumnTypes.get(0).getEntityOneProxy().getGUID().equals(dataSet.getGUID())) {
                this.setConnections(userId, assetElement, knownAssetConnection, dataSet);
            } else {
                EntityDetail asset = this.getThePairEntity(this.metadataCollectionForSearch, userId, dataSet.getGUID(), relationshipsToColumnTypes.get(0));
                if (asset != null) {
                    this.setAssetElementAttributes(assetElement, asset);
                    this.setConnections(userId, assetElement, knownAssetConnection, asset);
                }
            }
        }
    }

    private void getSubElements(AssetElement assetElement, List<EntityDetail> schemaAttributeTypeEntities) {
        List<Element> elements = this.getElements(schemaAttributeTypeEntities);
        if (elements.isEmpty()) {
            return;
        }
        List existingElements = assetElement.getContext();
        if (existingElements != null) {
            existingElements.addAll(elements);
        } else {
            assetElement.setContext(elements);
        }
    }

    private void setConnections(String userId, AssetElement assetElement, Map<String, List<Connection>> knownAssetConnection, EntityDetail asset) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        if (knownAssetConnection.containsKey(asset.getGUID())) {
            assetElement.setConnections(knownAssetConnection.get(asset.getGUID()));
        } else {
            List<Connection> connections = this.getConnections(userId, asset.getGUID());
            knownAssetConnection.put(asset.getGUID(), connections);
            assetElement.setConnections(connections);
        }
    }

    private void setAssetElementAttributes(AssetElement assetElement, EntityDetail asset) {
        assetElement.setGuid(asset.getGUID());
        assetElement.setType(asset.getType().getTypeDefName());
        assetElement.setQualifiedName(this.converter.getStringPropertyValue(asset.getProperties(), "qualifiedName"));
        assetElement.setProperties(this.converter.getMapProperties(asset.getProperties()));
    }

    private List<Element> getElements(List<EntityDetail> schemaAttributeTypeEntities) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (EntityDetail schemaAttributeType : schemaAttributeTypeEntities) {
            Element element = this.buildElement(schemaAttributeType);
            elements.add(element);
        }
        return elements;
    }

    private Element buildElement(EntityDetail entityDetail) {
        return this.buildTerm(entityDetail);
    }

    private Term buildTerm(EntityDetail glossaryTerm) {
        Term term = new Term();
        term.setGuid(glossaryTerm.getGUID());
        term.setType(glossaryTerm.getType().getTypeDefName());
        term.setQualifiedName(this.converter.getStringPropertyValue(glossaryTerm.getProperties(), "qualifiedName"));
        term.setProperties(this.converter.getMapProperties(glossaryTerm.getProperties()));
        return term;
    }

    private Optional<TypeDef> isComplexSchemaType(String typeDefName) {
        return this.allTypes.getTypeDefs().stream().filter(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType")).findAny();
    }

    private Optional<TypeDef> isAsset(String typeDefName) {
        Optional<TypeDef> superType;
        Optional<TypeDef> typeDefStream = this.allTypes.getTypeDefs().stream().filter(t -> t.getName().equals(typeDefName)).findAny();
        if (typeDefStream.isPresent() && (superType = this.allTypes.getTypeDefs().stream().filter(t -> t.getName().equals(((TypeDef)typeDefStream.get()).getSuperType().getName())).findAny()).isPresent()) {
            return typeDefStream.map(typeDef -> this.allTypes.getTypeDefs().stream().filter(t -> t.getName().equals(((TypeDef)superType.get()).getName()) && t.getSuperType().getName().equals("Asset")).findAny()).orElse(null);
        }
        return Optional.empty();
    }

    private List<Connection> getConnections(String userId, String dataSetGuid) throws RepositoryErrorException, UserNotAuthorizedException, EntityNotKnownException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, EntityProxyOnlyException, TypeDefNotKnownException {
        List<EntityDetail> connections = this.getTheEndsRelationship(userId, dataSetGuid, "ConnectionToAsset");
        if (!connections.isEmpty()) {
            return connections.stream().map(t -> new Connection(t.getGUID(), this.converter.getStringPropertyValue(t.getProperties(), "qualifiedName"))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<EntityDetail> searchEntityByCriteria(OMRSMetadataCollection metadataCollection, String userId, String searchCriteria, String entityType, SearchParameters searchParameters) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        String typeDefGUID = this.getTypeDefGUID(entityType);
        List entitiesByPropertyValue = metadataCollection.findEntitiesByPropertyValue(userId, typeDefGUID, searchCriteria, searchParameters.getOffset() != null ? searchParameters.getOffset() : 0, searchParameters.getStatus() != null ? this.converter.getInstanceStatuses(searchParameters.getStatus()) : this.converter.getInstanceStatuses(Status.ACTIVE), null, null, searchParameters.getOrderProperty(), searchParameters.getOrderType() != null ? this.converter.getSequencingOrder(searchParameters.getOrderType()) : null, searchParameters.getLimit() != null ? searchParameters.getLimit() : 0);
        if (entitiesByPropertyValue != null) {
            return entitiesByPropertyValue;
        }
        return Collections.emptyList();
    }
}

