/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.AssetCatalogHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.RelationshipHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class AssetCatalogServicesInstance
extends OCFOMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.ASSET_CATALOG_OMAS;
    private AssetCatalogHandler assetCatalogHandler;
    private RelationshipHandler relationshipHandler;

    AssetCatalogServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, OMRSAuditLog auditLog, String localServerUserId, List<String> supportedTypesForSearch) throws NewInstanceException {
        super(description.getAccessServiceName() + " OMAS", repositoryConnector, auditLog, localServerUserId, repositoryConnector.getMaxPageSize());
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            AssetCatalogErrorCode errorCode = AssetCatalogErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.assetCatalogHandler = new AssetCatalogHandler(this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler, supportedZones, supportedTypesForSearch);
        this.relationshipHandler = new RelationshipHandler(this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler);
    }

    AssetCatalogHandler getAssetCatalogHandler() {
        return this.assetCatalogHandler;
    }

    RelationshipHandler getRelationshipHandler() {
        return this.relationshipHandler;
    }
}

