/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.handlers;

import org.odpi.openmetadata.accessservices.assetcatalog.builders.AssetConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.CommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelationshipHandler {
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RepositoryErrorHandler errorHandler;
    private CommonHandler commonHandler;

    public RelationshipHandler(InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, RepositoryErrorHandler errorHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.errorHandler = errorHandler;
        this.commonHandler = new CommonHandler(repositoryHandler, repositoryHelper, this.errorHandler);
    }

    public org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship getRelationshipBetweenEntities(String userId, String entity1GUID, String entity2GUID, String relationshipType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship relationshipBetweenEntities;
        String methodName = "getRelationshipBetweenEntities";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipBetweenEntities");
        this.invalidParameterHandler.validateGUID(entity1GUID, "entity1GUID", "getRelationshipBetweenEntities");
        this.invalidParameterHandler.validateGUID(entity2GUID, "entity2GUID", "getRelationshipBetweenEntities");
        String relationshipTypeGUID = null;
        if (relationshipType != null) {
            relationshipTypeGUID = this.commonHandler.getTypeDefGUID(userId, relationshipType);
        }
        if ((relationshipBetweenEntities = this.repositoryHandler.getRelationshipBetweenEntities(userId, entity1GUID, "", entity2GUID, relationshipTypeGUID, relationshipType, "getRelationshipBetweenEntities")) != null) {
            AssetConverter converter = new AssetConverter(this.repositoryHelper);
            return converter.convertRelationship(relationshipBetweenEntities);
        }
        return null;
    }
}

