/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.service;

import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.admin.AssetCatalogInstanceHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.AssetCatalogHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetElements;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.util.ExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCatalogRESTService {
    private static final Logger log = LoggerFactory.getLogger(AssetCatalogRESTService.class);
    private static final String CALLING_METHOD = "Calling method: {}";
    private static final String FROM_METHOD_WITH_RESPONSE = "Returning from method: {} with response: {}";
    private final AssetCatalogInstanceHandler instanceHandler = new AssetCatalogInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private ExceptionHandler exceptionHandler = new ExceptionHandler();

    public AssetDescriptionResponse getAssetDetailsByGUID(String serverName, String userId, String assetGUID, String assetTypeName) {
        String methodName = "getAssetDetailsByGUID";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            AssetDescription assetDescription = assetCatalogHandler.getEntityDetails(userId, assetGUID, assetTypeName);
            response.setAssetDescriptionList(Collections.singletonList(assetDescription));
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        log.debug(FROM_METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetDescriptionResponse getAssetUniverseByGUID(String serverName, String userId, String assetGUID, String assetTypeName) {
        String methodName = "getAssetUniverseByGUID";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            AssetDescription assetDescription = assetCatalogHandler.getEntityDetails(userId, assetGUID, assetTypeName);
            assetDescription.setRelationships(assetCatalogHandler.getRelationshipsByEntityGUID(userId, assetGUID, assetDescription.getType().getName()));
            response.setAssetDescriptionList(Collections.singletonList(assetDescription));
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        log.debug(FROM_METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public ClassificationsResponse getClassificationByAssetGUID(String serverName, String userId, String assetGUID, String assetTypeName, String classificationName) {
        String methodName = "getClassificationByAssetGUID";
        log.debug(CALLING_METHOD, (Object)methodName);
        ClassificationsResponse response = new ClassificationsResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setClassifications(assetCatalogHandler.getEntityClassificationByName(userId, assetGUID, assetTypeName, classificationName));
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        log.debug(FROM_METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public RelationshipsResponse getLinkingRelationships(String serverName, String userId, String startAssetId, String endAssetId) {
        String methodName = "getLinkingRelationships";
        log.debug(CALLING_METHOD, (Object)methodName);
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setRelationships(assetCatalogHandler.getLinkingRelationshipsBetweenAssets(serverName, userId, startAssetId, endAssetId));
        }
        catch (AssetCatalogException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        log.debug(FROM_METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public RelationshipsResponse getAssetRelationships(String serverName, String userId, String assetGUID, String assetTypeName, String relationshipTypeName, Integer startFrom, Integer limit) {
        String methodName = "getAssetRelationships";
        log.debug(CALLING_METHOD, (Object)methodName);
        RelationshipsResponse response = new RelationshipsResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setRelationships(assetCatalogHandler.getRelationships(userId, assetGUID, assetTypeName, relationshipTypeName, startFrom, limit));
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        log.debug(FROM_METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetDescriptionResponse getLinkingAssets(String serverName, String userId, String startAssetId, String endAssetId) {
        String methodName = "getLinkingAssets";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setAssetDescriptionList(assetCatalogHandler.getIntermediateAssets(userId, startAssetId, endAssetId));
        }
        catch (AssetCatalogException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        log.debug(FROM_METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetDescriptionResponse getAssetsFromNeighborhood(String serverName, String userId, String entityGUID, SearchParameters searchParameters) {
        String methodName = "getAssetsFromNeighborhood";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            List<AssetDescription> entitiesFromNeighborhood = assetCatalogHandler.getEntitiesFromNeighborhood(serverName, userId, entityGUID, searchParameters);
            response.setAssetDescriptionList(entitiesFromNeighborhood);
        }
        catch (AssetCatalogException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        log.debug(FROM_METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetResponse searchByType(String serverName, String userId, String searchCriteria, SearchParameters searchParameters) {
        String methodName = "searchByType";
        AssetResponse response = new AssetResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setAssets(assetCatalogHandler.searchByType(userId, searchCriteria, searchParameters));
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        return response;
    }

    public AssetResponse buildContext(String serverName, String userId, String assetGUID, String assetType) {
        AssetResponse response = new AssetResponse();
        String methodName = "buildContext";
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            AssetElements assetElements = assetCatalogHandler.buildContextByType(userId, assetGUID, assetType);
            if (assetElements != null) {
                response.setAssets(Collections.singletonList(assetElements));
            }
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        return response;
    }

    public AssetCatalogSupportedTypes getSupportedTypes(String serverName, String userId, String type) {
        AssetCatalogSupportedTypes response = new AssetCatalogSupportedTypes();
        String methodName = "getTypes";
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setTypes(assetCatalogHandler.getSupportedTypes(userId, type));
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        return response;
    }
}

