/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.admin.AssetCatalogServicesInstance;
import org.odpi.openmetadata.accessservices.assetcatalog.auditlog.AssetCatalogAuditCode;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetCatalogAdmin
extends AccessServiceAdmin {
    public static final String SUPPORTED_TYPES_FOR_SEARCH = "SupportedTypesForSearch";
    private OMRSAuditLog auditLog;
    private AssetCatalogServicesInstance instance;
    private String serverName;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        try {
            AssetCatalogAuditCode auditCode = AssetCatalogAuditCode.SERVICE_INITIALIZING;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions(), accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
            List<String> supportedTypesForSearch = this.getSupportedTypesForSearchOption(accessServiceConfigurationProperties);
            this.instance = new AssetCatalogServicesInstance(repositoryConnector, supportedZones, auditLog, this.serverName, supportedTypesForSearch);
            this.serverName = this.instance.getServerName();
            auditCode = AssetCatalogAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfigurationProperties.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            AssetCatalogAuditCode auditCode = AssetCatalogAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), accessServiceConfigurationProperties.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)error);
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            AssetCatalogAuditCode auditCode = AssetCatalogAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private List<String> getSupportedTypesForSearchOption(AccessServiceConfig accessServiceConfigurationProperties) {
        Object supportedTypesProperty;
        List supportedTypesForSearch = null;
        if (accessServiceConfigurationProperties.getAccessServiceOptions() != null && (supportedTypesProperty = accessServiceConfigurationProperties.getAccessServiceOptions().get(SUPPORTED_TYPES_FOR_SEARCH)) != null) {
            supportedTypesForSearch = (List)supportedTypesProperty;
        }
        return supportedTypesForSearch;
    }
}

