/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.admin;

import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.admin.AssetCatalogServicesInstance;
import org.odpi.openmetadata.accessservices.assetcatalog.auditlog.AssetCatalogAuditCode;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetCatalogAdmin
extends AccessServiceAdmin {
    public static final String SUPPORTED_TYPES_FOR_SEARCH = "SupportedTypesForSearch";
    private AuditLog auditLog;
    private AssetCatalogServicesInstance instance;
    private String serverName;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", AssetCatalogAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions(), accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
            List<String> supportedTypesForSearch = this.getSupportedTypesForSearchOption(accessServiceConfigurationProperties);
            this.instance = new AssetCatalogServicesInstance(repositoryConnector, supportedZones, auditLog, this.serverName, supportedTypesForSearch);
            this.serverName = this.instance.getServerName();
            auditLog.logMessage("initialize", AssetCatalogAuditCode.SERVICE_INITIALIZED.getMessageDefinition());
        }
        catch (Exception error) {
            auditLog.logException("initialize", AssetCatalogAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.ASSET_CATALOG_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            this.auditLog.logMessage("shutdown", AssetCatalogAuditCode.SERVICE_SHUTDOWN.getMessageDefinition());
        }
    }

    private List<String> getSupportedTypesForSearchOption(AccessServiceConfig accessServiceConfigurationProperties) {
        Object supportedTypesProperty;
        if (accessServiceConfigurationProperties.getAccessServiceOptions() != null && (supportedTypesProperty = accessServiceConfigurationProperties.getAccessServiceOptions().get(SUPPORTED_TYPES_FOR_SEARCH)) instanceof List) {
            return (List)supportedTypesProperty;
        }
        return Collections.emptyList();
    }
}

