/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.auditlog;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum AssetCatalogAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZED("OMAS-ASSET-CATALOG-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Catalog Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Asset Catalog OMAS has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZING("OMAS-ASSET-CATALOG-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Catalog Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Catalog OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-CATALOG-0003", OMRSAuditLogRecordSeverity.ERROR, "The Asset Catalog Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_SHUTDOWN("OMAS-ASSET-CATALOG-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Catalog Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local server has requested shut down of an Asset Catalog OMAS instance.", "No action is required.  This is part of the normal operation of the service.");

    private AuditLogMessageDefinition messageDefinition;

    private AssetCatalogAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "AssetCatalogAuditCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

