/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.AssetCatalogHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.RelationshipHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class AssetCatalogServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.ASSET_CATALOG_OMAS;
    private AssetCatalogHandler assetCatalogHandler;
    private RelationshipHandler relationshipHandler;

    AssetCatalogServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String serverUserName, String sourceName, List<String> supportedTypesForSearch) throws NewInstanceException {
        super(description.getAccessServiceName() + " OMAS", repositoryConnector, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(AssetCatalogErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.assetCatalogHandler = new AssetCatalogHandler(this.serverName, sourceName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler, supportedZones, supportedTypesForSearch);
        this.relationshipHandler = new RelationshipHandler(sourceName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler);
    }

    AssetCatalogHandler getAssetCatalogHandler() {
        return this.assetCatalogHandler;
    }

    RelationshipHandler getRelationshipHandler() {
        return this.relationshipHandler;
    }
}

