/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetcatalog.builders.AssetConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Type;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CommonHandler {
    public static final String ZONE_MEMBERSHIP = "zoneMembership";
    private final String sourceName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final RepositoryErrorHandler errorHandler;

    CommonHandler(String sourceName, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, RepositoryErrorHandler errorHandler) {
        this.sourceName = sourceName;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.errorHandler = errorHandler;
    }

    OMRSMetadataCollection getOMRSMetadataCollection() {
        return this.repositoryHandler.getMetadataCollection();
    }

    List<Type> getTypeContext(String userId, String typeDefName) {
        ArrayList<Type> response = new ArrayList<Type>();
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        AssetConverter converter = new AssetConverter(this.sourceName, this.repositoryHelper);
        if (typeDefByName != null) {
            if (this.repositoryHelper.getKnownTypeDefGallery() == null || CollectionUtils.isEmpty((Collection)this.repositoryHelper.getKnownTypeDefGallery().getTypeDefs())) {
                return response;
            }
            ArrayList typeDefs = this.repositoryHelper.getKnownTypeDefGallery().getTypeDefs();
            Type type = converter.convertType(typeDefByName);
            List<Type> subTypes = this.getSubTypes(typeDefs, type);
            response.add(type);
            response.addAll(subTypes);
            this.collectSubTypes(subTypes, typeDefs, response);
            response.sort(Comparator.comparing(Type::getName));
        }
        return response;
    }

    Type getTypeByTypeDefName(String userId, String typeDefName) {
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        AssetConverter converter = new AssetConverter(this.sourceName, this.repositoryHelper);
        if (typeDefByName != null) {
            return converter.convertType(typeDefByName);
        }
        return null;
    }

    public String getTypeDefGUID(String userId, String typeDefName) {
        if (typeDefName == null) {
            return null;
        }
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        return Optional.ofNullable(typeDefByName).map(TypeDefLink::getGUID).orElse(null);
    }

    public boolean hasDisplayName(String userId, String typeDefGUID) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String methodName = "hasDisplayName";
        TypeDef typeDefByName = null;
        try {
            typeDefByName = this.repositoryHelper.getTypeDef(userId, "GUID", typeDefGUID, methodName);
        }
        catch (TypeErrorException typeErrorException) {
            this.errorHandler.handleUnsupportedType((Throwable)typeErrorException, methodName, "GUID");
        }
        List allPropertiesForTypeDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.sourceName, typeDefByName, methodName);
        if (allPropertiesForTypeDef == null) {
            return false;
        }
        return allPropertiesForTypeDef.stream().anyMatch(property -> property.getAttributeName().equals("displayName"));
    }

    List<String> getAssetZoneMembership(List<Classification> classifications) {
        List zoneMembership;
        String methodName = "getAssetZoneMembership";
        if (CollectionUtils.isEmpty(classifications)) {
            return Collections.emptyList();
        }
        Optional<Classification> assetZoneMembership = this.getAssetZoneMembershipClassification(classifications);
        if (assetZoneMembership.isPresent() && CollectionUtils.isNotEmpty((Collection)(zoneMembership = this.repositoryHelper.getStringArrayProperty(this.sourceName, ZONE_MEMBERSHIP, assetZoneMembership.get().getProperties(), methodName)))) {
            return zoneMembership;
        }
        return Collections.emptyList();
    }

    EntityDetail getEntityByGUID(String userId, String guid, String type) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String entityTypeName = type == null ? "Unknown" : type;
        String methodName = "getEntityByGUID";
        try {
            return this.repositoryHandler.getMetadataCollection().getEntityDetail(userId, guid);
        }
        catch (InvalidParameterException | RepositoryErrorException e) {
            this.errorHandler.handleRepositoryError(e, methodName);
        }
        catch (EntityNotKnownException e) {
            this.errorHandler.handleUnknownEntity((Throwable)e, guid, entityTypeName, methodName, "GUID");
        }
        catch (EntityProxyOnlyException e) {
            this.errorHandler.handleEntityProxy((Throwable)e, guid, entityTypeName, methodName, "GUID");
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        return null;
    }

    List<String> getTypesGUID(String userId, List<String> types) {
        if (CollectionUtils.isEmpty(types)) {
            return Collections.emptyList();
        }
        return types.stream().map(type -> this.repositoryHelper.getTypeDefByName(userId, type).getGUID()).collect(Collectors.toList());
    }

    private void collectSubTypes(List<Type> types, List<TypeDef> activeTypeDefs, List<Type> collector) {
        for (Type currentSubType : types) {
            List<Type> subTypes = this.getSubTypes(activeTypeDefs, currentSubType);
            collector.addAll(subTypes);
            this.collectSubTypes(subTypes, activeTypeDefs, collector);
        }
    }

    private List<Type> getSubTypes(List<TypeDef> activeTypeDefs, Type type) {
        String typeName = type.getName();
        AssetConverter converter = new AssetConverter(this.sourceName, this.repositoryHelper);
        ArrayList<Type> subTypes = new ArrayList<Type>();
        for (TypeDef typeDef : activeTypeDefs) {
            if (typeDef.getSuperType() == null || !typeDef.getSuperType().getName().equals(typeName)) continue;
            subTypes.add(converter.convertType(typeDef));
        }
        return subTypes;
    }

    private Optional<Classification> getAssetZoneMembershipClassification(List<Classification> classifications) {
        return classifications.stream().filter(classification -> classification.getName().equals("AssetZoneMembership")).findFirst();
    }

    Set<String> collectSuperTypes(String userId, String typeDefName) {
        HashSet<String> superTypes = new HashSet<String>();
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
        return superTypes;
    }

    private void collectSuperTypes(String userId, TypeDef type, Set<String> superTypes) {
        if (type.getName().equals("Referenceable")) {
            return;
        }
        superTypes.add(type.getName());
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, type.getSuperType().getName());
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
    }
}

