/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.service;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.admin.AssetCatalogInstanceHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.AssetCatalogHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Elements;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.util.ExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCatalogRESTService {
    private static final Logger log = LoggerFactory.getLogger(AssetCatalogRESTService.class);
    private static final String CALLING_METHOD = "Calling method: {}";
    private static final String METHOD_WITH_RESPONSE = "Returning from method: {} with response: {}";
    private final AssetCatalogInstanceHandler instanceHandler = new AssetCatalogInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private ExceptionHandler exceptionHandler = new ExceptionHandler();

    public AssetDescriptionResponse getAssetDetailsByGUID(String serverName, String userId, String assetGUID, String assetTypeName) {
        String methodName = "getAssetDetailsByGUID";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            AssetDescription assetDescription = assetCatalogHandler.getEntityDetails(userId, assetGUID, assetTypeName);
            response.setAssetDescription(assetDescription);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetDescriptionResponse getAssetUniverseByGUID(String serverName, String userId, String assetGUID, String assetTypeName) {
        String methodName = "getAssetUniverseByGUID";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionResponse response = new AssetDescriptionResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            AssetDescription assetDescription = assetCatalogHandler.getEntityDetails(userId, assetGUID, assetTypeName);
            assetDescription.setRelationships(assetCatalogHandler.getRelationshipsByEntityGUID(userId, assetGUID, assetDescription.getType().getName()));
            response.setAssetDescription(assetDescription);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public ClassificationListResponse getClassificationByAssetGUID(String serverName, String userId, String assetGUID, String assetTypeName, String classificationName) {
        String methodName = "getClassificationByAssetGUID";
        log.debug(CALLING_METHOD, (Object)methodName);
        ClassificationListResponse response = new ClassificationListResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setClassifications(assetCatalogHandler.getEntityClassificationByName(userId, assetGUID, assetTypeName, classificationName));
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public RelationshipListResponse getLinkingRelationships(String serverName, String userId, String startAssetGUID, String endAssetGUID) {
        String methodName = "getLinkingRelationships";
        log.debug(CALLING_METHOD, (Object)methodName);
        RelationshipListResponse response = new RelationshipListResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setRelationships(assetCatalogHandler.getLinkingRelationshipsBetweenAssets(serverName, userId, startAssetGUID, endAssetGUID));
        }
        catch (AssetCatalogException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public RelationshipListResponse getAssetRelationships(String serverName, String userId, String assetGUID, String assetTypeName, String relationshipTypeName, Integer startFrom, Integer limit) {
        String methodName = "getAssetRelationships";
        log.debug(CALLING_METHOD, (Object)methodName);
        RelationshipListResponse response = new RelationshipListResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setRelationships(assetCatalogHandler.getRelationships(userId, assetGUID, assetTypeName, relationshipTypeName, startFrom, limit));
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetDescriptionListResponse getLinkingAssets(String serverName, String userId, String startAssetId, String endAssetId) {
        String methodName = "getLinkingAssets";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionListResponse response = new AssetDescriptionListResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setAssetDescriptionList(assetCatalogHandler.getIntermediateAssets(userId, startAssetId, endAssetId));
        }
        catch (AssetCatalogException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetDescriptionListResponse getAssetsFromNeighborhood(String serverName, String userId, String assetGUID, SearchParameters searchParameters) {
        String methodName = "getAssetsFromNeighborhood";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetDescriptionListResponse response = new AssetDescriptionListResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            List<AssetDescription> entitiesFromNeighborhood = assetCatalogHandler.getEntitiesFromNeighborhood(serverName, userId, assetGUID, searchParameters);
            response.setAssetDescriptionList(entitiesFromNeighborhood);
        }
        catch (AssetCatalogException e) {
            this.exceptionHandler.captureAssetCatalogExeption((AssetCatalogOMASAPIResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetListResponse searchByType(String serverName, String userId, String searchCriteria, SearchParameters searchParameters) {
        String methodName = "searchByType";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetListResponse response = new AssetListResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setElementsList(assetCatalogHandler.searchByType(userId, searchCriteria, searchParameters));
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSCheckedExceptionBase((AssetCatalogOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetResponse buildContext(String serverName, String userId, String assetGUID, String assetType) {
        String methodName = "buildContext";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetResponse response = new AssetResponse();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            Elements elements = assetCatalogHandler.buildContextByType(userId, assetGUID, assetType);
            if (elements != null) {
                response.setAsset(elements);
            }
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }

    public AssetCatalogSupportedTypes getSupportedTypes(String serverName, String userId, String type) {
        String methodName = "getTypes";
        log.debug(CALLING_METHOD, (Object)methodName);
        AssetCatalogSupportedTypes response = new AssetCatalogSupportedTypes();
        try {
            AssetCatalogHandler assetCatalogHandler = this.instanceHandler.getAssetCatalogHandler(userId, serverName, methodName);
            response.setTypes(assetCatalogHandler.getSupportedTypes(userId, type));
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug(METHOD_WITH_RESPONSE, (Object)methodName, (Object)response);
        return response;
    }
}

