/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetcatalog.builders.AssetCatalogConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogBean;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogItemElement;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Connection;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Element;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Elements;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Type;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCatalogHandler {
    private static final Logger log = LoggerFactory.getLogger(AssetCatalogHandler.class);
    private final String serverUserName;
    private final String sourceName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RepositoryErrorHandler errorHandler;
    private final CommonHandler commonHandler;
    private final AssetCatalogConverter assetCatalogConverter;
    private final List<String> defaultSearchTypes = new ArrayList<String>(Arrays.asList("0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "896d14c2-7522-4f6c-8519-757711943fe6", "718d4244-8559-49ed-ad5a-10e5c305a656"));
    private List<String> supportedTypesForSearch = new ArrayList<String>(Arrays.asList("GlossaryTerm", "Asset", "SchemaElement"));
    private final List<String> supportedZones;

    public AssetCatalogHandler(String serverUserName, String sourceName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, RepositoryErrorHandler errorHandler, List<String> supportedZones, List<String> supportedTypesForSearch) {
        this.serverUserName = serverUserName;
        this.sourceName = sourceName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.errorHandler = errorHandler;
        this.supportedZones = supportedZones;
        this.commonHandler = new CommonHandler(sourceName, repositoryHandler, repositoryHelper, errorHandler);
        if (CollectionUtils.isNotEmpty(supportedTypesForSearch)) {
            this.supportedTypesForSearch = supportedTypesForSearch;
            Collections.sort(supportedTypesForSearch);
        }
        this.assetCatalogConverter = new AssetCatalogConverter(sourceName, repositoryHelper);
    }

    public AssetCatalogBean getEntityDetails(String userId, String assetGUID, String assetTypeName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "GUID", methodName);
        EntityDetail entityByGUID = this.commonHandler.getEntityByGUID(userId, assetGUID, assetTypeName);
        return this.assetCatalogConverter.getAssetCatalogBean(entityByGUID);
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship> getRelationshipsByEntityGUID(String userId, String assetGUID, String assetTypeName) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String methodName = "getRelationshipsByEntityGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "GUID", methodName);
        List relationshipsByType = this.repositoryHandler.getRelationshipsByType(userId, assetGUID, assetTypeName, null, null, methodName);
        if (CollectionUtils.isNotEmpty((Collection)relationshipsByType)) {
            return this.assetCatalogConverter.convertRelationships(relationshipsByType);
        }
        return Collections.emptyList();
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification> getEntityClassificationByName(String userId, String assetGUID, String assetTypeName, String classificationName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityClassificationByName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "GUID", methodName);
        List<Classification> entityClassifications = this.getEntityClassifications(userId, assetGUID, assetTypeName);
        if (CollectionUtils.isEmpty(entityClassifications)) {
            return Collections.emptyList();
        }
        if (classificationName != null) {
            entityClassifications = this.filterClassificationByName(entityClassifications, classificationName);
        }
        return this.assetCatalogConverter.convertClassifications(entityClassifications);
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship> getLinkingRelationshipsBetweenAssets(String serverName, String userId, String startAssetGUID, String endAssetGUID) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AssetCatalogException {
        String methodName = "getLinkingRelationshipsBetweenAssets";
        this.initialValidationStartEndAssetGUID(userId, startAssetGUID, endAssetGUID, methodName);
        OMRSMetadataCollection metadataCollection = this.commonHandler.getOMRSMetadataCollection();
        InstanceGraph linkingEntities = null;
        try {
            linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetGUID, endAssetGUID, Collections.singletonList(InstanceStatus.ACTIVE), null);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException e) {
            this.errorHandler.handleRepositoryError(e, methodName);
        }
        catch (EntityNotKnownException e) {
            this.errorHandler.handleUnknownEntity((Throwable)e, startAssetGUID, "", methodName, "GUID");
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        if (linkingEntities == null || CollectionUtils.isEmpty((Collection)linkingEntities.getRelationships())) {
            throw new AssetCatalogException(AssetCatalogErrorCode.LINKING_RELATIONSHIPS_NOT_FOUND.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        return this.assetCatalogConverter.convertRelationships(linkingEntities.getRelationships());
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship> getRelationships(String userId, String assetGUID, String assetTypeName, String relationshipTypeName, Integer from, Integer pageSize) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String methodName = "getRelationships";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "GUID", methodName);
        this.invalidParameterHandler.validatePaging(from.intValue(), pageSize.intValue(), methodName);
        String relationshipTypeGUID = this.commonHandler.getTypeDefGUID(userId, relationshipTypeName);
        List pagedRelationshipsByType = this.repositoryHandler.getPagedRelationshipsByType(userId, assetGUID, assetTypeName, relationshipTypeGUID, relationshipTypeName, from.intValue(), pageSize.intValue(), methodName);
        if (CollectionUtils.isNotEmpty((Collection)pagedRelationshipsByType)) {
            return this.assetCatalogConverter.convertRelationships(pagedRelationshipsByType);
        }
        return Collections.emptyList();
    }

    public List<AssetCatalogBean> getIntermediateAssets(String userId, String startAssetGUID, String endAssetGUID) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AssetCatalogException {
        String methodName = "getIntermediateAssets";
        this.initialValidationStartEndAssetGUID(userId, startAssetGUID, endAssetGUID, methodName);
        OMRSMetadataCollection metadataCollection = this.commonHandler.getOMRSMetadataCollection();
        InstanceGraph linkingEntities = null;
        try {
            linkingEntities = metadataCollection.getLinkingEntities(userId, startAssetGUID, endAssetGUID, Collections.singletonList(InstanceStatus.ACTIVE), null);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException e) {
            this.errorHandler.handleRepositoryError(e, methodName);
        }
        catch (EntityNotKnownException e) {
            this.errorHandler.handleUnknownEntity((Throwable)e, startAssetGUID, "", methodName, "GUID");
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        if (linkingEntities == null || CollectionUtils.isEmpty((Collection)linkingEntities.getEntities())) {
            throw new AssetCatalogException(AssetCatalogErrorCode.LINKING_ASSETS_NOT_FOUND.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        return this.getAssetCatalogBeansAfterValidation(methodName, linkingEntities.getEntities());
    }

    public List<AssetCatalogBean> getEntitiesFromNeighborhood(String userId, String assetGUID, SearchParameters searchParameters) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AssetCatalogException {
        String methodName = "getEntitiesFromNeighborhood";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "GUID", methodName);
        this.invalidParameterHandler.validateObject((Object)searchParameters, "searchParameter", methodName);
        this.invalidParameterHandler.validatePaging(searchParameters.getFrom().intValue(), searchParameters.getPageSize().intValue(), methodName);
        InstanceGraph entityNeighborhood = this.getAssetNeighborhood(userId, assetGUID, searchParameters);
        List entities = entityNeighborhood.getEntities();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            throw new AssetCatalogException(AssetCatalogErrorCode.NO_ASSET_FROM_NEIGHBORHOOD_NOT_FOUND.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        return this.getAssetCatalogBeansAfterValidation(methodName, entities);
    }

    public List<Elements> searchByType(String userId, String searchCriteria, SearchParameters searchParameters) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, RepositoryErrorException {
        List<EntityDetail> result;
        String methodName = "searchByType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(userId, searchCriteria, methodName);
        this.invalidParameterHandler.validateObject((Object)searchParameters, "searchParameter", methodName);
        this.invalidParameterHandler.validatePaging(searchParameters.getFrom().intValue(), searchParameters.getPageSize().intValue(), methodName);
        if (CollectionUtils.isNotEmpty((Collection)searchParameters.getEntityTypes())) {
            List<String> typesFilter = this.commonHandler.getTypesGUID(userId, searchParameters.getEntityTypes());
            result = this.collectSearchedEntitiesByType(userId, searchCriteria, searchParameters, typesFilter);
        } else {
            result = this.collectSearchedEntitiesByType(userId, searchCriteria, searchParameters, this.defaultSearchTypes);
        }
        HashSet<Elements> searchResults = new HashSet<Elements>();
        for (EntityDetail entityDetail : result) {
            try {
                this.invalidParameterHandler.validateAssetInSupportedZone(entityDetail.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(entityDetail.getClassifications()), this.supportedZones, this.serverUserName, methodName);
                Elements elements = this.assetCatalogConverter.buildAssetElements(entityDetail);
                searchResults.add(elements);
            }
            catch (org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException e) {
                log.debug("This asset if a different zone: {}", (Object)entityDetail.getGUID());
            }
        }
        SequencingOrder sequencingOrder = searchParameters.getSequencingOrder();
        String sequencingProperty = searchParameters.getSequencingProperty();
        ArrayList<Elements> results = new ArrayList<Elements>(searchResults);
        results.sort((firstAsset, secondAsset) -> this.orderElements((Elements)firstAsset, (Elements)secondAsset, sequencingProperty, sequencingOrder));
        return results;
    }

    public Elements buildContextByType(String userId, String entityGUID, String entityTypeDefName) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String methodName = "buildContextByType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        EntityDetail entityDetail = this.getEntity(userId, entityGUID, entityTypeDefName);
        if (entityDetail == null || entityDetail.getType() == null || entityDetail.getType().getTypeDefName() == null) {
            return null;
        }
        String typeDefName = entityDetail.getType().getTypeDefName();
        Set<String> superTypes = this.commonHandler.collectSuperTypes(userId, entityDetail.getType().getTypeDefName());
        AssetCatalogItemElement assetCatalogItemElement = new AssetCatalogItemElement();
        if (typeDefName.equals("GlossaryTerm")) {
            return this.getContextForGlossaryTerm(userId, entityDetail);
        }
        this.invalidParameterHandler.validateAssetInSupportedZone(entityDetail.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(entityDetail.getClassifications()), this.supportedZones, this.serverUserName, methodName);
        Elements elements = this.assetCatalogConverter.buildAssetElements(entityDetail);
        if (superTypes.contains("SchemaElement")) {
            this.getContextForSchemaElement(userId, entityDetail, assetCatalogItemElement);
        } else if (superTypes.contains("DeployedAPI")) {
            this.getContextForDeployedAPI(userId, entityDetail, assetCatalogItemElement);
        } else if (superTypes.contains("ITInfrastructure")) {
            this.getContextForInfrastructure(userId, entityDetail, assetCatalogItemElement);
        } else if (superTypes.contains("Process")) {
            this.getContextForProcess(userId, entityDetail, assetCatalogItemElement);
        } else if (superTypes.contains("DataStore")) {
            this.getContextForDataStore(userId, entityDetail, assetCatalogItemElement);
        } else if (superTypes.contains("DataSet")) {
            this.getContextForDataSet(userId, entityDetail, assetCatalogItemElement);
        }
        elements.setAssetCatalogItemElements(Collections.singletonList(assetCatalogItemElement));
        return elements;
    }

    public List<Type> getSupportedTypes(String userId, String typeName) {
        if (typeName != null && !typeName.isEmpty()) {
            return this.getSupportedTypesWithDescendants(userId, typeName);
        }
        return this.getSupportedTypes(userId, this.supportedTypesForSearch.toArray(new String[0]));
    }

    private List<AssetCatalogBean> getAssetCatalogBeansAfterValidation(String methodName, List<EntityDetail> entities) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        ArrayList<AssetCatalogBean> result = new ArrayList<AssetCatalogBean>();
        for (EntityDetail asset : entities) {
            this.invalidParameterHandler.validateAssetInSupportedZone(asset.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(asset.getClassifications()), this.supportedZones, this.serverUserName, methodName);
            result.add(this.assetCatalogConverter.getAssetCatalogBean(asset));
        }
        return result;
    }

    private EntityDetail getEntity(String userId, String assetGUID, String assetTypeName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntity";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "GUID", methodName);
        EntityDetail entityByGUID = this.commonHandler.getEntityByGUID(userId, assetGUID, assetTypeName);
        if (entityByGUID != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(entityByGUID.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(entityByGUID.getClassifications()), this.supportedZones, this.serverUserName, methodName);
        }
        return entityByGUID;
    }

    private void initialValidationStartEndAssetGUID(String userId, String startAssetGUID, String endAssetGUID, String methodName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startAssetGUID, "startAssetGUID", methodName);
        this.invalidParameterHandler.validateGUID(endAssetGUID, "endAssetGUID", methodName);
    }

    private List<EntityDetail> collectSearchedEntitiesByType(String userId, String searchCriteria, SearchParameters searchParameters, List<String> types) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, RepositoryErrorException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        OMRSMetadataCollection metadataCollection = this.commonHandler.getOMRSMetadataCollection();
        searchCriteria = searchParameters.getExactMatch() ? this.repositoryHelper.getExactMatchRegex(searchCriteria, searchParameters.getCaseInsensitive()) : this.repositoryHelper.getContainsRegex(searchCriteria, searchParameters.getCaseInsensitive());
        for (String type : types) {
            result.addAll(this.searchEntityByCriteria(userId, searchCriteria, type, searchParameters, metadataCollection));
        }
        return result;
    }

    private void getContextForSchemaElement(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.findAsset(userId, assetCatalogItemElement, entityDetail);
    }

    private Elements getContextForGlossaryTerm(String userId, EntityDetail glossaryTerm) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForGlossaryTerm";
        if (glossaryTerm == null) {
            return null;
        }
        Elements elements = this.assetCatalogConverter.buildAssetElements(glossaryTerm);
        List schemas = this.repositoryHandler.getEntitiesForRelationshipType(userId, glossaryTerm.getGUID(), "GlossaryTerm", "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", 0, 0, method);
        if (CollectionUtils.isEmpty((Collection)schemas)) {
            return elements;
        }
        ArrayList<AssetCatalogItemElement> assets = new ArrayList<AssetCatalogItemElement>(schemas.size());
        for (EntityDetail schema : schemas) {
            AssetCatalogItemElement assetCatalogItemElement = this.addSchemaForGlossaryTerm(userId, schema);
            assets.add(assetCatalogItemElement);
        }
        elements.setAssetCatalogItemElements(assets);
        return elements;
    }

    private AssetCatalogItemElement addSchemaForGlossaryTerm(String userId, EntityDetail schema) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AssetCatalogItemElement assetCatalogItemElement = new AssetCatalogItemElement();
        ArrayList<Elements> elements = new ArrayList<Elements>();
        elements.add(this.assetCatalogConverter.buildAssetElements(schema));
        assetCatalogItemElement.setContext(elements);
        this.findAsset(userId, assetCatalogItemElement, schema);
        return assetCatalogItemElement;
    }

    private void getContextForDeployedAPI(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForDeployedAPI";
        List endpoints = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "DeployedAPI", "de5b9501-3ad4-4803-a8b2-e311c72a4336", "APIEndpoint", 0, 0, method);
        if (CollectionUtils.isEmpty((Collection)endpoints)) {
            return;
        }
        for (EntityDetail endpoint : endpoints) {
            this.assetCatalogConverter.addContextElement(assetCatalogItemElement, endpoint);
            this.getConnectionContext(userId, endpoint, assetCatalogItemElement);
        }
    }

    private void getContextForInfrastructure(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        switch (entityDetail.getType().getTypeDefName()) {
            case "Host": {
                this.getContextForHost(userId, entityDetail, assetCatalogItemElement);
                break;
            }
            case "Network": {
                this.getContextForNetwork(userId, entityDetail, assetCatalogItemElement);
                break;
            }
            case "SoftwareServerPlatform": {
                this.getContextForSoftwareServerPlatform(userId, entityDetail, assetCatalogItemElement);
                break;
            }
            case "SoftwareServer": {
                this.getContextForSoftwareServer(userId, entityDetail, assetCatalogItemElement);
                break;
            }
        }
    }

    private void getContextForProcess(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForProcess";
        List ports = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "Process", "fB4E00CF-37e4-88CE-4a94-233BAdB84DA2", "ProcessPort", 0, 0, method);
        if (CollectionUtils.isNotEmpty((Collection)ports)) {
            for (EntityDetail port : ports) {
                EntityDetail schemaType;
                this.assetCatalogConverter.addContextElement(assetCatalogItemElement, port);
                if (!port.getType().getTypeDefName().equals("PortImplementation") || (schemaType = this.repositoryHandler.getEntityForRelationshipType(userId, port.getGUID(), "Database", "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", method)) == null) continue;
                this.assetCatalogConverter.addElement(assetCatalogItemElement, schemaType);
                this.getContextForSchemaType(userId, assetCatalogItemElement, schemaType);
            }
        }
    }

    private void getContextForDataStore(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        if (entityDetail.getType().getTypeDefName().equals("Database")) {
            this.getContextForDatabase(userId, entityDetail, assetCatalogItemElement);
        } else if (entityDetail.getType().getTypeDefName().equals("DataFile")) {
            this.getContextForDataFile(userId, entityDetail, assetCatalogItemElement);
        } else if (entityDetail.getType().getTypeDefName().equals("FileFolder")) {
            this.getContextForFileFolder(userId, entityDetail, assetCatalogItemElement);
        }
    }

    private void getContextForDatabase(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForDatabase";
        List dataSets = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "Database", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", 0, 0, method);
        if (dataSets != null && !dataSets.isEmpty()) {
            for (EntityDetail dataSet : dataSets) {
                this.getContextForDataSet(userId, dataSet, assetCatalogItemElement);
            }
        }
    }

    private void getContextForDataSet(String userId, EntityDetail dataSet, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForDataSet";
        EntityDetail schemaType = this.repositoryHandler.getEntityForRelationshipType(userId, dataSet.getGUID(), "DataSet", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", method);
        if (schemaType == null) {
            return;
        }
        this.assetCatalogConverter.addElement(assetCatalogItemElement, schemaType);
        if (this.isComplexSchemaType(schemaType.getType().getTypeDefName()).isPresent()) {
            this.getContextForSchemaType(userId, assetCatalogItemElement, schemaType);
        } else {
            this.getAsset(userId, assetCatalogItemElement, schemaType);
        }
    }

    private void getContextForFileFolder(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForFileFolder";
        List connections = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "FileFolder", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", 0, 0, method);
        if (CollectionUtils.isNotEmpty((Collection)connections)) {
            this.setConnections(userId, assetCatalogItemElement, entityDetail);
            return;
        }
        List parentFolderRelationships = this.repositoryHandler.getRelationshipsByType(userId, entityDetail.getGUID(), entityDetail.getType().getTypeDefName(), "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", method);
        if (CollectionUtils.isEmpty((Collection)parentFolderRelationships)) {
            return;
        }
        if ((parentFolderRelationships = parentFolderRelationships.stream().filter(s -> s.getEntityTwoProxy().getGUID().equals(entityDetail.getGUID())).collect(Collectors.toList())).size() != 1) {
            return;
        }
        EntityProxy parentFolderProxy = this.repositoryHandler.getOtherEnd(entityDetail.getGUID(), (Relationship)parentFolderRelationships.get(0));
        EntityDetail parentFolder = this.commonHandler.getEntityByGUID(userId, parentFolderProxy.getGUID(), parentFolderProxy.getType().getTypeDefName());
        this.assetCatalogConverter.addElement(assetCatalogItemElement, parentFolder);
        this.getContextForFileFolder(userId, parentFolder, assetCatalogItemElement);
    }

    private void getContextForEachParentFolder(String userId, AssetCatalogItemElement assetCatalogItemElement, List<EntityDetail> parentFolders) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        for (EntityDetail folder : parentFolders) {
            this.assetCatalogConverter.addElement(assetCatalogItemElement, folder);
            this.getContextForFileFolder(userId, folder, assetCatalogItemElement);
        }
    }

    private void getContextForDataFile(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForDataFile";
        List fileFolders = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "DataFile", "4cb88900-1446-4eb6-acea-29cd9da45e63", "NestedFile", 0, 0, method);
        if (CollectionUtils.isEmpty((Collection)fileFolders)) {
            return;
        }
        this.getContextForEachParentFolder(userId, assetCatalogItemElement, fileFolders);
    }

    private void getContextForSoftwareServerPlatform(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForSoftwareServerPlatform";
        EntityDetail host = this.repositoryHandler.getEntityForRelationshipType(userId, entityDetail.getGUID(), entityDetail.getType().getTypeDefName(), "b909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerPlatformDeployment", method);
        if (host != null) {
            this.assetCatalogConverter.addElement(assetCatalogItemElement, host);
            this.getContextForHost(userId, host, assetCatalogItemElement);
        }
    }

    private void getContextForNetwork(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForNetwork";
        List networkGateways = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "Network", "5bece460-1fa6-41fb-a29f-fdaf65ec8ce3", "NetworkGatewayLink", 0, 0, method);
        networkGateways.forEach(networkGateway -> this.assetCatalogConverter.addElement(assetCatalogItemElement, (EntityDetail)networkGateway));
        List hosts = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "Network", "f2bd7401-c064-41ac-862c-e5bcdc98fa1e", "HostNetwork", 0, 0, method);
        if (CollectionUtils.isNotEmpty((Collection)hosts)) {
            for (EntityDetail host : hosts) {
                this.assetCatalogConverter.addElement(assetCatalogItemElement, host);
                this.getContextForHost(userId, host, assetCatalogItemElement);
            }
        }
    }

    private void getContextForHost(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "getContextForHost";
        List hosts = null;
        if (entityDetail.getType().getTypeDefName().equals("VirtualContainer")) {
            hosts = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "Host", "4b981d89-e356-4d9b-8f17-b3a8d5a86676", "DeployedVirtualContainer", 0, 0, method);
        } else if (entityDetail.getType().getTypeDefName().equals("HostCluster")) {
            hosts = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "Host", "1a1c3933-a583-4b0c-9e42-c3691296a8e0", "HostClusterMember", 0, 0, method);
        }
        if (hosts != null) {
            hosts.forEach(host -> this.assetCatalogConverter.addElement(assetCatalogItemElement, (EntityDetail)host));
        }
        EntityDetail operatingPlatform = this.repositoryHandler.getEntityForRelationshipType(userId, entityDetail.getGUID(), entityDetail.getType().getTypeDefName(), "b9179df5-6e23-4581-a8b0-2919e6322b12", "HostOperatingPlatform", method);
        this.assetCatalogConverter.addElement(assetCatalogItemElement, operatingPlatform);
        List locations = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "Host", "f3066075-9611-4886-9244-32cc6eb07ea9", "HostLocation", 0, 0, method);
        if (CollectionUtils.isNotEmpty((Collection)locations)) {
            for (EntityDetail location : locations) {
                this.assetCatalogConverter.addElement(assetCatalogItemElement, location);
                this.getContextForLocation(userId, assetCatalogItemElement, location);
            }
        }
    }

    private void getContextForLocation(String userId, AssetCatalogItemElement assetCatalogItemElement, EntityDetail location) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        List nestedLocations;
        String method = "getContextForLocation";
        List assetLocations = this.repositoryHandler.getEntitiesForRelationshipType(userId, location.getGUID(), "Location", "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", 0, 0, method);
        if (CollectionUtils.isNotEmpty((Collection)assetLocations)) {
            for (EntityDetail assetLocation : assetLocations) {
                this.assetCatalogConverter.addElement(assetCatalogItemElement, assetLocation);
                this.getAsset(userId, assetCatalogItemElement, assetLocation);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(nestedLocations = this.repositoryHandler.getEntitiesForRelationshipType(userId, location.getGUID(), "Location", "f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", 0, 0, method)))) {
            for (EntityDetail nestedLocation : nestedLocations) {
                this.assetCatalogConverter.addElement(assetCatalogItemElement, nestedLocation);
                this.getContextForLocation(userId, assetCatalogItemElement, nestedLocation);
            }
        }
    }

    private void getContextForSoftwareServer(String userId, EntityDetail entityDetail, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        EntityDetail endpoint;
        String method = "getContextForSoftwareServer";
        Element parentElement = null;
        EntityDetail softwareServerPlatform = this.repositoryHandler.getEntityForRelationshipType(userId, entityDetail.getGUID(), "SoftwareServer", "d909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerDeployment", method);
        if (softwareServerPlatform != null) {
            parentElement = this.assetCatalogConverter.getLastNode(assetCatalogItemElement);
            this.assetCatalogConverter.addElement(assetCatalogItemElement, softwareServerPlatform);
            this.getContextForSoftwareServerPlatform(userId, softwareServerPlatform, assetCatalogItemElement);
        }
        if ((endpoint = this.repositoryHandler.getEntityForRelationshipType(userId, entityDetail.getGUID(), "SoftwareServer", "2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", method)) != null) {
            if (parentElement != null) {
                this.assetCatalogConverter.addChildElement(parentElement, (Element)this.assetCatalogConverter.buildAssetElements(endpoint));
            } else {
                this.assetCatalogConverter.addContextElement(assetCatalogItemElement, endpoint);
            }
            this.getConnectionContext(userId, endpoint, assetCatalogItemElement);
        }
    }

    private void getConnectionContext(String userId, EntityDetail endpoint, AssetCatalogItemElement assetCatalogItemElement) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String methodName = "getConnectionContext";
        List connections = this.repositoryHandler.getEntitiesForRelationshipType(userId, endpoint.getGUID(), "Endpoint", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", 0, 0, methodName);
        if (CollectionUtils.isEmpty((Collection)connections)) {
            return;
        }
        for (EntityDetail connection : connections) {
            this.assetCatalogConverter.addElement(assetCatalogItemElement, connection);
            ArrayList<EntityDetail> elements = new ArrayList<EntityDetail>();
            EntityDetail connectorType = this.repositoryHandler.getEntityForRelationshipType(userId, connection.getGUID(), "Connection", "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", methodName);
            if (connectorType != null) {
                elements.add(connectorType);
            }
            EntityDetail asset = this.repositoryHandler.getEntityForRelationshipType(userId, connection.getGUID(), "Connection", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
            this.invalidParameterHandler.validateAssetInSupportedZone(asset.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(asset.getClassifications()), this.supportedZones, this.serverUserName, methodName);
            elements.add(asset);
            elements.forEach(element -> this.assetCatalogConverter.addElement(assetCatalogItemElement, (EntityDetail)element));
        }
    }

    private void findAsset(String userId, AssetCatalogItemElement assetCatalogItemElement, EntityDetail ... entitiesByType) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String method = "findAsset";
        for (EntityDetail entityDetail : entitiesByType) {
            List schemaAttributes = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "SchemaAttribute", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", 0, 0, method);
            if (CollectionUtils.isEmpty((Collection)schemaAttributes) && CollectionUtils.isEmpty((Collection)(schemaAttributes = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", 0, 0, method)))) continue;
            this.addSchemaAttributes(assetCatalogItemElement, schemaAttributes);
            for (EntityDetail schemaAttribute : schemaAttributes) {
                if (!this.processSchemaAttribute(userId, assetCatalogItemElement, method, schemaAttribute)) continue;
                return;
            }
        }
    }

    private boolean processSchemaAttribute(String userId, AssetCatalogItemElement assetCatalogItemElement, String method, EntityDetail schemaAttribute) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.isComplexSchemaType(schemaAttribute.getType().getTypeDefName()).isPresent()) {
            this.setAssetDetails(userId, assetCatalogItemElement, schemaAttribute);
            return true;
        }
        this.processPrimitiveSchema(userId, assetCatalogItemElement, method, schemaAttribute);
        return false;
    }

    private void processPrimitiveSchema(String userId, AssetCatalogItemElement assetCatalogItemElement, String method, EntityDetail schemaAttribute) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        List schemaAttributeTypeEntities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaAttribute.getGUID(), schemaAttribute.getType().getTypeDefName(), "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", 0, 0, method);
        if (CollectionUtils.isNotEmpty((Collection)schemaAttributeTypeEntities)) {
            schemaAttributeTypeEntities.forEach(schemaAttributeTypeEntity -> this.assetCatalogConverter.addElement(assetCatalogItemElement, (EntityDetail)schemaAttributeTypeEntity));
            this.findAsset(userId, assetCatalogItemElement, schemaAttributeTypeEntities.toArray(new EntityDetail[0]));
        } else {
            this.findAsset(userId, assetCatalogItemElement, schemaAttribute);
        }
    }

    private void addSchemaAttributes(AssetCatalogItemElement assetCatalogItemElement, List<EntityDetail> schemaAttributes) {
        Element lastNode = this.assetCatalogConverter.getLastNode(assetCatalogItemElement);
        schemaAttributes.forEach(schemaAttribute -> this.addNode(assetCatalogItemElement, lastNode, (EntityDetail)schemaAttribute));
    }

    private void addNode(AssetCatalogItemElement assetCatalogItemElement, Element lastNode, EntityDetail schemaAttribute) {
        if (lastNode == null) {
            this.assetCatalogConverter.addContextElement(assetCatalogItemElement, schemaAttribute);
        }
        this.assetCatalogConverter.addElement(assetCatalogItemElement, schemaAttribute);
    }

    private void getContextForSchemaType(String userId, AssetCatalogItemElement assetCatalogItemElement, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        Optional<TypeDef> isComplexSchemaType = this.isComplexSchemaType(entityDetail.getType().getTypeDefName());
        String method = "getContextForSchemaType";
        if (isComplexSchemaType.isPresent()) {
            this.setAssetDetails(userId, assetCatalogItemElement, entityDetail);
        } else {
            List attributeForSchemas = this.repositoryHandler.getEntitiesForRelationshipType(userId, entityDetail.getGUID(), entityDetail.getType().getTypeDefName(), "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", 0, 0, method);
            if (CollectionUtils.isEmpty((Collection)attributeForSchemas)) {
                return;
            }
            for (EntityDetail attributeForSchema : attributeForSchemas) {
                this.assetCatalogConverter.addElement(assetCatalogItemElement, attributeForSchema);
                if (this.isComplexSchemaType(attributeForSchema.getType().getTypeDefName()).isPresent()) {
                    this.setAssetDetails(userId, assetCatalogItemElement, attributeForSchema);
                    return;
                }
                List schemaAttributeTypeEntities = this.repositoryHandler.getEntitiesForRelationshipType(userId, attributeForSchema.getGUID(), attributeForSchema.getType().getTypeDefName(), "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", 0, 0, method);
                for (EntityDetail schema : schemaAttributeTypeEntities) {
                    this.assetCatalogConverter.addElement(assetCatalogItemElement, schema);
                    this.getContextForSchemaType(userId, assetCatalogItemElement, schema);
                }
            }
        }
    }

    private void setAssetDetails(String userId, AssetCatalogItemElement assetCatalogItemElement, EntityDetail entity) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "setAssetDetails";
        EntityDetail dataSet = this.repositoryHandler.getEntityForRelationshipType(userId, entity.getGUID(), entity.getType().getTypeDefName(), "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
        if (dataSet == null) {
            return;
        }
        try {
            this.invalidParameterHandler.validateAssetInSupportedZone(dataSet.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(dataSet.getClassifications()), this.supportedZones, this.serverUserName, methodName);
            if (assetCatalogItemElement.getContext() != null) {
                this.assetCatalogConverter.addElement(assetCatalogItemElement, dataSet);
            } else {
                assetCatalogItemElement.setContext(Collections.singletonList(this.assetCatalogConverter.buildAssetElements(dataSet)));
            }
            this.getAsset(userId, assetCatalogItemElement, dataSet);
        }
        catch (org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException e) {
            if (CollectionUtils.isNotEmpty((Collection)assetCatalogItemElement.getContext())) {
                assetCatalogItemElement.getContext().remove(assetCatalogItemElement.getContext().size() - 1);
            }
            log.debug("Asset is not in the supported zones {}", (Object)dataSet.getGUID());
        }
    }

    private void getAsset(String userId, AssetCatalogItemElement assetCatalogItemElement, EntityDetail dataSet) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (dataSet == null) {
            return;
        }
        String methodName = "getAsset";
        List assetToDataSetRelationships = this.repositoryHandler.getRelationshipsByType(userId, dataSet.getGUID(), dataSet.getType().getTypeDefName(), "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", methodName);
        if (CollectionUtils.isEmpty((Collection)assetToDataSetRelationships)) {
            return;
        }
        for (Relationship assetToDataSetRelationship : assetToDataSetRelationships) {
            EntityProxy entityOneProxy = assetToDataSetRelationship.getEntityOneProxy();
            if (entityOneProxy.getGUID().equals(dataSet.getGUID())) {
                this.setConnections(userId, assetCatalogItemElement, dataSet);
                continue;
            }
            EntityDetail asset = this.commonHandler.getEntityByGUID(userId, entityOneProxy.getGUID(), entityOneProxy.getType().getTypeDefName());
            if (asset == null) continue;
            this.invalidParameterHandler.validateAssetInSupportedZone(asset.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(asset.getClassifications()), this.supportedZones, this.serverUserName, methodName);
            this.assetCatalogConverter.addElement(assetCatalogItemElement, asset);
            this.setConnections(userId, assetCatalogItemElement, asset);
        }
    }

    private void setConnections(String userId, AssetCatalogItemElement assetCatalogItemElement, EntityDetail asset) throws UserNotAuthorizedException, PropertyServerException {
        List<Connection> connections = this.getConnections(userId, asset.getGUID());
        assetCatalogItemElement.setConnections(connections);
    }

    private Optional<TypeDef> isComplexSchemaType(String typeDefName) {
        if (this.repositoryHelper.getKnownTypeDefGallery() == null || CollectionUtils.isEmpty((Collection)this.repositoryHelper.getKnownTypeDefGallery().getTypeDefs())) {
            return Optional.empty();
        }
        ArrayList allTypes = this.repositoryHelper.getKnownTypeDefGallery().getTypeDefs();
        return allTypes.stream().filter(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType")).findAny();
    }

    private List<Connection> getConnections(String userId, String dataSetGuid) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnections";
        List connections = this.repositoryHandler.getEntitiesForRelationshipType(userId, dataSetGuid, "Connection", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", 0, 0, methodName);
        if (CollectionUtils.isNotEmpty((Collection)connections)) {
            ArrayList<Connection> connectionList = new ArrayList<Connection>();
            for (EntityDetail entityDetail : connections) {
                Connection connection = new Connection(entityDetail.getGUID(), this.repositoryHelper.getStringProperty(this.sourceName, "qualifiedName", entityDetail.getProperties(), methodName));
                connectionList.add(connection);
            }
            return connectionList;
        }
        return Collections.emptyList();
    }

    private List<Classification> getEntityClassifications(String userId, String assetId, String assetTypeName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityClassifications";
        EntityDetail entityDetails = this.commonHandler.getEntityByGUID(userId, assetId, assetTypeName);
        this.invalidParameterHandler.validateAssetInSupportedZone(entityDetails.getGUID(), "GUID", this.commonHandler.getAssetZoneMembership(entityDetails.getClassifications()), this.supportedZones, userId, methodName);
        return entityDetails.getClassifications();
    }

    private List<EntityDetail> searchEntityByCriteria(String userId, String searchCriteria, String entityTypeGUID, SearchParameters searchParameters, OMRSMetadataCollection metadataCollection) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, PropertyErrorException, TypeErrorException, PagingErrorException, RepositoryErrorException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        InstanceProperties matchProperties = new InstanceProperties();
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)searchCriteria);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
        if (this.commonHandler.hasDisplayName(userId, entityTypeGUID)) {
            matchProperties.setProperty("displayName", (InstancePropertyValue)primitivePropertyValue);
        } else {
            matchProperties.setProperty("name", (InstancePropertyValue)primitivePropertyValue);
        }
        List entitiesByPropertyValue = metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, MatchCriteria.ANY, searchParameters.getFrom().intValue(), Collections.singletonList(InstanceStatus.ACTIVE), searchParameters.getLimitResultsByClassification(), null, searchParameters.getSequencingProperty(), searchParameters.getSequencingOrder() == null ? SequencingOrder.ANY : searchParameters.getSequencingOrder(), searchParameters.getPageSize().intValue());
        if (CollectionUtils.isNotEmpty((Collection)entitiesByPropertyValue)) {
            return entitiesByPropertyValue;
        }
        return new ArrayList<EntityDetail>();
    }

    private List<Classification> filterClassificationByName(List<Classification> classifications, String classificationName) {
        return classifications.stream().filter(classification -> classification.getName().equals(classificationName)).collect(Collectors.toList());
    }

    private InstanceGraph getAssetNeighborhood(String userId, String entityGUID, SearchParameters searchParameters) throws AssetCatalogException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException {
        OMRSMetadataCollection metadataCollection = this.commonHandler.getOMRSMetadataCollection();
        InstanceGraph entityNeighborhood = null;
        String methodName = "getAssetNeighborhood";
        try {
            entityNeighborhood = metadataCollection.getEntityNeighborhood(userId, entityGUID, this.commonHandler.getTypesGUID(userId, searchParameters.getEntityTypes()), searchParameters.getRelationshipTypeGUIDs(), Collections.singletonList(InstanceStatus.ACTIVE), searchParameters.getLimitResultsByClassification(), null, searchParameters.getLevel().intValue());
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException e) {
            this.errorHandler.handleRepositoryError(e, methodName);
        }
        catch (EntityNotKnownException e) {
            this.errorHandler.handleUnknownEntity((Throwable)e, entityGUID, (String)searchParameters.getEntityTypes().get(0), methodName, "GUID");
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName);
        }
        if (entityNeighborhood == null) {
            throw new AssetCatalogException(AssetCatalogErrorCode.ASSET_NEIGHBORHOOD_NOT_FOUND.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        return entityNeighborhood;
    }

    private List<Type> getSupportedTypesWithDescendants(String userId, String ... supportedTypesForSearch) {
        ArrayList<Type> response = new ArrayList<Type>();
        for (String type : supportedTypesForSearch) {
            List<Type> typeContext = this.commonHandler.getTypeContext(userId, type);
            response.addAll(typeContext);
        }
        return response;
    }

    private List<Type> getSupportedTypes(String userId, String ... supportedTypesForSearch) {
        ArrayList<Type> response = new ArrayList<Type>();
        for (String typeName : supportedTypesForSearch) {
            Type type = this.commonHandler.getTypeByTypeDefName(userId, typeName);
            if (type == null) continue;
            response.add(type);
        }
        return response;
    }

    private int orderElements(Elements firstAsset, Elements secondAsset, String sequencingProperty, SequencingOrder sequencingOrder) {
        String secondField;
        String firstField;
        if ("type".equals(sequencingProperty)) {
            if (firstAsset.getType() == null || secondAsset.getType() == null) {
                return 0;
            }
            firstField = firstAsset.getType().getName();
            secondField = secondAsset.getType().getName();
        } else {
            if (firstAsset.getProperties() == null || secondAsset.getProperties() == null) {
                return 0;
            }
            firstField = (String)firstAsset.getProperties().get(sequencingProperty);
            secondField = (String)secondAsset.getProperties().get(sequencingProperty);
            if ("displayName".equals(sequencingProperty)) {
                if (firstField == null) {
                    firstField = (String)firstAsset.getProperties().get("name");
                }
                if (secondField == null) {
                    secondField = (String)secondAsset.getProperties().get("name");
                }
            }
        }
        return this.compareFields(firstField, secondField, sequencingOrder);
    }

    private int compareFields(String firstComparedProperty, String secondComparedProperty, SequencingOrder sequencingOrder) {
        if (firstComparedProperty != null && secondComparedProperty != null) {
            if (sequencingOrder == SequencingOrder.PROPERTY_ASCENDING) {
                return firstComparedProperty.toLowerCase().compareTo(secondComparedProperty.toLowerCase());
            }
            if (sequencingOrder == SequencingOrder.PROPERTY_DESCENDING) {
                return secondComparedProperty.toLowerCase().compareTo(firstComparedProperty.toLowerCase());
            }
        }
        if (firstComparedProperty == null && secondComparedProperty != null) {
            return 1;
        }
        if (firstComparedProperty != null && secondComparedProperty == null) {
            return -1;
        }
        return 0;
    }
}

