/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.publishers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCatalogSearchPublisher {
    private static final Logger log = LoggerFactory.getLogger(AssetCatalogSearchPublisher.class);
    private final OpenMetadataTopicConnector topicConnector;

    public AssetCatalogSearchPublisher(OpenMetadataTopicConnector outTopicConnector) {
        this.topicConnector = outTopicConnector;
    }

    public void publishEvent(Serializable event) {
        try {
            if (this.topicConnector != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                this.topicConnector.sendEvent(objectMapper.writeValueAsString((Object)event));
            } else {
                log.error("Cannot publish event: topic connector is null!");
            }
        }
        catch (JsonProcessingException e) {
            log.error("Unable to create json for publishing: " + event.toString(), (Throwable)e);
        }
        catch (Exception e) {
            log.error("Unable to publish new asset event", (Throwable)e);
        }
    }
}

