/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.admin;

import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.admin.AssetCatalogServicesInstance;
import org.odpi.openmetadata.accessservices.assetcatalog.auditlog.AssetCatalogAuditCode;
import org.odpi.openmetadata.accessservices.assetcatalog.listeners.AssetCatalogOMRSTopicListener;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetCatalogAdmin
extends AccessServiceAdmin {
    public static final String SUPPORTED_TYPES_FOR_SEARCH = "SupportedTypesForSearch";
    public static final String ENABLE_INDEX_EVENTS = "EnableIndexingEvents";
    private AuditLog auditLog;
    private String serverName;
    private AssetCatalogServicesInstance instance;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", AssetCatalogAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions(), accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
            List<String> supportedTypesForSearch = this.getSupportedTypesForSearchOption(accessServiceConfigurationProperties);
            this.instance = new AssetCatalogServicesInstance(repositoryConnector, supportedZones, auditLog, serverUserName, accessServiceConfigurationProperties.getAccessServiceName(), supportedTypesForSearch, accessServiceConfigurationProperties.getAccessServiceInTopic(), accessServiceConfigurationProperties.getAccessServiceOutTopic());
            boolean indexingEnabled = this.isIndexingEnabled(accessServiceConfigurationProperties);
            if (indexingEnabled) {
                this.registerListener(accessServiceConfigurationProperties, enterpriseOMRSTopicConnector, repositoryConnector, auditLog);
            }
            this.serverName = this.instance.getServerName();
            auditLog.logMessage("initialize", AssetCatalogAuditCode.SERVICE_INITIALIZED.getMessageDefinition(this.serverName));
        }
        catch (Exception error) {
            auditLog.logException("initialize", AssetCatalogAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage(), this.serverName), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.ASSET_CATALOG_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    private void registerListener(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog) throws OMAGConfigurationErrorException {
        Connection outTopicConnection = accessServiceConfigurationProperties.getAccessServiceOutTopic();
        String serviceName = accessServiceConfigurationProperties.getAccessServiceName();
        OpenMetadataTopicConnector outTopicConnector = super.getOutTopicEventBusConnector(outTopicConnection, accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
        List supportedZones = this.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions(), serviceName, auditLog);
        List<String> supportedTypesForSearch = this.getSupportedTypesForSearchOption(accessServiceConfigurationProperties);
        AssetCatalogOMRSTopicListener omrsTopicListener = new AssetCatalogOMRSTopicListener(serviceName, auditLog, outTopicConnector, repositoryConnector.getRepositoryHelper(), repositoryConnector.getRepositoryValidator(), this.serverName, supportedZones, supportedTypesForSearch);
        super.registerWithEnterpriseTopic(serviceName, this.serverName, enterpriseOMRSTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            this.auditLog.logMessage("shutdown", AssetCatalogAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
        }
    }

    private boolean isIndexingEnabled(AccessServiceConfig accessServiceConfigurationProperties) {
        if (accessServiceConfigurationProperties.getAccessServiceOptions() != null) {
            return accessServiceConfigurationProperties.getAccessServiceOptions().getOrDefault(ENABLE_INDEX_EVENTS, Boolean.FALSE);
        }
        return false;
    }

    private List<String> getSupportedTypesForSearchOption(AccessServiceConfig accessServiceConfigurationProperties) {
        Object supportedTypesProperty;
        if (accessServiceConfigurationProperties.getAccessServiceOptions() != null && (supportedTypesProperty = accessServiceConfigurationProperties.getAccessServiceOptions().get(SUPPORTED_TYPES_FOR_SEARCH)) instanceof List) {
            return (List)supportedTypesProperty;
        }
        return Collections.emptyList();
    }
}

