/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogBean;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogItemElement;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Element;
import org.odpi.openmetadata.accessservices.assetcatalog.model.ElementOrigin;
import org.odpi.openmetadata.accessservices.assetcatalog.model.ElementOriginCategory;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Elements;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Type;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetCatalogConverter {
    private String sourceName;
    private OMRSRepositoryHelper repositoryHelper;

    public AssetCatalogConverter(String sourceName, OMRSRepositoryHelper repositoryHelper) {
        this.sourceName = sourceName;
        this.repositoryHelper = repositoryHelper;
    }

    public AssetCatalogBean getAssetCatalogBean(EntityDetail entityDetail) {
        AssetCatalogBean assetCatalogBean = new AssetCatalogBean();
        assetCatalogBean.setGuid(entityDetail.getGUID());
        assetCatalogBean.setCreatedBy(entityDetail.getCreatedBy());
        assetCatalogBean.setCreateTime(entityDetail.getCreateTime());
        assetCatalogBean.setUpdatedBy(entityDetail.getUpdatedBy());
        assetCatalogBean.setUpdateTime(entityDetail.getUpdateTime());
        assetCatalogBean.setVersion(Long.valueOf(entityDetail.getVersion()));
        if (entityDetail.getType() != null && entityDetail.getType().getTypeDefName() != null) {
            assetCatalogBean.setType(this.convertInstanceType(entityDetail.getType()));
        }
        assetCatalogBean.setUrl(entityDetail.getInstanceURL());
        if (entityDetail.getStatus() != null && entityDetail.getStatus().getName() != null) {
            assetCatalogBean.setStatus(entityDetail.getStatus().getName());
        }
        assetCatalogBean.setProperties(this.extractProperties(entityDetail.getProperties()));
        assetCatalogBean.setAdditionalProperties(this.extractAdditionalProperties(entityDetail.getProperties()));
        if (CollectionUtils.isNotEmpty((Collection)entityDetail.getClassifications())) {
            assetCatalogBean.setClassifications(this.convertClassifications(entityDetail.getClassifications()));
        }
        ElementOrigin elementOrigin = new ElementOrigin();
        elementOrigin.setSourceServer(this.sourceName);
        elementOrigin.setMetadataCollectionId(entityDetail.getMetadataCollectionId());
        elementOrigin.setMetadataCollectionName(entityDetail.getMetadataCollectionName());
        elementOrigin.setInstanceLicense(entityDetail.getInstanceLicense());
        elementOrigin.setOriginCategory(this.getElementOriginCategory(entityDetail.getInstanceProvenanceType()));
        assetCatalogBean.setOrigin(elementOrigin);
        return assetCatalogBean;
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship> convertRelationships(List<Relationship> relationships) {
        if (relationships == null) {
            return Collections.emptyList();
        }
        return relationships.stream().map(this::convertRelationship).collect(Collectors.toList());
    }

    public org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship convertRelationship(Relationship rel) {
        org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship relationship = new org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship();
        relationship.setGuid(rel.getGUID());
        relationship.setCreatedBy(rel.getCreatedBy());
        relationship.setCreateTime(rel.getCreateTime());
        relationship.setUpdatedBy(rel.getUpdatedBy());
        relationship.setUpdateTime(rel.getUpdateTime());
        relationship.setVersion(Long.valueOf(rel.getVersion()));
        if (rel.getStatus() != null && rel.getStatus().getName() != null) {
            relationship.setStatus(rel.getStatus().getName());
        }
        if (rel.getType() != null && rel.getType().getTypeDefName() != null) {
            relationship.setType(this.convertInstanceType(rel.getType()));
        }
        if (rel.getEntityOneProxy() != null) {
            relationship.setFromEntity(this.getElement(rel.getEntityOneProxy()));
        }
        if (rel.getEntityTwoProxy() != null) {
            relationship.setToEntity(this.getElement(rel.getEntityTwoProxy()));
        }
        return relationship;
    }

    public List<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification> convertClassifications(List<Classification> classificationsFromEntity) {
        if (classificationsFromEntity == null || classificationsFromEntity.isEmpty()) {
            return new ArrayList<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification>();
        }
        ArrayList<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification> classifications = new ArrayList<org.odpi.openmetadata.accessservices.assetcatalog.model.Classification>(classificationsFromEntity.size());
        for (Classification classificationEntity : classificationsFromEntity) {
            org.odpi.openmetadata.accessservices.assetcatalog.model.Classification classification = new org.odpi.openmetadata.accessservices.assetcatalog.model.Classification();
            classification.setName(classificationEntity.getName());
            if (classificationEntity.getClassificationOrigin() != null && classificationEntity.getClassificationOrigin().getDescription() != null) {
                classification.setOrigin(classificationEntity.getClassificationOrigin().getDescription());
            }
            classification.setOriginGUID(classificationEntity.getClassificationOriginGUID());
            classification.setCreatedBy(classificationEntity.getCreatedBy());
            classification.setCreateTime(classificationEntity.getCreateTime());
            classification.setUpdatedBy(classificationEntity.getUpdatedBy());
            classification.setUpdateTime(classificationEntity.getUpdateTime());
            classification.setVersion(Long.valueOf(classificationEntity.getVersion()));
            if (classificationEntity.getStatus() != null) {
                classification.setStatus(classificationEntity.getStatus().getName());
            }
            if (classificationEntity.getType() != null) {
                classification.setType(this.convertInstanceType(classificationEntity.getType()));
            }
            classification.setProperties(this.extractProperties(classificationEntity.getProperties()));
            classifications.add(classification);
        }
        return classifications;
    }

    public void addElement(AssetCatalogItemElement assetCatalogItemElement, EntityDetail entityDetail) {
        List context = assetCatalogItemElement.getContext();
        Elements element = this.buildAssetElements(entityDetail);
        if (context != null) {
            Element leaf = this.lastElementAdded((Element)context.get(context.size() - 1));
            leaf.setParentElement((Element)element);
        } else {
            ArrayList<Elements> elements = new ArrayList<Elements>();
            elements.add(element);
            assetCatalogItemElement.setContext(elements);
        }
    }

    public Element getLastNode(AssetCatalogItemElement assetCatalogItemElement) {
        List context = assetCatalogItemElement.getContext();
        return CollectionUtils.isNotEmpty((Collection)context) ? this.lastElementAdded((Element)context.get(context.size() - 1)) : null;
    }

    public void addChildElement(Element parentElement, Element element) {
        if (parentElement != null) {
            parentElement.setParentElement(element);
        }
    }

    public void addContextElement(AssetCatalogItemElement assetCatalogItemElement, EntityDetail entityDetail) {
        ArrayList<Elements> context = assetCatalogItemElement.getContext();
        if (context == null) {
            context = new ArrayList<Elements>();
        }
        context.add(this.buildAssetElements(entityDetail));
        assetCatalogItemElement.setContext(context);
    }

    public Type convertType(TypeDef openType) {
        Type type = new Type();
        type.setName(openType.getName());
        type.setDescription(openType.getDescription());
        type.setVersion(Long.valueOf(openType.getVersion()));
        type.setSuperType(openType.getSuperType().getName());
        return type;
    }

    public Elements buildAssetElements(EntityDetail entityDetail) {
        if (entityDetail == null) {
            return null;
        }
        Elements element = new Elements();
        element.setGuid(entityDetail.getGUID());
        element.setType(this.convertInstanceType(entityDetail.getType()));
        element.setProperties(this.extractProperties(entityDetail.getProperties()));
        element.setAdditionalProperties(this.extractAdditionalProperties(entityDetail.getProperties()));
        ElementOrigin elementOrigin = new ElementOrigin();
        elementOrigin.setSourceServer(this.sourceName);
        elementOrigin.setMetadataCollectionId(entityDetail.getMetadataCollectionId());
        elementOrigin.setMetadataCollectionName(entityDetail.getMetadataCollectionName());
        elementOrigin.setInstanceLicense(entityDetail.getInstanceLicense());
        elementOrigin.setOriginCategory(this.getElementOriginCategory(entityDetail.getInstanceProvenanceType()));
        element.setOrigin(elementOrigin);
        if (CollectionUtils.isNotEmpty((Collection)entityDetail.getClassifications())) {
            element.setClassifications(this.convertClassifications(entityDetail.getClassifications()));
        }
        return element;
    }

    private Type convertInstanceType(InstanceType instanceType) {
        Type type = new Type();
        type.setName(instanceType.getTypeDefName());
        type.setDescription(instanceType.getTypeDefDescription());
        type.setVersion(Long.valueOf(instanceType.getTypeDefVersion()));
        return type;
    }

    private Element getElement(EntityProxy entityProxy) {
        String method = "getAsset";
        Element asset = new Element();
        asset.setGuid(entityProxy.getGUID());
        if (entityProxy.getUniqueProperties() != null) {
            asset.setName(this.repositoryHelper.getStringProperty(this.sourceName, "name", entityProxy.getUniqueProperties(), method));
        }
        asset.setCreatedBy(entityProxy.getCreatedBy());
        asset.setCreateTime(entityProxy.getCreateTime());
        asset.setUpdatedBy(entityProxy.getUpdatedBy());
        asset.setUpdateTime(entityProxy.getUpdateTime());
        asset.setStatus(entityProxy.getStatus().getName());
        asset.setVersion(Long.valueOf(entityProxy.getVersion()));
        asset.setType(this.convertInstanceType(entityProxy.getType()));
        if (CollectionUtils.isNotEmpty((Collection)entityProxy.getClassifications())) {
            asset.setClassifications(this.convertClassifications(entityProxy.getClassifications()));
        }
        return asset;
    }

    private Element lastElementAdded(Element tree) {
        Element innerElement = tree.getParentElement();
        if (innerElement == null) {
            return tree;
        }
        return this.lastElementAdded(innerElement);
    }

    private Map<String, String> extractProperties(InstanceProperties instanceProperties) {
        Map instancePropertiesAsMap = this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties);
        HashMap<String, String> properties = new HashMap<String, String>();
        String methodName = "extractProperties";
        if (MapUtils.isNotEmpty((Map)instancePropertiesAsMap)) {
            instancePropertiesAsMap.forEach((key, value) -> {
                if (!key.equals("additionalProperties")) {
                    if (value instanceof ArrayPropertyValue) {
                        List stringArrayProperty = this.repositoryHelper.getStringArrayProperty(this.sourceName, key, instanceProperties, methodName);
                        properties.put((String)key, this.listToString(stringArrayProperty));
                    } else if (value instanceof MapPropertyValue) {
                        Map mapProperty = this.repositoryHelper.getMapFromProperty(this.sourceName, key, instanceProperties, methodName);
                        properties.put((String)key, this.mapToString(mapProperty));
                    } else {
                        properties.put((String)key, String.valueOf(value));
                    }
                }
            });
        }
        return properties;
    }

    private Map<String, String> extractAdditionalProperties(InstanceProperties instanceProperties) {
        String methodName = "extractAdditionalProperties";
        return MapUtils.emptyIfNull((Map)this.repositoryHelper.removeStringMapFromProperty(this.sourceName, "additionalProperties", instanceProperties, methodName));
    }

    private String listToString(List<String> list) {
        return String.join((CharSequence)",", list);
    }

    private String mapToString(Map<String, Object> map) {
        return map.keySet().stream().map(key -> key + ": " + map.get(key)).collect(Collectors.joining(", "));
    }

    private ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOriginCategory.UNKNOWN;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }
}

