/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.connectors.outtopic.AssetCatalogOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.AssetCatalogHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.RelationshipHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class AssetCatalogServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.ASSET_CATALOG_OMAS;
    private final AssetCatalogHandler assetCatalogHandler;
    private final RelationshipHandler relationshipHandler;

    AssetCatalogServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String serverUserName, String sourceName, List<String> supportedTypesForSearch, Connection inTopicEventBusConnection, Connection outTopicEventBusConnection) throws NewInstanceException {
        super(description.getAccessServiceName() + " OMAS", repositoryConnector, supportedZones, null, null, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), null, null, AssetCatalogOutTopicClientProvider.class.getName(), outTopicEventBusConnection);
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(AssetCatalogErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.assetCatalogHandler = new AssetCatalogHandler(this.serverName, sourceName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler, supportedZones, supportedTypesForSearch);
        CommonHandler commonHandler = new CommonHandler(sourceName, this.repositoryHandler, this.repositoryHelper, this.errorHandler);
        this.relationshipHandler = new RelationshipHandler(sourceName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler, commonHandler);
    }

    public AssetCatalogHandler getAssetCatalogHandler() {
        return this.assetCatalogHandler;
    }

    public RelationshipHandler getRelationshipHandler() {
        return this.relationshipHandler;
    }
}

