/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.handlers;

import org.odpi.openmetadata.accessservices.assetcatalog.builders.AssetCatalogConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.CommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelationshipHandler {
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RepositoryErrorHandler errorHandler;
    private final String sourceName;
    private CommonHandler commonHandler;

    public RelationshipHandler(String sourceName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, RepositoryErrorHandler errorHandler, CommonHandler commonHandler) {
        this.sourceName = sourceName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.errorHandler = errorHandler;
        this.commonHandler = commonHandler;
    }

    public org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship getRelationshipBetweenEntities(String userId, String serverName, String entity1GUID, String entity2GUID, String relationshipType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String entity1TypeName;
        Relationship relationshipBetweenEntities;
        EntityDetail entityDetail1;
        String methodName = "getRelationshipBetweenEntities";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipBetweenEntities");
        this.invalidParameterHandler.validateGUID(entity1GUID, "entity1GUID", "getRelationshipBetweenEntities");
        this.invalidParameterHandler.validateGUID(entity2GUID, "entity2GUID", "getRelationshipBetweenEntities");
        String relationshipTypeGUID = null;
        if (relationshipType != null) {
            relationshipTypeGUID = this.commonHandler.getTypeDefGUID(userId, relationshipType);
        }
        if ((entityDetail1 = this.commonHandler.getEntityByGUID(userId, entity1GUID, null)) == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, entity1GUID, "-unknown-", this.sourceName, serverName, "getRelationshipBetweenEntities");
        }
        if ((relationshipBetweenEntities = this.repositoryHandler.getRelationshipBetweenEntities(userId, entity1GUID, entity1TypeName = entityDetail1.getType().getTypeDefName(), entity2GUID, relationshipTypeGUID, relationshipType, "getRelationshipBetweenEntities")) != null) {
            AssetCatalogConverter converter = new AssetCatalogConverter(this.sourceName, this.repositoryHelper);
            return converter.convertRelationship(relationshipBetweenEntities);
        }
        return null;
    }
}

