/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetcatalog.converters.AssetCatalogConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogBean;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Type;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CommonHandler {
    public static final String ZONE_MEMBERSHIP = "zoneMembership";
    public static final String NONE = "none";
    private final String sourceName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final OpenMetadataAPIGenericHandler<AssetCatalogBean> assetHandler;
    private final RepositoryErrorHandler errorHandler;

    CommonHandler(String sourceName, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, OpenMetadataAPIGenericHandler<AssetCatalogBean> assetHandler, RepositoryErrorHandler errorHandler) {
        this.sourceName = sourceName;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.assetHandler = assetHandler;
        this.errorHandler = errorHandler;
    }

    OMRSMetadataCollection getOMRSMetadataCollection() {
        return this.repositoryHandler.getMetadataCollection();
    }

    List<Type> getTypeContext(String userId, String typeDefName) {
        ArrayList<Type> response = new ArrayList<Type>();
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        AssetCatalogConverter converter = new AssetCatalogConverter(this.repositoryHelper, this.sourceName, this.assetHandler.getServerName());
        if (typeDefByName != null) {
            if (this.repositoryHelper.getKnownTypeDefGallery() == null || CollectionUtils.isEmpty((Collection)this.repositoryHelper.getKnownTypeDefGallery().getTypeDefs())) {
                return response;
            }
            ArrayList typeDefs = this.repositoryHelper.getKnownTypeDefGallery().getTypeDefs();
            Type type = converter.convertType(typeDefByName);
            List<Type> subTypes = this.getSubTypes(typeDefs, type);
            response.add(type);
            response.addAll(subTypes);
            this.collectSubTypes(subTypes, typeDefs, response);
            response.sort(Comparator.comparing(Type::getName));
        }
        return response;
    }

    Type getTypeByTypeDefName(String userId, String typeDefName) {
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        AssetCatalogConverter converter = new AssetCatalogConverter(this.repositoryHelper, this.sourceName, this.assetHandler.getServerName());
        if (typeDefByName != null) {
            return converter.convertType(typeDefByName);
        }
        return null;
    }

    public String getTypeDefGUID(String userId, String typeDefName) {
        if (typeDefName == null) {
            return null;
        }
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        return Optional.ofNullable(typeDefByName).map(TypeDefLink::getGUID).orElse(null);
    }

    public boolean hasDisplayName(String userId, String typeDefGUID) throws InvalidParameterException {
        String methodName = "hasDisplayName";
        TypeDef typeDefByName = null;
        try {
            typeDefByName = this.repositoryHelper.getTypeDef(userId, "GUID", typeDefGUID, methodName);
        }
        catch (TypeErrorException typeErrorException) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)typeErrorException), methodName, "GUID");
        }
        List allPropertiesForTypeDef = this.repositoryHelper.getAllPropertiesForTypeDef(this.sourceName, typeDefByName, methodName);
        if (allPropertiesForTypeDef == null) {
            return false;
        }
        return allPropertiesForTypeDef.stream().anyMatch(property -> property.getAttributeName().equals("displayName"));
    }

    List<String> getAssetZoneMembership(List<Classification> classifications) {
        List zoneMembership;
        String methodName = "getAssetZoneMembership";
        if (CollectionUtils.isEmpty(classifications)) {
            return Collections.emptyList();
        }
        Optional<Classification> assetZoneMembership = this.getAssetZoneMembershipClassification(classifications);
        if (assetZoneMembership.isPresent() && CollectionUtils.isNotEmpty((Collection)(zoneMembership = this.repositoryHelper.getStringArrayProperty(this.sourceName, ZONE_MEMBERSHIP, assetZoneMembership.get().getProperties(), methodName)))) {
            return zoneMembership;
        }
        return Collections.emptyList();
    }

    EntityDetail getEntityByGUID(String userId, String guid, String type) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String entityTypeName = type;
        if (NONE.equals(type)) {
            entityTypeName = null;
        }
        String methodName = "getEntityByGUID";
        return this.assetHandler.getEntityFromRepository(userId, guid, "GUID", entityTypeName, null, null, false, false, null, methodName);
    }

    List<String> getTypesGUID(String userId, List<String> types) {
        if (CollectionUtils.isEmpty(types)) {
            return Collections.emptyList();
        }
        return types.stream().map(type -> this.repositoryHelper.getTypeDefByName(userId, type)).filter(Objects::nonNull).map(TypeDefLink::getGUID).collect(Collectors.toList());
    }

    Map<String, String> getTypesAndGUIDs(String userId, List<String> types) {
        if (CollectionUtils.isEmpty(types)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> typesAndGUIDs = new HashMap<String, String>();
        for (String type : types) {
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(userId, type);
            String typeDefGUID = null;
            if (typeDef != null) {
                typeDefGUID = typeDef.getGUID();
            }
            typesAndGUIDs.put(type, typeDefGUID);
        }
        return typesAndGUIDs;
    }

    private void collectSubTypes(List<Type> types, List<TypeDef> activeTypeDefs, List<Type> collector) {
        for (Type currentSubType : types) {
            List<Type> subTypes = this.getSubTypes(activeTypeDefs, currentSubType);
            collector.addAll(subTypes);
            this.collectSubTypes(subTypes, activeTypeDefs, collector);
        }
    }

    private List<Type> getSubTypes(List<TypeDef> activeTypeDefs, Type type) {
        String typeName = type.getName();
        AssetCatalogConverter converter = new AssetCatalogConverter(this.repositoryHelper, this.sourceName, this.assetHandler.getServerName());
        ArrayList<Type> subTypes = new ArrayList<Type>();
        for (TypeDef typeDef : activeTypeDefs) {
            if (typeDef.getSuperType() == null || !typeDef.getSuperType().getName().equals(typeName)) continue;
            subTypes.add(converter.convertType(typeDef));
        }
        return subTypes;
    }

    private Optional<Classification> getAssetZoneMembershipClassification(List<Classification> classifications) {
        return classifications.stream().filter(classification -> classification.getName().equals("AssetZoneMembership")).findFirst();
    }

    Set<String> collectSuperTypes(String userId, String typeDefName) {
        HashSet<String> superTypes = new HashSet<String>();
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
        return superTypes;
    }

    private void collectSuperTypes(String userId, TypeDef type, Set<String> superTypes) {
        if (type.getName().equals("Referenceable")) {
            return;
        }
        superTypes.add(type.getName());
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, type.getSuperType().getName());
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
    }
}

