/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.handlers;

import org.odpi.openmetadata.accessservices.assetcatalog.converters.AssetCatalogConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogBean;
import org.odpi.openmetadata.accessservices.assetcatalog.service.ClockService;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelationshipHandler {
    private static final String ENTITY_1_GUID_PARAMETER = "entity1GUID";
    private static final String ENTITY_2_GUID_PARAMETER = "entity2GUID";
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final OpenMetadataAPIGenericHandler<AssetCatalogBean> assetHandler;
    private final CommonHandler commonHandler;
    private final ClockService clockService;
    private final String sourceName;

    public RelationshipHandler(String sourceName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, OpenMetadataAPIGenericHandler<AssetCatalogBean> assetHandler, RepositoryErrorHandler errorHandler, ClockService clockService) {
        this.sourceName = sourceName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.assetHandler = assetHandler;
        this.commonHandler = new CommonHandler(sourceName, repositoryHandler, repositoryHelper, assetHandler, errorHandler, clockService);
        this.clockService = clockService;
    }

    public org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship getRelationshipBetweenEntities(String userId, String serverName, String entity1GUID, String entity2GUID, String relationshipType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship relationshipBetweenEntities;
        String methodName = "getRelationshipBetweenEntities";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipBetweenEntities");
        this.invalidParameterHandler.validateGUID(entity1GUID, ENTITY_1_GUID_PARAMETER, "getRelationshipBetweenEntities");
        this.invalidParameterHandler.validateGUID(entity2GUID, ENTITY_2_GUID_PARAMETER, "getRelationshipBetweenEntities");
        String relationshipTypeGUID = null;
        if (relationshipType != null) {
            relationshipTypeGUID = this.commonHandler.getTypeDefGUID(userId, relationshipType);
        }
        if ((relationshipBetweenEntities = this.assetHandler.getUniqueAttachmentLink(userId, entity1GUID, "GUID", "", relationshipTypeGUID, relationshipType, entity2GUID, "", 0, false, false, this.clockService.getNow(), "getRelationshipBetweenEntities")) != null) {
            AssetCatalogConverter converter = new AssetCatalogConverter(this.repositoryHelper, serverName, this.assetHandler.getServerName());
            return converter.convertRelationship(relationshipBetweenEntities);
        }
        return null;
    }
}

