/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.listeners;

import java.io.Serializable;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.auditlog.AssetCatalogAuditCode;
import org.odpi.openmetadata.accessservices.assetcatalog.converters.AssetCatalogConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogBean;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogEvent;
import org.odpi.openmetadata.accessservices.assetcatalog.publishers.AssetCatalogSearchPublisher;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.AssetConverter;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCatalogOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(AssetCatalogOMRSTopicListener.class);
    private static final String ASSET_TYPE = "Asset";
    private final OMRSRepositoryHelper repositoryHelper;
    private final OMRSRepositoryValidator repositoryValidator;
    private final String serverName;
    private final List<String> supportedZones;
    private final List<String> supportedTypesForSearch;
    private final AssetCatalogSearchPublisher publisher;
    private final AssetCatalogConverter<AssetCatalogBean> converter;

    public AssetCatalogOMRSTopicListener(String serviceName, AuditLog auditLog, OpenMetadataTopicConnector outTopicConnector, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String serverName, List<String> supportedZones, List<String> supportedTypesForSearch) {
        super(serviceName, auditLog);
        this.publisher = new AssetCatalogSearchPublisher(outTopicConnector);
        this.serverName = serverName;
        this.supportedZones = supportedZones;
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.converter = new AssetCatalogConverter(repositoryHelper, serviceName, serverName);
        this.supportedTypesForSearch = supportedTypesForSearch;
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event: {}", (Object)instanceEvent);
        if (instanceEvent == null) {
            log.debug("Ignored instance event - null OMRSInstanceEvent");
            return;
        }
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        if (instanceEventOriginator == null) {
            log.debug("Ignored instance event - null OMRSEventOriginator");
            this.auditLog.logMessage("No instance origin. Event IGNORED!", AssetCatalogAuditCode.EVENT_NOT_PROCESSING.getMessageDefinition("no instance origin"));
            return;
        }
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        EntityDetail entityDetail = instanceEvent.getEntity();
        Relationship relationship = instanceEvent.getRelationship();
        try {
            switch (instanceEventType) {
                case UPDATED_ENTITY_EVENT: 
                case NEW_ENTITY_EVENT: 
                case DELETED_ENTITY_EVENT: 
                case CLASSIFIED_ENTITY_EVENT: 
                case RECLASSIFIED_ENTITY_EVENT: 
                case DECLASSIFIED_ENTITY_EVENT: {
                    if (entityDetail == null) break;
                    this.processEntityDetail(entityDetail);
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: 
                case UPDATED_RELATIONSHIP_EVENT: 
                case DELETED_RELATIONSHIP_EVENT: {
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("An exception occurred while processing OMRSTopic event: \n " + instanceEvent, (Throwable)e);
            this.logExceptionToAudit(instanceEvent, e);
        }
    }

    private void processRelationshipEvent(Relationship relationship) {
        this.publisher.publishEvent((Serializable)relationship);
    }

    private void processEntityDetail(EntityDetail entityDetail) {
        String assetType = this.getAssetType(entityDetail);
        if (assetType != null) {
            AssetConverter assetConverter = new AssetConverter(entityDetail, null, this.repositoryHelper, this.serviceName, this.serverName);
            Asset assetBean = assetConverter.getAssetBean();
            AssetCatalogEvent assetCatalogEvent = new AssetCatalogEvent();
            assetCatalogEvent.setAsset(assetBean);
            if (assetBean == null || !this.inTheZone(assetBean.getZoneMembership())) {
                log.debug("Ignored instance event - Asset not in the supported zones!");
                this.auditLog.logMessage("Ignored instance event - Asset not in the supported zones!!", AssetCatalogAuditCode.EVENT_NOT_PROCESSING.getMessageDefinition("Asset not in the supported zones!"));
                return;
            }
            this.publisher.publishEvent((Serializable)assetCatalogEvent);
        } else if (this.supportedTypesForSearch != null && this.supportedTypesForSearch.contains(entityDetail.getType().getTypeDefName())) {
            AssetCatalogBean assetDescription = this.converter.getAssetCatalogBean(entityDetail);
            this.publisher.publishEvent((Serializable)assetDescription);
        }
    }

    private String getAssetType(EntityDetail entity) {
        InstanceType entityType;
        String methodName = "getAssetType";
        if (this.repositoryValidator.isATypeOf(this.serviceName, (InstanceAuditHeader)entity, ASSET_TYPE, "getAssetType") && (entityType = entity.getType()) != null) {
            return entityType.getTypeDefName();
        }
        return null;
    }

    private boolean inTheZone(List<String> assetZones) {
        if (this.supportedZones == null || assetZones == null) {
            return true;
        }
        return this.supportedZones.stream().anyMatch(assetZones::contains);
    }

    private void logExceptionToAudit(OMRSInstanceEvent instanceEvent, Exception e) {
        String actionDescription = "Asset Lineage OMAS is unable to process an OMRSTopic event.";
        this.auditLog.logException(actionDescription, AssetCatalogAuditCode.EVENT_PROCESSING_EXCEPTION.getMessageDefinition(e.getMessage(), instanceEvent.toString()), instanceEvent.toString(), (Throwable)e);
    }
}

