/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project */
package org.odpi.openmetadata.accessservices.assetcatalog.util;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * Constants for Open Metadata Types (names and guid)
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public final class Constants {

    /**
     * The Referenceable Open Metadata Type name
     */
    public static final String REFERENCEABLE = "Referenceable";

    /**
     * The AssetZoneMembership Open Metadata Type name
     */
    public static final String ASSET_ZONE_MEMBERSHIP = "AssetZoneMembership";

    /**
     * The Asset Open Metadata Type unique identifier
     */
    public static final String ASSET_GUID = "896d14c2-7522-4f6c-8519-757711943fe6";

    /**
     * The SchemaElement Open Metadata Type unique identifier
     */
    public static final String SCHEMA_ELEMENT_GUID = "718d4244-8559-49ed-ad5a-10e5c305a656";

    /**
     * The SchemaElement Open Metadata Type name
     */
    public static final String SCHEMA_ELEMENT = "SchemaElement";

    /**
     * The GlossaryTerm Open Metadata Type name
     */
    public static final String GLOSSARY_TERM = "GlossaryTerm";

    /**
     * The GlossaryTerm Open Metadata Type unique identifier
     */
    public static final String GLOSSARY_TERM_TYPE_GUID = "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a";

    /**
     * The ComplexSchemaType Open Metadata Type name
     */
    public static final String COMPLEX_SCHEMA_TYPE = "ComplexSchemaType";

    /**
     * The Asset Open Metadata Type name
     */
    public static final String ASSET = "Asset";

    /**
     * The SchemaAttribute Open Metadata Type name
     */
    public static final String SCHEMA_ATTRIBUTE = "SchemaAttribute";

    /**
     * The NestedSchemaAttribute Open Metadata Type name
     */
    public static final String NESTED_SCHEMA_ATTRIBUTE = "NestedSchemaAttribute";

    /**
     * The NestedSchemaAttribute Open Metadata Type unique identifier
     */
    public static final String NESTED_SCHEMA_ATTRIBUTE_GUID = "0ffb9d87-7074-45da-a9b0-ae0859611133";

    /**
     * The DeployedAPI Open Metadata Type name
     */
    public static final String DEPLOYED_API = "DeployedAPI";

    /**
     * The ITInfrastructure Open Metadata Type name
     */
    public static final String IT_INFRASTRUCTURE = "ITInfrastructure";

    /**
     * The Process Open Metadata Type name
     */
    public static final String PROCESS = "Process";

    /**
     * The DataStore Open Metadata Type name
     */
    public static final String DATA_STORE = "DataStore";

    /**
     * The DataSet Open Metadata Type name
     */
    public static final String DATA_SET = "DataSet";

    /**
     * The Database Open Metadata Type name
     */
    public static final String DATABASE = "Database";

    /**
     * The DataFile Open Metadata Type name
     */
    public static final String DATA_FILE = "DataFile";

    /**
     * The FileFolder Open Metadata Type name
     */
    public static final String FILE_FOLDER = "FileFolder";

    /**
     * The PortImplementation Open Metadata Type name
     */
    public static final String PORT_IMPLEMENTATION = "PortImplementation";

    /**
     * The Host Open Metadata Type name
     */
    public static final String HOST = "Host";

    /**
     * The Network Open Metadata Type name
     */
    public static final String NETWORK = "Network";

    /**
     * The Location Open Metadata Type name
     */
    public static final String LOCATION = "Location";

    /**
     * The Endpoint Open Metadata Type name
     */
    public static final String ENDPOINT = "Endpoint";

    /**
     * The Connection Open Metadata Type name
     */
    public static final String CONNECTION = "Connection";

    /**
     * The SoftwareServerPlatform Open Metadata Type name
     */
    public static final String SOFTWARE_SERVER_PLATFORM = "SoftwareServerPlatform";

    /**
     * The SoftwareServer Open Metadata Type name
     */
    public static final String SOFTWARE_SERVER = "SoftwareServer";

    /**
     * The HostCluster Open Metadata Type name
     */
    public static final String HOST_CLUSTER = "HostCluster";

    /**
     * The VirtualContainer Open Metadata Type name
     */
    public static final String VIRTUAL_CONTAINER = "VirtualContainer";


    //Relationships Type
    /**
     * The AssetSchemaType Open Metadata Type unique identifier
     */
    public static final String ASSET_SCHEMA_TYPE_GUID = "815b004d-73c6-4728-9dd9-536f4fe803cd";

    /**
     * The AssetSchemaType Open Metadata Type name
     */
    public static final String ASSET_SCHEMA_TYPE = "AssetSchemaType";

    /**
     * The PortSchema Open Metadata Type unique identifier
     */
    public static final String PORT_SCHEMA_GUID = "B216fA00-8281-F9CC-9911-Ae6377f2b457";

    /**
     * The PortSchema Open Metadata Type name
     */
    public static final String PORT_SCHEMA = "PortSchema";

    /**
     * The SoftwareServerPlatformDeployment Open Metadata Type unique identifier
     */
    public static final String SOFTWARE_SERVER_PLATFORM_DEPLOYMENT_GUID = "b909eb3b-5205-4180-9f63-122a65b30738";

    /**
     * The SoftwareServerPlatformDeployment Open Metadata Type name
     */
    public static final String SOFTWARE_SERVER_PLATFORM_DEPLOYMENT = "SoftwareServerPlatformDeployment";

    /**
     * The HostOperatingPlatform Open Metadata Type unique identifier
     */
    public static final String HOST_OPERATING_PLATFORM_GUID = "b9179df5-6e23-4581-a8b0-2919e6322b12";

    /**
     * The HostOperatingPlatform Open Metadata Type name
     */
    public static final String HOST_OPERATING_PLATFORM = "HostOperatingPlatform";

    /**
     * The ServerEndpoint Open Metadata Type unique identifier
     */
    public static final String SERVER_ENDPOINT_GUID = "2b8bfab4-8023-4611-9833-82a0dc95f187";

    /**
     * The ServerEndpoint Open Metadata Type name
     */
    public static final String SERVER_ENDPOINT = "ServerEndpoint";

    /**
     * The SoftwareServerDeployment Open Metadata Type unique identifier
     */
    public static final String SOFTWARE_SERVER_DEPLOYMENT_GUID = "d909eb3b-5205-4180-9f63-122a65b30738";

    /**
     * The SoftwareServerDeployment Open Metadata Type name
     */
    public static final String SOFTWARE_SERVER_DEPLOYMENT = "SoftwareServerDeployment";

    /**
     * The ConnectionToAsset Open Metadata Type unique identifier
     */
    public static final String CONNECTION_TO_ASSET_GUID = "e777d660-8dbe-453e-8b83-903771f054c0";

    /**
     * The ConnectionToAsset Open Metadata Type name
     */
    public static final String CONNECTION_TO_ASSET = "ConnectionToAsset";

    /**
     * The ConnectionConnectorType Open Metadata Type unique identifier
     */
    public static final String CONNECTION_CONNECTOR_TYPE_GUID = "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96";

    /**
     * The ConnectionConnectorType Open Metadata Type unique identifier
     */
    public static final String CONNECTION_CONNECTOR_TYPE = "ConnectionConnectorType";

    /**
     * The DataContentForDataSet Open Metadata Type unique identifier
     */
    public static final String DATA_CONTENT_FOR_DATA_SET_GUID = "b827683c-2924-4df3-a92d-7be1888e23c0";

    /**
     * The DataContentForDataSet Open Metadata Type name
     */
    public static final String DATA_CONTENT_FOR_DATA_SET = "DataContentForDataSet";

    /**
     * The FolderHierarchy Open Metadata Type unique identifier
     */
    public static final String FOLDER_HIERARCHY_GUID = "48ac9028-45dd-495d-b3e1-622685b54a01";

    /**
     * The FolderHierarchy Open Metadata Type name
     */
    public static final String FOLDER_HIERARCHY = "FolderHierarchy";

    /**
     * The NestedFile Open Metadata Type unique identifier
     */
    public static final String NESTED_FILE_GUID = "4cb88900-1446-4eb6-acea-29cd9da45e63";

    /**
     * The NestedFile Open Metadata Type name
     */
    public static final String NESTED_FILE = "NestedFile";

    /**
     * The ProcessPort Open Metadata Type unique identifier
     */
    public static final String PROCESS_PORT_GUID = "fB4E00CF-37e4-88CE-4a94-233BAdB84DA2";

    /**
     * The ProcessPort Open Metadata Type name
     */
    public static final String PROCESS_PORT = "ProcessPort";

    /**
     * The NetworkGatewayLink Open Metadata Type unique identifier
     */
    public static final String NETWORK_GATEWAY_LINK_GUID = "5bece460-1fa6-41fb-a29f-fdaf65ec8ce3";

    /**
     * The NetworkGatewayLink Open Metadata Type name
     */
    public static final String NETWORK_GATEWAY_LINK = "NetworkGatewayLink";

    /**
     * The HostNetwork Open Metadata Type unique identifier
     */
    public static final String HOST_NETWORK_GUID = "f2bd7401-c064-41ac-862c-e5bcdc98fa1e";

    /**
     * The HostNetwork Open Metadata Type name
     */
    public static final String HOST_NETWORK = "HostNetwork";

    /**
     * The DeployedVirtualContainer Open Metadata Type unique identifier
     */
    public static final String DEPLOYED_VIRTUAL_CONTAINER_GUID = "4b981d89-e356-4d9b-8f17-b3a8d5a86676";

    /**
     * The DeployedVirtualContainer Open Metadata Type name
     */
    public static final String DEPLOYED_VIRTUAL_CONTAINER = "DeployedVirtualContainer";

    /**
     * The HostClusterMember Open Metadata Type unique identifier
     */
    public static final String HOST_CLUSTER_MEMBER_GUID = "1a1c3933-a583-4b0c-9e42-c3691296a8e0";

    /**
     * The HostClusterMember Open Metadata Type name
     */
    public static final String HOST_CLUSTER_MEMBER = "HostClusterMember";

    /**
     * The HostLocation Open Metadata Type unique identifier
     */
    public static final String HOST_LOCATION_GUID = "f3066075-9611-4886-9244-32cc6eb07ea9";

    /**
     * The HostLocation Open Metadata Type name
     */
    public static final String HOST_LOCATION = "HostLocation";

    /**
     * The AssetLocation Open Metadata Type unique identifier
     */
    public static final String ASSET_LOCATION_GUID = "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1";

    /**
     * The AssetLocation Open Metadata Type name
     */
    public static final String ASSET_LOCATION = "AssetLocation";

    /**
     * The APIEndpoint Open Metadata Type unique identifier
     */
    public static final String API_ENDPOINT_GUID = "de5b9501-3ad4-4803-a8b2-e311c72a4336";

    /**
     * The APIEndpoint Open Metadata Type name
     */
    public static final String API_ENDPOINT = "APIEndpoint";

    /**
     * The ConnectionEndpoint Open Metadata Type unique identifier
     */
    public static final String CONNECTION_ENDPOINT_GUID = "887a7132-d6bc-4b92-a483-e80b60c86fb2";

    /**
     * The ConnectionEndpoint Open Metadata Type name
     */
    public static final String CONNECTION_ENDPOINT = "ConnectionEndpoint";

    /**
     * The SemanticAssignment Open Metadata Type unique identifier
     */
    public static final String SEMANTIC_ASSIGNMENT_GUID = "e6670973-645f-441a-bec7-6f5570345b92";

    /**
     * The SemanticAssignment Open Metadata Type name
     */
    public static final String SEMANTIC_ASSIGNMENT = "SemanticAssignment";

    /**
     * The SchemaAttributeType Open Metadata Type unique identifier
     */
    public static final String SCHEMA_ATTRIBUTE_TYPE_GUID = "2d955049-e59b-45dd-8e62-cde1add59f9e";

    /**
     * The SchemaAttributeType Open Metadata Type name
     */
    public static final String SCHEMA_ATTRIBUTE_TYPE = "SchemaAttributeType";

    /**
     * The AttributeForSchema Open Metadata Type unique identifier
     */
    public static final String ATTRIBUTE_FOR_SCHEMA_GUID = "86b176a2-015c-44a6-8106-54d5d69ba661";

    /**
     * The AttributeForSchema Open Metadata Type name
     */
    public static final String ATTRIBUTE_FOR_SCHEMA = "AttributeForSchema";
    //Instance Properties fields

    /**
     * The qualified name property
     */
    public static final String QUALIFIED_NAME = "qualifiedName";

    /**
     * The name property
     */
    public static final String NAME = "name";

    /**
     * The display name property
     */
    public static final String DISPLAY_NAME = "displayName";

    /**
     * The type property
     */
    public static final String TYPE_SEQUENCING = "type";

    /**
     * The GUID property
     */
    public static final String GUID_PARAMETER = "GUID";

    /**
     * The search parameter property
     */
    public static final String SEARCH_PARAMETER = "searchParameter";

    /**
     * The additional properties property
     */
    public static final String ADDITIONAL_PROPERTIES_PROPERTY_NAME = "additionalProperties";

    /**
     * The search criteria property
     */
    public static final String SEARCH_STRING_PARAMETER_NAME = "searchCriteria";
}
