/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.admin;

import java.time.Clock;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.connectors.outtopic.AssetCatalogOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.assetcatalog.converters.AssetCatalogConverter;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.AssetCatalogHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.RelationshipHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogBean;
import org.odpi.openmetadata.accessservices.assetcatalog.service.ClockService;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class AssetCatalogServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.ASSET_CATALOG_OMAS;
    private final AssetCatalogHandler assetCatalogHandler;
    private final RelationshipHandler relationshipHandler;

    AssetCatalogServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String serverUserName, String sourceName, List<String> supportedTypesForSearch, Connection inTopicEventBusConnection, Connection outTopicEventBusConnection) throws NewInstanceException {
        super(description.getAccessServiceName() + " OMAS", repositoryConnector, supportedZones, null, null, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), null, null, AssetCatalogOutTopicClientProvider.class.getName(), outTopicEventBusConnection);
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(AssetCatalogErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        AssetCatalogConverter<AssetCatalogBean> assetCatalogConverter = new AssetCatalogConverter<AssetCatalogBean>(this.repositoryHelper, this.serviceName, this.serverName);
        OpenMetadataAPIGenericHandler assetHandler = new OpenMetadataAPIGenericHandler(new AssetCatalogConverter(this.repositoryHelper, this.serviceName, this.serverName), AssetCatalogBean.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        ClockService clockService = new ClockService(Clock.systemUTC());
        this.assetCatalogHandler = new AssetCatalogHandler(this.serverName, sourceName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, (OpenMetadataAPIGenericHandler<AssetCatalogBean>)assetHandler, assetCatalogConverter, this.errorHandler, supportedZones, supportedTypesForSearch, clockService);
        this.relationshipHandler = new RelationshipHandler(sourceName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, (OpenMetadataAPIGenericHandler<AssetCatalogBean>)assetHandler, this.errorHandler, clockService);
    }

    public AssetCatalogHandler getAssetCatalogHandler() {
        return this.assetCatalogHandler;
    }

    public RelationshipHandler getRelationshipHandler() {
        return this.relationshipHandler;
    }
}

