/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.service;

import org.odpi.openmetadata.accessservices.assetcatalog.admin.AssetCatalogInstanceHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.handlers.RelationshipHandler;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCatalogRelationshipRESTService {
    private static final Logger log = LoggerFactory.getLogger(AssetCatalogRelationshipRESTService.class);
    private final AssetCatalogInstanceHandler instanceHandler = new AssetCatalogInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public RelationshipResponse getRelationshipBetweenEntities(String serverName, String userId, String entity1GUID, String entity2GUID, String relationshipType) {
        String methodName = "getRelationshipBetweenEntities";
        log.debug("Calling method: {}", (Object)"getRelationshipBetweenEntities");
        RelationshipResponse response = new RelationshipResponse();
        try {
            RelationshipHandler relationshipHandler = this.instanceHandler.getRelationshipHandler(userId, serverName, "getRelationshipBetweenEntities");
            Relationship relationshipBetweenEntities = relationshipHandler.getRelationshipBetweenEntities(userId, serverName, entity1GUID, entity2GUID, relationshipType);
            response.setRelationship(relationshipBetweenEntities);
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"getRelationshipBetweenEntities", (Object)response);
        return response;
    }
}

