/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.beans;

import java.util.List;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Edge;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Graph;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Rule;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.RuleNode;

public class InvertEdgeRule
implements Rule {
    private String edgeType;
    private String sourceNodeType;
    private String destinationNodeType;

    public String getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(String edgeType) {
        this.edgeType = edgeType;
    }

    public String getSourceNodeType() {
        return this.sourceNodeType;
    }

    public void setSourceNodeType(String sourceNodeType) {
        this.sourceNodeType = sourceNodeType;
    }

    public String getDestinationNodeType() {
        return this.destinationNodeType;
    }

    public void setDestinationNodeType(String destinationNodeType) {
        this.destinationNodeType = destinationNodeType;
    }

    @Override
    public void apply(Graph graph, String queriedNodeGUID) {
        for (Edge edge : graph.getEdges()) {
            List<RuleNode> nodes = graph.getNodes();
            if (this.edgeType == null || !this.edgeType.equals(edge.getLabel())) continue;
            this.invertEdge(nodes, edge);
        }
    }

    private void invertEdge(List<RuleNode> nodes, Edge edge) {
        if (this.getSourceNodeType() != null && this.getDestinationNodeType() != null) {
            this.applyRuleWithBothNodeTypes(nodes, edge);
        } else if (this.getSourceNodeType() != null && this.getDestinationNodeType() == null) {
            this.applyRuleWithOneNodeType(nodes, edge, edge.getFrom(), this.getSourceNodeType());
        } else if (this.getSourceNodeType() == null && this.getDestinationNodeType() != null) {
            this.applyRuleWithOneNodeType(nodes, edge, edge.getTo(), this.getDestinationNodeType());
        } else {
            this.invertEdgeDirection(edge);
        }
    }

    private void applyRuleWithBothNodeTypes(List<RuleNode> nodes, Edge edge) {
        block0: for (RuleNode node : nodes) {
            if (!node.getId().equals(edge.getFrom()) || !node.getGroup().equals(this.getSourceNodeType())) continue;
            for (RuleNode secondNode : nodes) {
                if (!secondNode.getId().equals(edge.getTo()) || !secondNode.getGroup().equals(this.getDestinationNodeType())) continue;
                this.invertEdgeDirection(edge);
                continue block0;
            }
        }
    }

    private void applyRuleWithOneNodeType(List<RuleNode> nodes, Edge edge, String nodeId, String ruleNodeType) {
        boolean findNode = false;
        for (RuleNode node : nodes) {
            if (node.getId().equals(nodeId) && node.getGroup().equals(ruleNodeType)) {
                findNode = true;
            }
            if (!findNode) continue;
            this.invertEdgeDirection(edge);
        }
    }

    private void invertEdgeDirection(Edge edge) {
        String originalFrom = edge.getFrom();
        String originalTo = edge.getTo();
        edge.setFrom(originalTo);
        edge.setTo(originalFrom);
    }
}

