/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum AssetCatalogAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMVS-ASSET-CATALOG-0001", AuditLogRecordSeverityLevel.STARTUP, "The Asset Catalog Open Metadata View Service (OMVS) is initializing", "The local server is initializing the Asset Catalog Open Metadata View Service. If the initialization is successful then audit message OMVS-ASSET-CATALOG-0002 will be issued, if there were errors then they should be shown in the audit log. ", "No action is required. This is part of the normal operation of the Asset Catalog Open Metadata View Service."),
    SERVICE_INITIALIZED("OMVS-ASSET-CATALOG-0002", AuditLogRecordSeverityLevel.STARTUP, "The Asset Catalog Open Metadata View Service (OMVS) is initialized", "The Asset Catalog OMVS has completed initialization. Calls will be accepted by this service, if OMRS is also configured and the view server has been started. ", "No action is required.  This is part of the normal operation of the Asset Catalog Open Metadata View Service. Once the OMRS is configured and the server is started, Asset Catalog view service requests can be accepted."),
    SERVICE_SHUTDOWN("OMVS-ASSET-CATALOG-0003", AuditLogRecordSeverityLevel.SHUTDOWN, "The Asset Catalog Open Metadata View Service (OMVS) is shutting down", "The local server has requested shutdown of the Asset Catalog OMVS.", "No action is required. The operator should verify that shutdown was intended. This is part of the normal operation of the Asset Catalog OMVS."),
    SERVICE_INSTANCE_FAILURE("OMVS-ASSET-CATALOG-0004", AuditLogRecordSeverityLevel.EXCEPTION, "The Asset Catalog Open Metadata View Service (OMVS) is unable to initialize a new instance; error message is {0}", "The view service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OMVS-ASSET-CATALOG-0005", AuditLogRecordSeverityLevel.SHUTDOWN, "The Asset Catalog Open Metadata View Service (OMVS) is shutting down server instance {0}", "The local handler has requested shut down of the Asset Catalog OMVS.", "No action is required. This is part of the normal operation of the service."),
    UNEXPECTED_EXCEPTION("OMVS-ASSET-CATALOG-0006", AuditLogRecordSeverityLevel.EXCEPTION, "The Open Metadata Service has generated an unexpected {0} exception during method {1}.  The message was: {2}", "The request returned an Exception.", "This is probably a logic error. Review the stack trace to identify where the error occurred and work to resolve the cause.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private AssetCatalogAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AssetCatalogAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "', messageDefinition=" + this.getMessageDefinition() + "}";
    }
}

