/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.AssetCatalogBean;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Classification;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Element;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.ElementOrigin;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Elements;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Relationship;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Type;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetCatalogResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetListResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.ElementHierarchyRequest;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageNodeNamesResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageSearchRequest;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageSearchResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageTypesResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageVertexResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.server.AssetCatalogInstanceHandler;
import org.slf4j.LoggerFactory;

public class AssetCatalogUIRESTServices
extends TokenController {
    private static final AssetCatalogInstanceHandler instanceHandler = new AssetCatalogInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetCatalogUIRESTServices.class), instanceHandler.getServiceName());
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final String sourceName = ViewServiceDescription.ASSET_CATALOG.getViewServiceName();
    private final List<ElementStatus> activeElementsOnly = new ArrayList<ElementStatus>(Collections.singleton(ElementStatus.ACTIVE));

    public AssetCatalogSupportedTypes getSupportedTypes(String serverName) {
        String methodName = "getSupportedTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getSupportedTypes");
        AssetCatalogSupportedTypes response = new AssetCatalogSupportedTypes();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getSupportedTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSupportedTypes");
            response.setTypes(instanceHandler.getSupportedAssetTypes(userId, serverName, "getSupportedTypes"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSupportedTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetListResponse searchAssets(String serverName, String searchCriteria, List<String> typeNames, String sequencingProperty, SequencingOrder sequencingOrder, boolean caseSensitive, boolean exactMatch, Integer startFrom, Integer pageSize) {
        String methodName = "searchAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "searchAssets");
        AssetListResponse response = new AssetListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "searchAssets");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "searchAssets");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "searchAssets");
            SearchProperties searchProperties = new SearchProperties();
            ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
            propertyConditions.add(this.getSearchStringPropertyCondition(searchCriteria, exactMatch, caseSensitive));
            searchProperties.setConditions(propertyConditions);
            searchProperties.setMatchCriteria(MatchCriteria.ALL);
            List results = handler.findMetadataElements(userId, null, null, searchProperties, this.activeElementsOnly, this.getMatchClassifications(instanceHandler.getSupportedAssetTypes(userId, serverName, "searchAssets"), typeNames), sequencingProperty, sequencingOrder, false, false, null, startFrom.intValue(), pageSize.intValue());
            response.setElementsList(this.getElementsList(results));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "searchAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private PropertyCondition getSearchStringPropertyCondition(String searchCriteria, boolean exactMatch, boolean caseSensitive) {
        PropertyCondition propertyCondition = new PropertyCondition();
        String searchString = exactMatch ? searchCriteria : instanceHandler.getSearchString(searchCriteria, false, false, !caseSensitive);
        PrimitiveTypePropertyValue propertyValue = new PrimitiveTypePropertyValue();
        propertyValue.setPrimitiveValue((Object)searchString);
        propertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        propertyCondition.setValue((PropertyValue)propertyValue);
        return propertyCondition;
    }

    private SearchClassifications getMatchClassifications(List<Type> supportAssetTypes, List<String> requestedAssetTypes) {
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        for (Type type : supportAssetTypes) {
            if (type == null || requestedAssetTypes == null || !requestedAssetTypes.contains(type.getName())) continue;
            ClassificationCondition classificationCondition = new ClassificationCondition();
            classificationCondition.setName(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
            SearchProperties searchProperties = new SearchProperties();
            ArrayList<PropertyCondition> typeNamePropertyConditions = new ArrayList<PropertyCondition>();
            PropertyCondition typeNamePropertyCondition = new PropertyCondition();
            typeNamePropertyCondition.setProperty(OpenMetadataProperty.ANCHOR_TYPE_NAME.name);
            PrimitiveTypePropertyValue propertyValue = new PrimitiveTypePropertyValue();
            propertyValue.setPrimitiveValue((Object)type.getName());
            propertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
            typeNamePropertyCondition.setValue((PropertyValue)propertyValue);
            typeNamePropertyCondition.setOperator(PropertyComparisonOperator.EQ);
            typeNamePropertyConditions.add(typeNamePropertyCondition);
            searchProperties.setConditions(typeNamePropertyConditions);
            searchProperties.setMatchCriteria(MatchCriteria.ALL);
            classificationCondition.setSearchProperties(searchProperties);
            classificationConditions.add(classificationCondition);
        }
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ANY);
        return searchClassifications;
    }

    public AssetListResponse searchAssetsByTypeName(String serverName, String typeName) {
        return null;
    }

    public AssetListResponse searchAssetsByTypeGUID(String serverName, String typeGUID) {
        return null;
    }

    public AssetCatalogResponse getAsset(String serverName, String guid) {
        return null;
    }

    public AssetResponse getAssetContext(String serverName, String guid) {
        return null;
    }

    public LineageResponse getUltimateSource(String serverName, String guid, boolean includeProcesses) {
        return null;
    }

    public LineageResponse getEndToEndLineage(String serverName, String guid, boolean includeProcesses) {
        return null;
    }

    public LineageResponse getUltimateDestination(String serverName, String guid, boolean includeProcesses) {
        return null;
    }

    public LineageResponse getSemanticLineage(String serverName, String guid, boolean includeProcesses) {
        return null;
    }

    public LineageVertexResponse getLineageVertex(String serverName, String guid) {
        return null;
    }

    public LineageTypesResponse getTypes(String serverName) {
        return null;
    }

    public LineageNodeNamesResponse getNodes(String serverName, String type, String searchValue, int limit) {
        return null;
    }

    public LineageSearchResponse searchForVertices(String serverName, LineageSearchRequest searchRequest) {
        return null;
    }

    public LineageResponse getElementHierarchy(String serverName, ElementHierarchyRequest elementHierarchyRequest) {
        return null;
    }

    private List<Elements> getElementsList(List<OpenMetadataElement> openMetadataElements) {
        return null;
    }

    private Element getElement(OpenMetadataElement openMetadataElement) {
        String methodName = "getElement";
        if (openMetadataElement != null) {
            Elements result = new Elements();
            result.setGuid(openMetadataElement.getElementGUID());
            result.setType(this.getType(openMetadataElement.getType()));
            result.setName(this.propertyHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.NAME.name, openMetadataElement.getElementProperties(), "getElement"));
            return result;
        }
        return null;
    }

    private AssetCatalogBean getAssetCatalogBean(OpenMetadataElement openMetadataElement, List<RelatedMetadataElements> relatedMetadataElementsList, Element anchorElement, String methodName) {
        if (openMetadataElement != null) {
            AssetCatalogBean assetCatalogBean = new AssetCatalogBean();
            assetCatalogBean.setGuid(openMetadataElement.getElementGUID());
            assetCatalogBean.setType(this.getType(openMetadataElement.getType()));
            assetCatalogBean.setCreatedBy(openMetadataElement.getVersions().getCreatedBy());
            assetCatalogBean.setCreateTime(openMetadataElement.getVersions().getCreateTime());
            assetCatalogBean.setUpdatedBy(openMetadataElement.getVersions().getUpdatedBy());
            assetCatalogBean.setUpdateTime(openMetadataElement.getVersions().getUpdateTime());
            assetCatalogBean.setVersion(openMetadataElement.getVersions().getVersion());
            assetCatalogBean.setStatus(openMetadataElement.getStatus().getName());
            assetCatalogBean.setClassifications(this.getClassifications(openMetadataElement.getClassifications()));
            assetCatalogBean.setOrigin(this.getElementOrigin(openMetadataElement.getOrigin()));
            assetCatalogBean.setUrl("/api/open-metadata/asset-catalog/assets/" + openMetadataElement.getElementGUID());
            if (openMetadataElement.getElementProperties() != null) {
                ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                assetCatalogBean.setName(this.propertyHelper.removeStringProperty(this.sourceName, OpenMetadataProperty.NAME.name, elementProperties, methodName));
                if (assetCatalogBean.getName() == null) {
                    assetCatalogBean.setName(this.propertyHelper.removeStringProperty(this.sourceName, OpenMetadataProperty.DISPLAY_NAME.name, elementProperties, methodName));
                }
                if (assetCatalogBean.getName() == null) {
                    assetCatalogBean.setName(this.propertyHelper.removeStringProperty(this.sourceName, OpenMetadataProperty.QUALIFIED_NAME.name, elementProperties, methodName));
                }
                assetCatalogBean.setAdditionalProperties(this.propertyHelper.removeStringMapFromProperty(this.sourceName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, elementProperties, methodName));
                assetCatalogBean.setProperties(elementProperties.getPropertiesAsStrings());
                assetCatalogBean.setAnchorElement(anchorElement);
            }
            assetCatalogBean.setRelationships(this.getRelationships(relatedMetadataElementsList));
        }
        return null;
    }

    private List<Classification> getClassifications(List<AttachedClassification> openMetadataClassifications) {
        if (openMetadataClassifications != null) {
            ArrayList<Classification> results = new ArrayList<Classification>();
            for (AttachedClassification attachedClassification : openMetadataClassifications) {
            }
            return results;
        }
        return null;
    }

    private List<Relationship> getRelationships(List<RelatedMetadataElements> relatedMetadataElementsList) {
        if (relatedMetadataElementsList != null) {
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            for (RelatedMetadataElements relatedMetadataElements : relatedMetadataElementsList) {
            }
            return results;
        }
        return null;
    }

    private ElementOrigin getElementOrigin(org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin openMetadataElementOrigin) {
        if (openMetadataElementOrigin != null) {
            ElementOrigin result = new ElementOrigin();
            result.setInstanceLicense(openMetadataElementOrigin.getLicense());
            result.setOriginCategory(openMetadataElementOrigin.getOriginCategory());
            result.setMetadataCollectionId(openMetadataElementOrigin.getHomeMetadataCollectionId());
            result.setMetadataCollectionName(openMetadataElementOrigin.getHomeMetadataCollectionName());
            result.setSourceServer(openMetadataElementOrigin.getSourceServer());
            return result;
        }
        return null;
    }

    private Type getType(ElementType openMetadataType) {
        if (openMetadataType != null) {
            Type type = new Type();
            type.setName(openMetadataType.getTypeName());
            type.setDescription(openMetadataType.getTypeDescription());
            type.setVersion(openMetadataType.getTypeVersion());
            if (openMetadataType.getSuperTypeNames() != null && !openMetadataType.getSuperTypeNames().isEmpty()) {
                type.setSuperType((String)openMetadataType.getSuperTypeNames().get(0));
            }
            return type;
        }
        return null;
    }
}

