/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.beans;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Edge;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Graph;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Rule;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.RuleNode;

public class PrimaryCategoryRule
implements Rule {
    private static final String TERM_CATEGORIZATION = "TermCategorization";
    private static final String REFERENCING_CATEGORY = "ReferencingCategory";
    private static final String PRIMARY_CATEGORY = "PrimaryCategory";
    private String edgeType;
    private String sourceNodeType;
    private String destinationNodeType;
    private String classificationProperty;

    public String getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(String edgeType) {
        this.edgeType = edgeType;
    }

    public String getSourceNodeType() {
        return this.sourceNodeType;
    }

    public void setSourceNodeType(String sourceNodeType) {
        this.sourceNodeType = sourceNodeType;
    }

    public String getDestinationNodeType() {
        return this.destinationNodeType;
    }

    public void setDestinationNodeType(String destinationNodeType) {
        this.destinationNodeType = destinationNodeType;
    }

    public String getClassificationProperty() {
        return this.classificationProperty;
    }

    public void setClassificationProperty(String classificationProperty) {
        this.classificationProperty = classificationProperty;
    }

    @Override
    public void apply(Graph graph, String queriedNodeGUID) {
        List<RuleNode> nodes = graph.getNodes();
        List<Edge> edges = graph.getEdges();
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        ArrayList<RuleNode> nodesToDrop = new ArrayList<RuleNode>();
        if (this.classificationProperty == null || this.edgeType == null) {
            return;
        }
        List<Edge> edgesWithProperLabel = graph.getEdges().stream().filter(e -> e.getLabel().equals(this.edgeType)).toList();
        for (Edge edge : edgesWithProperLabel) {
            String primaryCategoryQualifiedName = null;
            String glossaryTermGUID = null;
            for (RuleNode node : nodes) {
                RuleNode classificationNode;
                if (!node.getGroup().equals(this.sourceNodeType) || !node.getId().equals(edge.getFrom()) || !this.hasCorrectClassificationProperty(classificationNode = this.getSecondNode(nodes, edge))) continue;
                primaryCategoryQualifiedName = classificationNode.getProperties().get(this.classificationProperty);
                glossaryTermGUID = node.getId();
                nodesToDrop.add(classificationNode);
            }
            if (primaryCategoryQualifiedName == null) continue;
            String primaryCategoryGUID = this.getPrimaryCategoryGUID(nodes, primaryCategoryQualifiedName);
            this.markRelationships(edges, glossaryTermGUID, primaryCategoryGUID);
            edgesToRemove.add(edge);
        }
        graph.getNodes().removeAll(nodesToDrop);
        graph.getEdges().removeAll(edgesToRemove);
    }

    private RuleNode getSecondNode(List<RuleNode> nodes, Edge edge) {
        for (RuleNode secondNode : nodes) {
            if (!secondNode.getId().equals(edge.getTo()) || !this.destinationNodeType.equals(secondNode.getGroup())) continue;
            return secondNode;
        }
        return null;
    }

    private boolean hasCorrectClassificationProperty(RuleNode node) {
        return node != null && node.getProperties() != null && node.getProperties().containsKey(this.classificationProperty);
    }

    private String getPrimaryCategoryGUID(List<RuleNode> nodes, String primaryCategoryQualifiedName) {
        for (RuleNode node : nodes) {
            if (!primaryCategoryQualifiedName.equals(node.getQualifiedName())) continue;
            return node.getId();
        }
        return null;
    }

    private void markRelationships(List<Edge> edges, String glossaryTermGUID, String primaryCategoryGUID) {
        edges.stream().filter(edge -> this.isTermCategorizationAndCorrectNodes(glossaryTermGUID, (Edge)edge)).forEach(edge -> this.markRelationship(primaryCategoryGUID, (Edge)edge));
    }

    private void markRelationship(String primaryCategoryGUID, Edge e) {
        if (e.getTo().equals(primaryCategoryGUID) || e.getFrom().equals(primaryCategoryGUID)) {
            e.setType(PRIMARY_CATEGORY);
        } else {
            e.setType(REFERENCING_CATEGORY);
        }
    }

    private boolean isTermCategorizationAndCorrectNodes(String glossaryTermGUID, Edge e) {
        return e.getLabel().equals(TERM_CATEGORIZATION) && (e.getTo().equals(glossaryTermGUID) || e.getFrom().equals(glossaryTermGUID));
    }

    public String toString() {
        return "PrimaryCategoryRule{edgeType='" + this.edgeType + "', sourceNodeType='" + this.sourceNodeType + "', destinationNodeType='" + this.destinationNodeType + "', classificationProperty='" + this.classificationProperty + "'}";
    }
}

