/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.accessservices.assetconsumer.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.assetconsumer.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Type;

public class AssetCatalogInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.ASSET_CATALOG;
    private final AssetConsumer assetConsumerClient;
    private final OpenIntegrationServiceClient openIntegrationServiceClient;
    private final OpenMetadataStoreClient openMetadataStoreClient;
    private final List<Type> supportedAssetTypes;

    public AssetCatalogInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL, List<String> supportedAssetTypeNames) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.assetConsumerClient = new AssetConsumer(remoteServerName, remoteServerURL, auditLog);
        this.openIntegrationServiceClient = new OpenIntegrationServiceClient(remoteServerName, remoteServerURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(remoteServerName, remoteServerURL, maxPageSize);
        this.supportedAssetTypes = this.setupSupportedAssetTypes(supportedAssetTypeNames);
    }

    private List<Type> setupSupportedAssetTypes(List<String> supportedAssetTypeNames) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<Type> results = new ArrayList<Type>();
        if (supportedAssetTypeNames == null) {
            results.addAll(this.getTypesForTypeName(this.localServerUserId, OpenMetadataType.ASSET.typeName));
        } else {
            for (String supportedAssetTypeName : supportedAssetTypeNames) {
                results.addAll(this.getTypesForTypeName(this.localServerUserId, supportedAssetTypeName));
            }
        }
        HashMap<String, Type> resultMap = new HashMap<String, Type>();
        for (Type result : results) {
            resultMap.put(result.getName(), result);
        }
        return new ArrayList<Type>(resultMap.values());
    }

    private List<Type> getTypesForTypeName(String userId, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<Type> results = new ArrayList<Type>();
        OpenMetadataTypeDef openMetadataTypeDef = this.openMetadataStoreClient.getTypeDefByName(userId, typeName);
        if (openMetadataTypeDef != null) {
            results.add(this.convertOpenMetadataType(openMetadataTypeDef));
            List subTypes = this.openMetadataStoreClient.getSubTypes(userId, typeName);
            if (subTypes != null) {
                for (OpenMetadataTypeDef subType : subTypes) {
                    if (subType == null) continue;
                    results.add(this.convertOpenMetadataType(subType));
                }
            }
        }
        return results;
    }

    private Type convertOpenMetadataType(OpenMetadataTypeDef openMetadataType) {
        if (openMetadataType != null) {
            Type type = new Type();
            type.setName(openMetadataType.getName());
            type.setDescription(openMetadataType.getDescription());
            type.setVersion(openMetadataType.getVersion());
            if (openMetadataType.getSuperType() != null) {
                type.setSuperType(openMetadataType.getSuperType().getName());
            }
            return type;
        }
        return null;
    }

    public List<Type> getSupportedAssetTypes() {
        return this.supportedAssetTypes;
    }

    public AssetConsumer getAssetConsumerClient() {
        return this.assetConsumerClient;
    }

    public OpenIntegrationServiceClient getOpenIntegrationServiceClient() {
        return this.openIntegrationServiceClient;
    }

    public OpenMetadataStoreClient getOpenMetadataStoreClient() {
        return this.openMetadataStoreClient;
    }
}

