/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Edge;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Graph;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Rule;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.RuleNode;

public class IncompleteRule
implements Rule {
    private static final String INCOMPLETE = "Incomplete";
    public static final String TYPE = "type";
    private String edgeType;
    private String destinationNodeType;

    public String getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(String edgeType) {
        this.edgeType = edgeType;
    }

    public String getDestinationNodeType() {
        return this.destinationNodeType;
    }

    public void setDestinationNodeType(String destinationNodeType) {
        this.destinationNodeType = destinationNodeType;
    }

    @Override
    public void apply(Graph graph, String queriedNodeGUID) {
        if (this.edgeType == null) {
            return;
        }
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        ArrayList<RuleNode> nodesToRemove = new ArrayList<RuleNode>();
        List<RuleNode> graphNodes = graph.getNodes();
        List<Edge> edgesWithProperLabel = this.getEdgesWithProperLabel(graph);
        for (Edge edge : edgesWithProperLabel) {
            for (RuleNode node : graphNodes) {
                Optional<RuleNode> classificationNode;
                if (!node.getId().equals(edge.getFrom()) || !(classificationNode = this.getSecondNode(graphNodes, edge)).isPresent()) continue;
                nodesToRemove.add(classificationNode.get());
                node.getProperties().put(TYPE, INCOMPLETE);
                edgesToRemove.add(edge);
            }
        }
        graph.getNodes().removeAll(nodesToRemove);
        graph.getEdges().removeAll(edgesToRemove);
    }

    private List<Edge> getEdgesWithProperLabel(Graph graph) {
        return graph.getEdges().stream().filter(e -> e.getLabel().equals(this.edgeType)).collect(Collectors.toList());
    }

    private Optional<RuleNode> getSecondNode(List<RuleNode> nodes, Edge edge) {
        return nodes.stream().filter(node -> node.getId().equals(edge.getTo()) && this.destinationNodeType.equals(node.getGroup())).findAny();
    }

    public String toString() {
        return "IncompleteRule{edgeType='" + this.edgeType + "', destinationNodeType='" + this.destinationNodeType + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncompleteRule)) {
            return false;
        }
        IncompleteRule that = (IncompleteRule)o;
        return Objects.equals(this.edgeType, that.edgeType) && Objects.equals(this.destinationNodeType, that.destinationNodeType);
    }

    public int hashCode() {
        return Objects.hash(this.edgeType, this.destinationNodeType);
    }
}

