/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.converters;

import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.frameworks.openmetadata.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworkservices.omf.client.OpenMetadataClientBase;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Classification;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Element;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.ElementOrigin;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Type;

public abstract class AssetCatalogConverterBase<B>
extends OpenMetadataConverterBase<B> {
    public AssetCatalogConverterBase(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    private void fillInElementControlHeader(Element element, ElementControlHeader elementControlHeader) {
        element.setStatus(elementControlHeader.getStatus().getName());
        element.setOrigin(this.getOrigin(elementControlHeader));
        element.setType(this.getType(elementControlHeader.getType()));
        element.setVersion(elementControlHeader.getVersions().getVersion());
        element.setCreatedBy(elementControlHeader.getVersions().getCreatedBy());
        element.setCreateTime(elementControlHeader.getVersions().getCreateTime());
        element.setUpdatedBy(elementControlHeader.getVersions().getUpdatedBy());
        element.setUpdateTime(elementControlHeader.getVersions().getUpdateTime());
    }

    private Type getType(ElementType openMetadataType) {
        Type type = new Type();
        if (openMetadataType.getSuperTypeNames() != null) {
            type.setSuperType((String)openMetadataType.getSuperTypeNames().get(0));
        }
        type.setName(openMetadataType.getTypeName());
        type.setDescription(openMetadataType.getTypeDescription());
        type.setVersion(openMetadataType.getTypeVersion());
        return type;
    }

    private ElementOrigin getOrigin(ElementControlHeader elementControlHeader) {
        ElementOrigin elementOrigin = new ElementOrigin();
        elementOrigin.setOriginCategory(elementControlHeader.getOrigin().getOriginCategory());
        elementOrigin.setInstanceLicense(elementControlHeader.getOrigin().getLicense());
        elementOrigin.setSourceServer(elementControlHeader.getOrigin().getSourceServer());
        elementOrigin.setMetadataCollectionId(elementControlHeader.getOrigin().getHomeMetadataCollectionId());
        elementOrigin.setMetadataCollectionName(elementControlHeader.getOrigin().getHomeMetadataCollectionName());
        return elementOrigin;
    }

    private Element getAnchorElement(List<AttachedClassification> classifications, String userId, OpenMetadataClientBase client) {
        if (classifications != null) {
            // empty if block
        }
        return null;
    }

    private List<Classification> getClassifications(List<AttachedClassification> attachedClassifications) {
        return null;
    }

    private void fillInElement(Element element, OpenMetadataElement openMetadataElement, String userId, OpenMetadataClientBase client) {
        String methodName = "fillInElement";
        this.fillInElementControlHeader(element, (ElementControlHeader)openMetadataElement);
        element.setGuid(openMetadataElement.getElementGUID());
        element.setAnchorElement(this.getAnchorElement(openMetadataElement.getClassifications(), userId, client));
        element.setClassifications(this.getClassifications(openMetadataElement.getClassifications()));
        element.setName(this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, openMetadataElement.getElementProperties(), "fillInElement"));
        element.setOrigin(this.getOrigin((ElementControlHeader)openMetadataElement));
        element.setType(this.getType(openMetadataElement.getType()));
        element.setAdditionalProperties(this.propertyHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, openMetadataElement.getElementProperties(), "fillInElement"));
    }

    private void fillInElement(Element element, RelatedMetadataElement relatedMetadataElement, String userId, OpenMetadataClientBase client) {
        this.fillInElement(element, relatedMetadataElement.getElement(), userId, client);
    }
}

