/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.server.spring;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservice.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservice.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.service.AssetCatalogAssetService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/asset-catalog/users/{userId}"})
public class AssetCatalogEntityResource {
    private AssetCatalogAssetService assetService = new AssetCatalogAssetService();

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-summary/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetSummary(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId) {
        return this.assetService.getAssetSummaryById(userId, assetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-details/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetDetail(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId) {
        return this.assetService.getAssetDetailsById(userId, assetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-universe/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetUniverse(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId) {
        return this.assetService.getAssetUniverseByGUID(userId, assetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-relationships/{assetId}"}, produces={"application/json"})
    public RelationshipsResponse getAssetRelationships(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestParam(required=false, value="type") String relationshipType, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="order.Type") SequenceOrderType orderType, @RequestParam(required=false, value="order.Property") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.assetService.getAssetRelationships(userId, assetId, relationshipType, status, offset, limit, orderProperty, orderType);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-classifications/{assetId}"}, produces={"application/json"})
    public ClassificationsResponse getAssetByClassification(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset) {
        return this.assetService.getClassificationByAssetGUID(userId, assetId, limit, offset);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets-by-property/{propertyValue}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetsByProperty(@PathVariable(value="userId") String userId, @PathVariable(value="propertyValue") String propertyValue, @RequestParam(required=false, value="assetTypeId") String assetTypeId, @RequestParam(required=false, value="matchProperty") String matchProperty, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="orderType") SequenceOrderType orderType, @RequestParam(required=false, value="orderProperty") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.assetService.getAssetsByProperty(userId, assetTypeId, matchProperty, propertyValue, limit, offset, orderType, orderProperty, status);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets-by-classification-name/{classificationName}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetsByClassificationName(@PathVariable(value="userId") String userId, @PathVariable(value="classificationName") String classificationName, @RequestParam(required=false, value="assetTypeId") String assetTypeId, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="orderType") SequenceOrderType orderType, @RequestParam(required=false, value="orderProperty") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.assetService.getAssetsByClassificationName(userId, assetTypeId, classificationName, limit, offset, orderProperty, orderType, status);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets-linking-relationships/from/{assetId}/to/{endAssetId}"}, produces={"application/json"})
    public RelationshipsResponse getLinkingRelationships(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String startAssetId, @PathVariable(value="endAssetId") String endAssetId) {
        return this.assetService.getLinkingRelationships(userId, startAssetId, endAssetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/linking-assets/from/{assetId}/to/{endAssetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getLinkingAssets(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String startAssetId, @PathVariable(value="endAssetId") String endAssetId) {
        return this.assetService.getLinkingAssets(userId, startAssetId, endAssetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/related-assets/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getRelatedAssets(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestParam(required=false, value="instanceTypes") String instanceTypes, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="orderType") SequenceOrderType orderType, @RequestParam(required=false, value="orderProperty") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.assetService.getRelatedAssets(userId, assetId, instanceTypes, limit, offset, orderType, orderProperty, status);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets-from-neighborhood/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetsFromNeighborhood(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestParam(required=false, value="assetTypeIds") List<String> assetTypeIds, @RequestParam(required=false, value="relationshipTypes") List<String> relationshipTypes, @RequestParam(required=false, value="status") Status relationshipStatus, @RequestParam(required=false, value="level", defaultValue="0") Integer level) {
        return this.assetService.getAssetsFromNeighborhood(userId, assetId, assetTypeIds, relationshipTypes, relationshipStatus, level);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/related-relationships/{assetId}"}, produces={"application/json"})
    public RelationshipsResponse getRelationshipsFromNeighborhood(@PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestParam(required=false, value="assetTypeIds") List<String> assetTypeIds, @RequestParam(required=false, value="relationshipTypes") List<String> relationshipTypes, @RequestParam(required=false, value="status") Status relationshipStatus, @RequestParam(required=false, value="level", defaultValue="0") Integer level) {
        return this.assetService.getRelationshipsFromNeighborhood(userId, assetId, assetTypeIds, relationshipTypes, relationshipStatus, level);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/last-created"}, produces={"application/json"})
    public List<AssetDescription> getLastCreatedAssets(@PathVariable(value="userId") String userId, @RequestParam(required=false, value="assetTypeId") String assetTypeId, @RequestParam(required=false, value="fromDate") Date fromDate, @RequestParam(required=false, value="toDate") Date toDate, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="orderType") SequenceOrderType orderType, @RequestParam(required=false, value="orderProperty") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.assetService.getLastCreatedAssets(userId, assetTypeId, fromDate, toDate, status, limit, offset, orderType, orderProperty, status);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/last-updated"}, produces={"application/json"})
    public List<AssetDescription> getLastUpdatedAssets(@PathVariable(value="userId") String userId, @RequestParam(required=false, value="assetTypeId") String assetTypeId, @RequestParam(required=false, value="fromDate") Date fromDate, @RequestParam(required=false, value="toDate") Date toDate, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="orderType") SequenceOrderType orderType, @RequestParam(required=false, value="orderProperty") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.assetService.getLastUpdatedAssets(userId, assetTypeId, fromDate, toDate, status, limit, offset, orderType, orderProperty, status);
    }
}

